from typing import List
import java.io
import java.lang
import java.net
import java.util
import java.util.stream


class GhidraClassLoader(java.net.URLClassLoader):
    """
    Custom Ghidra URL class loader which exposes the addURL method so we can add to the classpath
     at runtime.  
 
     This class loader must be installed by setting the "java.system.class.loader" 
     system property prior to launch (i.e., the JVM should be launched with the following argument:
     -Djava.system.class.loader=ghidra.GhidraClassLoader.
    """





    def __init__(self, parent: java.lang.ClassLoader):
        """
        This one-argument constructor is required for the JVM to successfully use this class loader
         via the java.system.class.loader system property.
        @param parent The parent class loader for delegation
        """
        ...



    def addPath(self, path: unicode) -> bool:
        """
        Converts the specified path to a {@link URL} and adds it to the classpath.
        @param path The path to be added.
        @return True if the path was successfully added; otherwise, false.  Failure can occur if the 
           path is not able to be converted to a URL.
        @see #addURL(URL)
        """
        ...

    def addURL(self, url: java.net.URL) -> None: ...

    def clearAssertionStatus(self) -> None: ...

    def close(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def findResource(self, __a0: unicode) -> java.net.URL: ...

    def findResources(self, __a0: unicode) -> java.util.Enumeration: ...

    def getClass(self) -> java.lang.Class: ...

    def getDefinedPackage(self, __a0: unicode) -> java.lang.Package: ...

    def getDefinedPackages(self) -> List[java.lang.Package]: ...

    def getName(self) -> unicode: ...

    def getParent(self) -> java.lang.ClassLoader: ...

    @staticmethod
    def getPlatformClassLoader() -> java.lang.ClassLoader: ...

    def getResource(self, __a0: unicode) -> java.net.URL: ...

    def getResourceAsStream(self, __a0: unicode) -> java.io.InputStream: ...

    def getResources(self, __a0: unicode) -> java.util.Enumeration: ...

    @staticmethod
    def getSystemClassLoader() -> java.lang.ClassLoader: ...

    @staticmethod
    def getSystemResource(__a0: unicode) -> java.net.URL: ...

    @staticmethod
    def getSystemResourceAsStream(__a0: unicode) -> java.io.InputStream: ...

    @staticmethod
    def getSystemResources(__a0: unicode) -> java.util.Enumeration: ...

    def getURLs(self) -> List[java.net.URL]: ...

    def getUnnamedModule(self) -> java.lang.Module: ...

    def hashCode(self) -> int: ...

    def isRegisteredAsParallelCapable(self) -> bool: ...

    def loadClass(self, __a0: unicode) -> java.lang.Class: ...

    @overload
    @staticmethod
    def newInstance(__a0: List[java.net.URL]) -> java.net.URLClassLoader: ...

    @overload
    @staticmethod
    def newInstance(__a0: List[java.net.URL], __a1: java.lang.ClassLoader) -> java.net.URLClassLoader: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def resources(self, __a0: unicode) -> java.util.stream.Stream: ...

    def setClassAssertionStatus(self, __a0: unicode, __a1: bool) -> None: ...

    def setDefaultAssertionStatus(self, __a0: bool) -> None: ...

    def setPackageAssertionStatus(self, __a0: unicode, __a1: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

