import ghidra.framework.cmd
import ghidra.framework.model
import java.lang


class AddRegisterVarCmd(object, ghidra.framework.cmd.Command):
    """
    Command to add a register variable to a function.
    """





    @overload
    def __init__(self, addr: ghidra.program.model.address.Address, reg: ghidra.program.model.lang.Register, name: unicode, source: ghidra.program.model.symbol.SourceType):
        """
        Constructs a new command to add a register variable to a function.
        @param addr initial declaration point of variable.
        @param reg register for the new variable.
        @param name name of the new variable.
        @param source the source of this register variable
        """
        ...

    @overload
    def __init__(self, addr: ghidra.program.model.address.Address, reg: ghidra.program.model.lang.Register, name: unicode, dataType: ghidra.program.model.data.DataType, source: ghidra.program.model.symbol.SourceType):
        """
        Constructs a new command to add a register variable to a function.
        @param addr initial declaration point of variable.
        @param reg register for the new variable.
        @param name name of the new variable.
        @param dataType data type to set on the new variable
        @param source the source of this register variable
        """
        ...



    def applyTo(self, obj: ghidra.framework.model.DomainObject) -> bool:
        """
        @see ghidra.framework.cmd.Command#applyTo(ghidra.framework.model.DomainObject)
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getName(self) -> unicode:
        """
        @see ghidra.framework.cmd.Command#getName()
        """
        ...

    def getStatusMsg(self) -> unicode:
        """
        @see ghidra.framework.cmd.Command#getStatusMsg()
        """
        ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def name(self) -> unicode: ...

    @property
    def statusMsg(self) -> unicode: ...