from typing import List
import ghidra.app.decompiler.DecompileCallback
import ghidra.program.model.address
import ghidra.program.model.data
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.pcode
import ghidra.program.model.symbol
import java.lang


class DecompileDebug(object):
    """
    A container for collecting communication between the decompiler and the Ghidra database,
     as serviced through DecompileCallback during decompilation of a function.
     The query results can then be dumped as an XML document.
     The container is populated through methods that mirror the various methods in DecompileCallback.
    """





    def __init__(self, debugf: java.io.File): ...



    def addFlowOverride(self, addr: ghidra.program.model.address.Address, fo: ghidra.program.model.listing.FlowOverride) -> None: ...

    def addInject(self, addr: ghidra.program.model.address.Address, name: unicode, injectType: int, payload: unicode) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getBytes(self, addr: ghidra.program.model.address.Address, res: List[int]) -> None: ...

    def getCPoolRef(self, rec: unicode, refs: List[long]) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getCodeSymbol(self, addr: ghidra.program.model.address.Address, id: long, name: unicode, namespace: ghidra.program.model.symbol.Namespace) -> None: ...

    def getComments(self, comm: unicode) -> None: ...

    def getFNTypes(self, hfunc: ghidra.program.model.pcode.HighFunction) -> None: ...

    def getMapped(self, namespc: ghidra.program.model.symbol.Namespace, res: unicode) -> None: ...

    def getNamespacePath(self, namespace: ghidra.program.model.symbol.Namespace) -> None: ...

    def getPcode(self, addr: ghidra.program.model.address.Address, instr: ghidra.program.model.listing.Instruction) -> None: ...

    def getStringData(self, addr: ghidra.program.model.address.Address, stringData: ghidra.app.decompiler.DecompileCallback.StringData) -> None: ...

    def getTrackedRegisters(self, doc: unicode) -> None: ...

    def getType(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def hashCode(self) -> int: ...

    def nameIsUsed(self, spc: ghidra.program.model.symbol.Namespace, nm: unicode) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setFunction(self, f: ghidra.program.model.listing.Function) -> None: ...

    def setPcodeDataTypeManager(self, dtm: ghidra.program.model.pcode.PcodeDataTypeManager) -> None: ...

    def shutdown(self, pcodelanguage: ghidra.program.model.lang.Language, xmlOptions: unicode) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def function(self) -> None: ...  # No getter available.

    @function.setter
    def function(self, value: ghidra.program.model.listing.Function) -> None: ...

    @property
    def pcodeDataTypeManager(self) -> None: ...  # No getter available.

    @pcodeDataTypeManager.setter
    def pcodeDataTypeManager(self, value: ghidra.program.model.pcode.PcodeDataTypeManager) -> None: ...