from typing import Iterator
from typing import List
import ghidra.app.plugin.assembler.sleigh.grammars
import ghidra.app.plugin.assembler.sleigh.symbol
import ghidra.app.plugin.assembler.sleigh.tree
import java.io
import java.lang
import java.util
import java.util.function
import java.util.stream
import org.apache.commons.collections4.list


class AssemblySentential(org.apache.commons.collections4.list.AbstractListDecorator, java.lang.Comparable):
    """
    A "string" of symbols
 
     To avoid overloading the word "String", we call this a "sentential". Technically, to be a
     "sentential" in the classic sense, it must be a possible element in the derivation of a sentence
     in the grammar starting with the start symbol. We ignore that if only for the sake of naming.
    """

    WHITE_SPACE: ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal = _




    class TruncatedWhiteSpaceParseToken(ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential.WhiteSpaceParseToken):




        def __init__(self, __a0: ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar, __a1: ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal): ...



        def equals(self, __a0: object) -> bool: ...

        def generateString(self) -> unicode: ...

        def getClass(self) -> java.lang.Class: ...

        def getGrammar(self) -> ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar: ...

        def getParent(self) -> ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch: ...

        def getString(self) -> unicode: ...

        def getSym(self) -> ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol: ...

        def hashCode(self) -> int: ...

        def isConstructor(self) -> bool: ...

        def isNumeric(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def print(self, __a0: java.io.PrintStream) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class WhiteSpaceParseToken(ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseToken):




        def __init__(self, __a0: ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar, __a1: ghidra.app.plugin.assembler.sleigh.symbol.AssemblyTerminal, __a2: unicode): ...



        def equals(self, __a0: object) -> bool: ...

        def generateString(self) -> unicode: ...

        def getClass(self) -> java.lang.Class: ...

        def getGrammar(self) -> ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar: ...

        def getParent(self) -> ghidra.app.plugin.assembler.sleigh.tree.AssemblyParseBranch: ...

        def getString(self) -> unicode: ...

        def getSym(self) -> ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol: ...

        def hashCode(self) -> int: ...

        def isConstructor(self) -> bool: ...

        def isNumeric(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def print(self, __a0: java.io.PrintStream) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...



    @overload
    def __init__(self):
        """
        Construct a blank string
 
         This is suitable as a blank start, to add new symbols, or to use directly as the RHS,
         effectively creating an "epsilon" production.
        """
        ...

    @overload
    def __init__(self, syms: List[ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol]):
        """
        Construct a string from any number of symbols
        @param syms
        """
        ...

    @overload
    def __init__(self, __a0: List[object]): ...

    def __iter__(self): ...

    @overload
    def add(self, __a0: object) -> bool: ...

    @overload
    def add(self, __a0: int, __a1: object) -> None: ...

    @overload
    def addAll(self, __a0: java.util.Collection) -> bool: ...

    @overload
    def addAll(self, __a0: int, __a1: java.util.Collection) -> bool: ...

    def addWS(self) -> bool:
        """
        Add "optional" whitespace, if not already preceded by whitespace
        @return true if whitespace was added
        """
        ...

    def clear(self) -> None: ...

    @overload
    def compareTo(self, that: ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential) -> int: ...

    @overload
    def compareTo(self, __a0: object) -> int: ...

    def contains(self, __a0: object) -> bool: ...

    def containsAll(self, __a0: java.util.Collection) -> bool: ...

    @staticmethod
    def copyOf(__a0: java.util.Collection) -> List[object]: ...

    def equals(self, __a0: object) -> bool: ...

    def finish(self) -> None:
        """
        Trim leading and trailing whitespace, and make the string immutable
        """
        ...

    def forEach(self, __a0: java.util.function.Consumer) -> None: ...

    def get(self, __a0: int) -> object: ...

    def getClass(self) -> java.lang.Class: ...

    def hashCode(self) -> int: ...

    def indexOf(self, __a0: object) -> int: ...

    def isEmpty(self) -> bool: ...

    def iterator(self) -> java.util.Iterator: ...

    def lastIndexOf(self, __a0: object) -> int: ...

    @overload
    def listIterator(self) -> java.util.ListIterator: ...

    @overload
    def listIterator(self, __a0: int) -> java.util.ListIterator: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    @staticmethod
    def of() -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: List[object]) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object) -> List[object]: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object) -> List[object]: ...

    def parallelStream(self) -> java.util.stream.Stream: ...

    def removeAll(self, __a0: java.util.Collection) -> bool: ...

    def removeIf(self, __a0: java.util.function.Predicate) -> bool: ...

    def replaceAll(self, __a0: java.util.function.UnaryOperator) -> None: ...

    def retainAll(self, __a0: java.util.Collection) -> bool: ...

    def set(self, __a0: int, __a1: object) -> object: ...

    def size(self) -> int: ...

    def spliterator(self) -> java.util.Spliterator: ...

    def stream(self) -> java.util.stream.Stream: ...

    def subList(self, fromIndex: int, toIndex: int) -> ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential: ...

    @overload
    def toArray(self) -> List[object]: ...

    @overload
    def toArray(self, __a0: List[object]) -> List[object]: ...

    @overload
    def toArray(self, __a0: java.util.function.IntFunction) -> List[object]: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

