from typing import List
import generic.jar
import ghidra.app.plugin.core.datamgr
import ghidra.app.plugin.core.datamgr.archive
import ghidra.framework.model
import ghidra.framework.options
import ghidra.program.model.data
import ghidra.program.model.listing
import ghidra.util.task
import java.io
import java.lang
import java.util


class DataTypeManagerHandler(object):
    DATA_TYPE_ARCHIVE_PATH_KEY: unicode = u'DATATYPE_ARCHIVE_PATHS'
    DISABLED_DATA_TYPE_ARCHIVE_PATH_KEY: unicode = u'DISABLED_DATA_TYPE_ARCHIVE_PATH'
    OLD_DATA_TYPE_ARCHIVE_PATH_KEY: unicode = u'DATA_TYPE_ARCHIVE_PATH'



    def __init__(self, __a0: ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin): ...



    def addArchiveManagerListener(self, __a0: ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener) -> None: ...

    def addDataTypeManagerChangeListener(self, __a0: ghidra.program.model.data.DataTypeManagerChangeListener) -> None: ...

    def closeAllArchives(self) -> None: ...

    @overload
    def closeArchive(self, __a0: ghidra.app.plugin.core.datamgr.archive.Archive) -> None: ...

    @overload
    def closeArchive(self, __a0: ghidra.program.model.data.DataTypeManager) -> None: ...

    def createArchive(self, __a0: java.io.File) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    def createProjectArchive(self) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    def dispose(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fireArchiveStateChanged(self, __a0: ghidra.app.plugin.core.datamgr.archive.Archive) -> None: ...

    def fireDataTypeManagerChanged(self, __a0: ghidra.app.plugin.core.datamgr.archive.FileArchive) -> None: ...

    def getAllArchives(self) -> List[object]: ...

    def getAllFileOrProjectArchives(self) -> List[object]: ...

    def getAllModifiedFileArchives(self) -> List[object]: ...

    def getBuiltInDataTypesManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    def getClass(self) -> java.lang.Class: ...

    def getDataTypeIndexer(self) -> ghidra.app.plugin.core.datamgr.archive.DataTypeIndexer: ...

    def getDataTypeManager(self, __a0: ghidra.program.model.data.SourceArchive) -> ghidra.program.model.data.DataTypeManager: ...

    def getDataTypeManagers(self) -> List[ghidra.program.model.data.DataTypeManager]: ...

    def getFavoriteDataTypes(self) -> List[object]: ...

    def getPossibleEquateNames(self, __a0: long) -> java.util.Set: ...

    @overload
    def getProjectPathname(self, __a0: ghidra.app.plugin.core.datamgr.archive.ProjectArchive, __a1: bool) -> unicode: ...

    @overload
    @staticmethod
    def getProjectPathname(__a0: unicode, __a1: unicode) -> unicode: ...

    def getRecentlyDataType(self) -> ghidra.program.model.data.DataType: ...

    @staticmethod
    def handleArchiveFileException(__a0: ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin, __a1: generic.jar.ResourceFile, __a2: java.lang.Throwable) -> None: ...

    def hashCode(self) -> int: ...

    def isAllowedArchivePath(self, __a0: unicode) -> bool: ...

    def isInUse(self, __a0: java.io.File) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def openArchive(self, __a0: unicode) -> ghidra.program.model.data.DataTypeManager: ...

    @overload
    def openArchive(self, __a0: ghidra.program.model.listing.DataTypeArchive) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    @overload
    def openArchive(self, __a0: ghidra.program.model.listing.DataTypeArchive, __a1: ghidra.framework.model.DomainFile) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    @overload
    def openArchive(self, __a0: generic.jar.ResourceFile, __a1: bool, __a2: bool) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    @overload
    def openArchive(self, __a0: java.io.File, __a1: bool, __a2: bool) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    @overload
    def openArchive(self, __a0: ghidra.framework.model.DomainFile, __a1: bool, __a2: bool, __a3: ghidra.util.task.TaskMonitor) -> ghidra.app.plugin.core.datamgr.archive.Archive: ...

    @staticmethod
    def parseProjectPathname(__a0: unicode) -> List[unicode]: ...

    def programClosed(self) -> None: ...

    def programOpened(self, __a0: ghidra.program.model.listing.Program) -> None: ...

    def removeArchiveManagerListener(self, __a0: ghidra.app.plugin.core.datamgr.archive.ArchiveManagerListener) -> None: ...

    def removeDataTypeManagerChangeListener(self, __a0: ghidra.program.model.data.DataTypeManagerChangeListener) -> None: ...

    def removeInvalidArchive(self, __a0: ghidra.app.plugin.core.datamgr.archive.InvalidFileArchive) -> None: ...

    def restore(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    @overload
    def save(self, __a0: ghidra.framework.model.UndoableDomainObject) -> None: ...

    @overload
    def save(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def saveAs(self, __a0: ghidra.framework.model.UndoableDomainObject) -> None: ...

    def setRecentlyUsedDataType(self, __a0: ghidra.program.model.data.DataType) -> None: ...

    def toString(self) -> unicode: ...

    def updateKnownOpenArchives(self) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def allArchives(self) -> List[object]: ...

    @property
    def allFileOrProjectArchives(self) -> List[object]: ...

    @property
    def allModifiedFileArchives(self) -> List[object]: ...

    @property
    def builtInDataTypesManager(self) -> ghidra.program.model.data.DataTypeManager: ...

    @property
    def dataTypeIndexer(self) -> ghidra.app.plugin.core.datamgr.archive.DataTypeIndexer: ...

    @property
    def dataTypeManagers(self) -> List[ghidra.program.model.data.DataTypeManager]: ...

    @property
    def favoriteDataTypes(self) -> List[object]: ...

    @property
    def recentlyDataType(self) -> ghidra.program.model.data.DataType: ...

    @property
    def recentlyUsedDataType(self) -> None: ...  # No getter available.

    @recentlyUsedDataType.setter
    def recentlyUsedDataType(self, value: ghidra.program.model.data.DataType) -> None: ...