from typing import List
import ghidra.app.cmd.label
import ghidra.app.plugin.core.disassembler
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.util.task
import java.lang
import java.util


class AddressTable(object):
    BILLION_CASES: int = 1073741824
    MINIMUM_SAFE_ADDRESS: int = 1024
    TOO_MANY_ENTRIES: int = 1048576



    @overload
    def __init__(self, __a0: ghidra.program.model.address.Address, __a1: List[ghidra.program.model.address.Address], __a2: int, __a3: int, __a4: bool): ...

    @overload
    def __init__(self, __a0: ghidra.program.model.address.Address, __a1: List[ghidra.program.model.address.Address], __a2: ghidra.program.model.address.Address, __a3: int, __a4: int, __a5: int, __a6: bool): ...



    def changeEntry(self, __a0: int, __a1: ghidra.program.model.address.Address) -> None: ...

    def createSwitchTable(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.listing.Instruction, __a2: int, __a3: bool, __a4: ghidra.util.task.TaskMonitor) -> bool: ...

    def createTableIndex(self, __a0: ghidra.program.model.listing.Program) -> None: ...

    def disassemble(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.listing.Instruction, __a2: ghidra.util.task.TaskMonitor) -> bool: ...

    def equals(self, __a0: object) -> bool: ...

    def fixupFunctionBody(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.listing.Instruction, __a2: ghidra.util.task.TaskMonitor) -> None: ...

    @overload
    def getByteLength(self) -> int: ...

    @overload
    def getByteLength(self, __a0: int, __a1: int, __a2: bool) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getElementPrefix(self, __a0: int) -> unicode: ...

    @overload
    @staticmethod
    def getEntry(__a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.address.Address, __a2: ghidra.util.task.TaskMonitor, __a3: bool, __a4: int, __a5: int, __a6: int, __a7: long, __a8: bool) -> ghidra.app.plugin.core.disassembler.AddressTable: ...

    @overload
    @staticmethod
    def getEntry(__a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.address.Address, __a2: ghidra.util.task.TaskMonitor, __a3: bool, __a4: int, __a5: int, __a6: int, __a7: long, __a8: bool, __a9: bool, __a10: bool) -> ghidra.app.plugin.core.disassembler.AddressTable: ...

    def getFunctionEntries(self, __a0: ghidra.program.model.listing.Program, __a1: int) -> java.util.ArrayList: ...

    def getIndexLength(self) -> int: ...

    def getIndexName(self, __a0: int) -> unicode: ...

    def getNumberAddressEntries(self) -> int: ...

    def getTableBody(self) -> ghidra.program.model.address.AddressSetView: ...

    def getTableElements(self) -> List[ghidra.program.model.address.Address]: ...

    def getTableName(self, __a0: int) -> unicode: ...

    def getTableTypeString(self, __a0: ghidra.program.model.mem.Memory) -> unicode: ...

    @staticmethod
    def getThresholdRunOfValidPointers(__a0: ghidra.program.model.listing.Program, __a1: long) -> int: ...

    def getTopAddress(self) -> ghidra.program.model.address.Address: ...

    def getTopIndexAddress(self) -> ghidra.program.model.address.Address: ...

    def hashCode(self) -> int: ...

    def isFunctionTable(self, __a0: ghidra.program.model.listing.Program, __a1: int) -> bool: ...

    def isNegativeTable(self) -> bool: ...

    def labelTable(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.model.listing.Instruction, __a2: java.util.ArrayList, __a3: ghidra.app.cmd.label.AddLabelCmd) -> None: ...

    @overload
    def makeTable(self, __a0: ghidra.program.model.listing.Program, __a1: int, __a2: int, __a3: bool) -> bool: ...

    @overload
    def makeTable(self, __a0: ghidra.program.model.listing.Program, __a1: int, __a2: int, __a3: bool, __a4: bool) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setNegativeTable(self, __a0: bool) -> None: ...

    def toString(self) -> unicode: ...

    def truncate(self, __a0: int) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def byteLength(self) -> int: ...

    @property
    def indexLength(self) -> int: ...

    @property
    def negativeTable(self) -> bool: ...

    @negativeTable.setter
    def negativeTable(self, value: bool) -> None: ...

    @property
    def numberAddressEntries(self) -> int: ...

    @property
    def tableBody(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def tableElements(self) -> List[ghidra.program.model.address.Address]: ...

    @property
    def topAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def topIndexAddress(self) -> ghidra.program.model.address.Address: ...