from typing import List
import docking.widgets
import ghidra.app.nav
import ghidra.app.plugin.core.functiongraph
import ghidra.app.plugin.core.functiongraph.graph.layout
import ghidra.app.plugin.core.functiongraph.graph.vertex
import ghidra.app.plugin.core.functiongraph.mvc
import ghidra.app.services
import ghidra.app.util.viewer.format
import ghidra.app.util.viewer.listingpanel
import ghidra.framework.plugintool
import ghidra.graph.viewer
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.util
import java.awt
import java.awt.event
import java.awt.geom
import java.lang
import java.util
import javax.swing


class FGController(object, ghidra.app.util.viewer.listingpanel.ProgramLocationListener, ghidra.app.util.viewer.listingpanel.ProgramSelectionListener):




    def __init__(self, __a0: ghidra.app.plugin.core.functiongraph.FGProvider, __a1: ghidra.app.plugin.core.functiongraph.FunctionGraphPlugin): ...



    def addToGroup(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex, __a1: java.util.Set) -> None: ...

    def arePopupsEnabled(self) -> bool: ...

    def changeLayout(self, __a0: ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider) -> None: ...

    def cleanup(self) -> None: ...

    def clear(self) -> None: ...

    def display(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.util.ProgramLocation) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def formatChanged(self) -> None: ...

    def generateGroupVertexDescription(self, __a0: java.util.Set) -> unicode: ...

    def getClass(self) -> java.lang.Class: ...

    def getColorProvider(self) -> ghidra.app.plugin.core.functiongraph.FGColorProvider: ...

    def getFocusedVertex(self) -> ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex: ...

    def getFullFormatManager(self) -> ghidra.app.util.viewer.format.FormatManager: ...

    def getFunctionGraphData(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGData: ...

    def getFunctionGraphOptions(self) -> ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions: ...

    def getGraphPerspective(self, __a0: ghidra.program.util.ProgramLocation) -> ghidra.graph.viewer.GraphPerspectiveInfo: ...

    def getGraphedFunction(self) -> ghidra.program.model.listing.Function: ...

    def getLayoutProvider(self) -> ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider: ...

    def getMinimalFormatManager(self) -> ghidra.app.util.viewer.format.FormatManager: ...

    def getModel(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGModel: ...

    def getMostRecentColor(self) -> java.awt.Color: ...

    def getNavigatable(self) -> ghidra.app.nav.Navigatable: ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getProvider(self) -> ghidra.app.plugin.core.functiongraph.FGProvider: ...

    def getRecentColors(self) -> List[object]: ...

    def getSelectedVertices(self) -> java.util.Set: ...

    def getSharedHighlighterButtonPressedListener(self) -> ghidra.app.services.ButtonPressedListener: ...

    def getSharedStringSelectionListener(self) -> ghidra.app.util.viewer.listingpanel.StringSelectionListener: ...

    def getTool(self) -> ghidra.framework.plugintool.PluginTool: ...

    def getVertexFocusPathHighlightMode(self) -> ghidra.graph.viewer.PathHighlightMode: ...

    def getVertexHoverPathHighlightMode(self) -> ghidra.graph.viewer.PathHighlightMode: ...

    def getView(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGView: ...

    def getViewComponent(self) -> javax.swing.JComponent: ...

    def getViewerPointFromVertexPoint(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: java.awt.Point) -> java.awt.Point: ...

    @overload
    def groupSelectedVertices(self) -> None: ...

    @overload
    def groupSelectedVertices(self, __a0: java.awt.geom.Point2D) -> None: ...

    def hasResults(self) -> bool: ...

    def hashCode(self) -> int: ...

    def installGroupVertex(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex, __a1: java.awt.geom.Point2D) -> bool: ...

    def internalGoTo(self, __a0: ghidra.program.util.ProgramLocation, __a1: ghidra.program.model.listing.Program) -> None: ...

    def invalidateAllCacheForProgram(self, __a0: ghidra.program.model.listing.Program) -> None: ...

    def invalidateCacheForAddresses(self, __a0: ghidra.program.model.address.AddressSet) -> None: ...

    def isSatelliteDocked(self) -> bool: ...

    def isSatelliteVisible(self) -> bool: ...

    def isScaledPastInteractionThreshold(self) -> bool: ...

    def mergeVertexWithParent(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def primaryProviderHidden(self) -> None: ...

    def programClosed(self, __a0: ghidra.program.model.listing.Program) -> None: ...

    def programLocationChanged(self, __a0: ghidra.program.util.ProgramLocation, __a1: docking.widgets.EventTrigger) -> None: ...

    def programSelectionChanged(self, __a0: ghidra.program.util.ProgramSelection) -> None: ...

    def promptUserForGroupVertexText(self, __a0: javax.swing.JComponent, __a1: unicode, __a2: java.util.Set) -> unicode: ...

    def rebuildCurrentDisplay(self) -> None: ...

    def rebuildDisplay(self, __a0: ghidra.program.model.listing.Program, __a1: ghidra.program.util.ProgramLocation, __a2: bool) -> None: ...

    def refreshDisplayForAddress(self, __a0: ghidra.program.model.address.Address) -> None: ...

    def refreshDisplayWithoutRebuilding(self) -> None: ...

    def regroupVertices(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex) -> None: ...

    def removeColor(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex) -> None: ...

    def repaint(self) -> None: ...

    def requestFocus(self) -> None: ...

    def resetGraph(self) -> None: ...

    def restoreVertexColors(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes) -> None: ...

    def satelliteProviderShown(self) -> None: ...

    def saveVertexColors(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes) -> None: ...

    def setFunctionGraphData(self, __a0: ghidra.app.plugin.core.functiongraph.mvc.FGData) -> None: ...

    def setGraphPerspective(self, __a0: ghidra.graph.viewer.GraphPerspectiveInfo) -> None: ...

    def setHighlight(self, __a0: ghidra.program.util.ProgramSelection) -> None: ...

    def setPopupsVisible(self, __a0: bool) -> None: ...

    def setSelection(self, __a0: ghidra.program.util.ProgramSelection) -> None: ...

    def setStatusMessage(self, __a0: unicode) -> None: ...

    def setVertexFocusPathHighlightMode(self, __a0: ghidra.graph.viewer.PathHighlightMode) -> None: ...

    def setVertexHoverPathHighlightMode(self, __a0: ghidra.graph.viewer.PathHighlightMode) -> None: ...

    def setVertexViewMode(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: bool) -> None: ...

    def showFormatChooser(self) -> None: ...

    def showXRefsDialog(self) -> None: ...

    def splitVertex(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: ghidra.program.model.address.Address) -> None: ...

    def synchronizeProgramLocationAfterEdit(self) -> None: ...

    def synchronizeProgramLocationToVertex(self, __a0: ghidra.program.util.ProgramLocation) -> None: ...

    def toString(self) -> unicode: ...

    def translateMouseEventFromVertexToViewSpace(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: java.awt.event.MouseEvent) -> java.awt.event.MouseEvent: ...

    def translateRectangleFromVertexToViewSpace(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex, __a1: java.awt.Rectangle) -> java.awt.Rectangle: ...

    def ungroupAllVertices(self) -> None: ...

    def ungroupVertex(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def zoomInGraph(self) -> None: ...

    def zoomOutGraph(self) -> None: ...

    def zoomToVertex(self, __a0: ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex) -> None: ...

    def zoomToWindow(self) -> None: ...

    @property
    def colorProvider(self) -> ghidra.app.plugin.core.functiongraph.FGColorProvider: ...

    @property
    def focusedVertex(self) -> ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex: ...

    @property
    def fullFormatManager(self) -> ghidra.app.util.viewer.format.FormatManager: ...

    @property
    def functionGraphData(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGData: ...

    @functionGraphData.setter
    def functionGraphData(self, value: ghidra.app.plugin.core.functiongraph.mvc.FGData) -> None: ...

    @property
    def functionGraphOptions(self) -> ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions: ...

    @property
    def graphPerspective(self) -> None: ...  # No getter available.

    @graphPerspective.setter
    def graphPerspective(self, value: ghidra.graph.viewer.GraphPerspectiveInfo) -> None: ...

    @property
    def graphedFunction(self) -> ghidra.program.model.listing.Function: ...

    @property
    def highlight(self) -> None: ...  # No getter available.

    @highlight.setter
    def highlight(self, value: ghidra.program.util.ProgramSelection) -> None: ...

    @property
    def layoutProvider(self) -> ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider: ...

    @property
    def minimalFormatManager(self) -> ghidra.app.util.viewer.format.FormatManager: ...

    @property
    def model(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGModel: ...

    @property
    def mostRecentColor(self) -> java.awt.Color: ...

    @property
    def navigatable(self) -> ghidra.app.nav.Navigatable: ...

    @property
    def popupsVisible(self) -> None: ...  # No getter available.

    @popupsVisible.setter
    def popupsVisible(self, value: bool) -> None: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def provider(self) -> ghidra.app.plugin.core.functiongraph.FGProvider: ...

    @property
    def recentColors(self) -> List[object]: ...

    @property
    def satelliteDocked(self) -> bool: ...

    @property
    def satelliteVisible(self) -> bool: ...

    @property
    def scaledPastInteractionThreshold(self) -> bool: ...

    @property
    def selectedVertices(self) -> java.util.Set: ...

    @property
    def selection(self) -> None: ...  # No getter available.

    @selection.setter
    def selection(self, value: ghidra.program.util.ProgramSelection) -> None: ...

    @property
    def sharedHighlighterButtonPressedListener(self) -> ghidra.app.services.ButtonPressedListener: ...

    @property
    def sharedStringSelectionListener(self) -> ghidra.app.util.viewer.listingpanel.StringSelectionListener: ...

    @property
    def statusMessage(self) -> None: ...  # No getter available.

    @statusMessage.setter
    def statusMessage(self, value: unicode) -> None: ...

    @property
    def tool(self) -> ghidra.framework.plugintool.PluginTool: ...

    @property
    def vertexFocusPathHighlightMode(self) -> ghidra.graph.viewer.PathHighlightMode: ...

    @vertexFocusPathHighlightMode.setter
    def vertexFocusPathHighlightMode(self, value: ghidra.graph.viewer.PathHighlightMode) -> None: ...

    @property
    def vertexHoverPathHighlightMode(self) -> ghidra.graph.viewer.PathHighlightMode: ...

    @vertexHoverPathHighlightMode.setter
    def vertexHoverPathHighlightMode(self, value: ghidra.graph.viewer.PathHighlightMode) -> None: ...

    @property
    def view(self) -> ghidra.app.plugin.core.functiongraph.mvc.FGView: ...

    @property
    def viewComponent(self) -> javax.swing.JComponent: ...