from typing import List
import generic.jar
import ghidra.app.plugin.processors.generic
import ghidra.app.plugin.processors.sleigh
import ghidra.app.plugin.processors.sleigh.symbol
import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.program.model.util
import ghidra.util
import ghidra.util.task
import ghidra.xml
import java.lang
import java.util


class SleighLanguage(object, ghidra.program.model.lang.Language):
    SLA_FORMAT_VERSION: int = 2







    def applyContextSettings(self, programContext: ghidra.program.model.listing.DefaultProgramContext) -> None: ...

    def buildTranslatorTag(self, factory: ghidra.program.model.address.AddressFactory, uniqueOffset: long, optionalSymTab: ghidra.app.plugin.processors.sleigh.symbol.SymbolTable) -> unicode:
        """
        Generates a limited translator XML tag for the specified address factory and optional register set.
        @param factory address factory
        @param uniqueOffset the initial offset within the unique address space to start assigning temporary registers
        @param optionalSymTab optional symbol table to be passed (may be null to omit).  Only non-context registers
         and user-defined pcodeop's are included.
        @return the entire XML tag as a String
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def getAdditionalInject(self) -> List[ghidra.program.model.lang.InjectPayloadSleigh]: ...

    def getAddressFactory(self) -> ghidra.program.model.address.AddressFactory: ...

    def getClass(self) -> java.lang.Class: ...

    def getCompatibleCompilerSpecDescriptions(self) -> List[ghidra.program.model.lang.CompilerSpecDescription]: ...

    def getCompilerSpecByID(self, compilerSpecID: ghidra.program.model.lang.CompilerSpecID) -> ghidra.program.model.lang.CompilerSpec: ...

    def getContextBaseRegister(self) -> ghidra.program.model.lang.Register: ...

    def getContextRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    def getDefaultCompilerSpec(self) -> ghidra.program.model.lang.CompilerSpec: ...

    def getDefaultDataSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    def getDefaultMemoryBlocks(self) -> List[ghidra.app.plugin.processors.generic.MemoryBlockDefinition]: ...

    def getDefaultPointerWordSize(self) -> int:
        """
        @deprecated Will be removed once we have better way to attach address spaces to pointer data-types
        @return the default wordsize to use when analyzing pointer offsets
        """
        ...

    def getDefaultSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    def getDefaultSymbols(self) -> List[ghidra.program.model.util.AddressLabelInfo]: ...

    def getInstructionAlignment(self) -> int: ...

    def getLanguageDescription(self) -> ghidra.program.model.lang.LanguageDescription: ...

    def getLanguageID(self) -> ghidra.program.model.lang.LanguageID: ...

    def getManualEntry(self, instruction: unicode) -> ghidra.util.ManualEntry: ...

    def getManualException(self) -> java.lang.Exception: ...

    def getManualInstructionMnemonicKeys(self) -> java.util.Set: ...

    def getMinorVersion(self) -> int: ...

    def getNumberOfUserDefinedOpNames(self) -> int: ...

    def getParallelInstructionHelper(self) -> ghidra.program.model.lang.ParallelInstructionLanguageHelper: ...

    def getProcessor(self) -> ghidra.program.model.lang.Processor: ...

    def getProgramCounter(self) -> ghidra.program.model.lang.Register: ...

    @overload
    def getProperty(self, key: unicode) -> unicode: ...

    @overload
    def getProperty(self, key: unicode, defaultString: unicode) -> unicode: ...

    def getPropertyAsBoolean(self, key: unicode, defaultBoolean: bool) -> bool: ...

    def getPropertyAsInt(self, key: unicode, defaultInt: int) -> int: ...

    def getPropertyKeys(self) -> java.util.Set: ...

    @overload
    def getRegister(self, name: unicode) -> ghidra.program.model.lang.Register: ...

    @overload
    def getRegister(self, addr: ghidra.program.model.address.Address, size: int) -> ghidra.program.model.lang.Register: ...

    @overload
    def getRegister(self, addrspc: ghidra.program.model.address.AddressSpace, offset: long, size: int) -> ghidra.program.model.lang.Register: ...

    def getRegisterNames(self) -> List[unicode]: ...

    @overload
    def getRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    @overload
    def getRegisters(self, address: ghidra.program.model.address.Address) -> List[ghidra.program.model.lang.Register]: ...

    def getRootDecisionNode(self) -> ghidra.app.plugin.processors.sleigh.DecisionNode: ...

    def getSegmentedSpace(self) -> unicode: ...

    def getSortedVectorRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    def getSymbolTable(self) -> ghidra.app.plugin.processors.sleigh.symbol.SymbolTable: ...

    def getUniqueAllocationMask(self) -> int: ...

    def getUniqueBase(self) -> long:
        """
        Returns the unique base offset from which additional temporary variables
         may be created.
        @return unique base offset
        """
        ...

    def getUserDefinedOpName(self, index: int) -> unicode: ...

    def getVersion(self) -> int: ...

    def getVolatileAddresses(self) -> ghidra.program.model.address.AddressSetView: ...

    def hasManual(self) -> bool: ...

    def hasProperty(self, key: unicode) -> bool: ...

    def hashCode(self) -> int: ...

    def isBigEndian(self) -> bool: ...

    def isVolatile(self, addr: ghidra.program.model.address.Address) -> bool: ...

    def loadIndex(self, processorFile: generic.jar.ResourceFile) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def numSections(self) -> int:
        """
        @return (maximum) number of named p-code sections
        """
        ...

    def parse(self, buf: ghidra.program.model.mem.MemBuffer, context: ghidra.program.model.lang.ProcessorContext, inDelaySlot: bool) -> ghidra.program.model.lang.InstructionPrototype: ...

    def parseSegmentOp(self, el: ghidra.xml.XmlElement, parser: ghidra.xml.XmlPullParser) -> ghidra.program.model.lang.InjectPayloadSleigh: ...

    def reloadLanguage(self, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def supportsPcode(self) -> bool: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def additionalInject(self) -> List[object]: ...

    @property
    def addressFactory(self) -> ghidra.program.model.address.AddressFactory: ...

    @property
    def bigEndian(self) -> bool: ...

    @property
    def compatibleCompilerSpecDescriptions(self) -> List[object]: ...

    @property
    def contextBaseRegister(self) -> ghidra.program.model.lang.Register: ...

    @property
    def contextRegisters(self) -> List[object]: ...

    @property
    def defaultCompilerSpec(self) -> ghidra.program.model.lang.CompilerSpec: ...

    @property
    def defaultDataSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    @property
    def defaultMemoryBlocks(self) -> List[ghidra.app.plugin.processors.generic.MemoryBlockDefinition]: ...

    @property
    def defaultPointerWordSize(self) -> int: ...

    @property
    def defaultSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    @property
    def defaultSymbols(self) -> List[object]: ...

    @property
    def instructionAlignment(self) -> int: ...

    @property
    def languageDescription(self) -> ghidra.program.model.lang.LanguageDescription: ...

    @property
    def languageID(self) -> ghidra.program.model.lang.LanguageID: ...

    @property
    def manualException(self) -> java.lang.Exception: ...

    @property
    def manualInstructionMnemonicKeys(self) -> java.util.Set: ...

    @property
    def minorVersion(self) -> int: ...

    @property
    def numberOfUserDefinedOpNames(self) -> int: ...

    @property
    def parallelInstructionHelper(self) -> ghidra.program.model.lang.ParallelInstructionLanguageHelper: ...

    @property
    def processor(self) -> ghidra.program.model.lang.Processor: ...

    @property
    def programCounter(self) -> ghidra.program.model.lang.Register: ...

    @property
    def propertyKeys(self) -> java.util.Set: ...

    @property
    def registerNames(self) -> List[object]: ...

    @property
    def registers(self) -> List[object]: ...

    @property
    def rootDecisionNode(self) -> ghidra.app.plugin.processors.sleigh.DecisionNode: ...

    @property
    def segmentedSpace(self) -> unicode: ...

    @property
    def sortedVectorRegisters(self) -> List[object]: ...

    @property
    def symbolTable(self) -> ghidra.app.plugin.processors.sleigh.symbol.SymbolTable: ...

    @property
    def uniqueAllocationMask(self) -> int: ...

    @property
    def uniqueBase(self) -> long: ...

    @property
    def version(self) -> int: ...

    @property
    def volatileAddresses(self) -> ghidra.program.model.address.AddressSetView: ...