from typing import Iterator
from typing import List
import ghidra.app.util
import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.program.model.pcode
import ghidra.program.model.scalar
import ghidra.program.model.symbol
import ghidra.util
import ghidra.util.prop
import java.lang


class PseudoInstruction(ghidra.app.util.PseudoCodeUnit, ghidra.program.model.listing.Instruction, ghidra.program.model.lang.InstructionContext):
    """
    Pseudo (i.e., fake) instruction that is generated by the Disassembler.  This form of 
     has some limitation over an instruction which is obtained from a program listing.
     The instruction will completely cache all bytes corresponding to the prototype length
     at the specified address.  Additional bytes will be cached for delay-slotted instructions
     to facilitate pcode generation and obtaining general pcode related attributes.
    """





    @overload
    def __init__(self, addr: ghidra.program.model.address.Address, prototype: ghidra.program.model.lang.InstructionPrototype, memBuffer: ghidra.program.model.mem.MemBuffer, procContext: ghidra.program.model.lang.ProcessorContext):
        """
        Construct a new PseudoInstruction without a program (flow override not supported).
        @param addr address of the instruction
        @param prototype prototype of the instruction
        @param memBuffer buffer containing the bytes for the instruction
        @param procContext processor state information during disassembly
        @throws AddressOverflowException if code unit length causes wrap within space
        """
        ...

    @overload
    def __init__(self, addrFactory: ghidra.program.model.address.AddressFactory, addr: ghidra.program.model.address.Address, prototype: ghidra.program.model.lang.InstructionPrototype, memBuffer: ghidra.program.model.mem.MemBuffer, procContext: ghidra.program.model.lang.ProcessorContext):
        """
        Construct a new PseudoInstruction within a program.
        @param addrFactory program/language address factory
        @param addr address of the instruction
        @param prototype prototype of the instruction
        @param memBuffer buffer containing the bytes for the instruction
        @param procContext processor state information during disassembly
        @throws AddressOverflowException if code unit length causes wrap within space
        """
        ...

    @overload
    def __init__(self, program: ghidra.program.model.listing.Program, addr: ghidra.program.model.address.Address, prototype: ghidra.program.model.lang.InstructionPrototype, memBuffer: ghidra.program.model.mem.MemBuffer, procContext: ghidra.program.model.lang.ProcessorContext):
        """
        Construct a new PseudoInstruction within a program.
        @param program
        @param addr address of the instruction
        @param prototype prototype of the instruction
        @param memBuffer buffer containing the bytes for the instruction
        @param procContext processor state information during disassembly
        @throws AddressOverflowException if code unit length causes wrap within space
        """
        ...



    def addMnemonicReference(self, refAddr: ghidra.program.model.address.Address, refType: ghidra.program.model.symbol.RefType, sourceType: ghidra.program.model.symbol.SourceType) -> None:
        """
        Add a reference to the mnemonic for this code unit.
        @param refAddr address of reference to add
        @param refType type of reference being added
        """
        ...

    def addOperandReference(self, opIndex: int, refAddr: ghidra.program.model.address.Address, type: ghidra.program.model.symbol.RefType, sourceType: ghidra.program.model.symbol.SourceType) -> None:
        """
        Add a user defined reference to the operand at the given index.
        @see CodeUnit#addOperandReference(int, Address, RefType, SourceType)
        """
        ...

    def clearFallThroughOverride(self) -> None: ...

    def clearRegister(self, register: ghidra.program.model.lang.Register) -> None: ...

    def compareTo(self, a: ghidra.program.model.address.Address) -> int:
        """
        Compares the given address to the address range of this node.
        @param a the address
        @return a negative integer if addr is greater than the maximum range
                 address zero if addr is in the range a positive integer if addr
                 is less than minimum range address
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def contains(self, testAddr: ghidra.program.model.address.Address) -> bool:
        """
        Determines if this code unit contains the indicated address.
        @param testAddr the address to test
        @return true if address is contained in the range.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    @overload
    @staticmethod
    def dumpContextValue(__a0: ghidra.program.model.lang.RegisterValue, __a1: unicode) -> unicode: ...

    @overload
    @staticmethod
    def dumpContextValue(__a0: ghidra.program.model.lang.RegisterValue, __a1: unicode, __a2: java.lang.StringBuilder) -> None: ...

    def equals(self, obj: object) -> bool: ...

    @overload
    def getAddress(self) -> ghidra.program.model.address.Address:
        """
        Get the Address which corresponds to the offset 0.
        @return the current address of offset 0.
        """
        ...

    @overload
    def getAddress(self, opIndex: int) -> ghidra.program.model.address.Address: ...

    def getAddressString(self, showBlockName: bool, pad: bool) -> unicode: ...

    def getBaseContextRegister(self) -> ghidra.program.model.lang.Register: ...

    def getBigInteger(self, offset: int, size: int, signed: bool) -> long: ...

    def getByte(self, offset: int) -> int:
        """
        Get one byte from memory at the current position plus offset.
        @param offset the displacement from the current position.
        @return the data at offset from the current position.
        @throws AddressOutOfBoundsException if offset exceeds address space
        @throws IndexOutOfBoundsException if offset is negative
        @throws MemoryAccessException if memory cannot be read
        """
        ...

    @overload
    def getBytes(self) -> List[int]:
        """
        Gets the bytes for this code unit.
        """
        ...

    @overload
    def getBytes(self, b: List[int], offset: int) -> int: ...

    def getBytesInCodeUnit(self, buffer: List[int], bufferOffset: int) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getComment(self, commentType: int) -> unicode: ...

    def getCommentAsArray(self, commentType: int) -> List[unicode]:
        """
        Get the comment as an array where each element is a single line for the
         given type.
        @param commentType must be either EOL_COMMENT_TYPE, PRE_COMMENT_TYPE,
                    POST_COMMENT_TYPE, or PLATE_COMMENT_TYPE
        @throws IllegalArgumentException if type is not one of the three types of comments supported
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getDefaultFallThrough(self) -> ghidra.program.model.address.Address: ...

    def getDefaultFallThroughOffset(self) -> int: ...

    def getDefaultFlows(self) -> List[ghidra.program.model.address.Address]: ...

    def getDefaultOperandRepresentation(self, opIndex: int) -> unicode: ...

    def getDefaultOperandRepresentationList(self, opIndex: int) -> List[object]: ...

    def getDelaySlotDepth(self) -> int: ...

    def getExternalReference(self, opIndex: int) -> ghidra.program.model.symbol.ExternalReference: ...

    def getFallFrom(self) -> ghidra.program.model.address.Address: ...

    def getFallThrough(self) -> ghidra.program.model.address.Address: ...

    def getFlowOverride(self) -> ghidra.program.model.listing.FlowOverride: ...

    def getFlowType(self) -> ghidra.program.model.symbol.FlowType: ...

    def getFlows(self) -> List[ghidra.program.model.address.Address]: ...

    def getInputObjects(self) -> List[object]: ...

    def getInstructionContext(self) -> ghidra.program.model.lang.InstructionContext: ...

    def getInt(self, offset: int) -> int: ...

    def getIntProperty(self, name: unicode) -> int:
        """
        Get the int property for name.
        @param name the name of the property.
        @throws NoValueException if there is not name property for this code unit
        @throws TypeMismatchException if the property manager for name does not support int types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getLabel(self) -> unicode:
        """
        Get the label for this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        @deprecated
        """
        ...

    def getLength(self) -> int:
        """
        Get the length of the code unit.
        """
        ...

    def getLong(self, offset: int) -> long: ...

    def getMaxAddress(self) -> ghidra.program.model.address.Address:
        """
        Get the ending address for this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getMemBuffer(self) -> ghidra.program.model.mem.MemBuffer: ...

    def getMemory(self) -> ghidra.program.model.mem.Memory:
        """
        Get the Memory object actually used by the MemBuffer.
 
         return the Memory used by this MemBuffer.
        """
        ...

    def getMinAddress(self) -> ghidra.program.model.address.Address:
        """
        Get the starting address for this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getMnemonicReferences(self) -> List[ghidra.program.model.symbol.Reference]:
        """
        Get references for the mnemonic for this instruction.
        """
        ...

    def getMnemonicString(self) -> unicode: ...

    def getNext(self) -> ghidra.program.model.listing.Instruction: ...

    def getNextCodeUnit(self) -> ghidra.program.model.listing.CodeUnit:
        """
        Get the code unit after this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getNumOperands(self) -> int: ...

    def getObjectProperty(self, name: unicode) -> ghidra.util.Saveable:
        """
        Get the object property for name; returns null if there is no name
         property for this code unit.
        @param name the name of the property.
        @throws TypeMismatchException if the property manager for name does not support object
                     types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getOpObjects(self, opIndex: int) -> List[object]: ...

    def getOperandRefType(self, opIndex: int) -> ghidra.program.model.symbol.RefType: ...

    def getOperandReferences(self, opIndex: int) -> List[ghidra.program.model.symbol.Reference]: ...

    def getOperandType(self, opIndex: int) -> int: ...

    @overload
    def getParserContext(self) -> ghidra.program.model.lang.ParserContext: ...

    @overload
    def getParserContext(self, instructionAddress: ghidra.program.model.address.Address) -> ghidra.program.model.lang.ParserContext: ...

    @overload
    def getPcode(self) -> List[ghidra.program.model.pcode.PcodeOp]: ...

    @overload
    def getPcode(self, opIndex: int) -> List[ghidra.program.model.pcode.PcodeOp]: ...

    @overload
    def getPcode(self, includeOverrides: bool) -> List[ghidra.program.model.pcode.PcodeOp]: ...

    def getPrevious(self) -> ghidra.program.model.listing.Instruction: ...

    def getPreviousCodeUnit(self) -> ghidra.program.model.listing.CodeUnit:
        """
        Get the code unit before this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getPrimaryReference(self, index: int) -> ghidra.program.model.symbol.Reference: ...

    def getPrimarySymbol(self) -> ghidra.program.model.symbol.Symbol:
        """
        Get the primary Symbol for this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getProcessorContext(self) -> ghidra.program.model.lang.ProcessorContextView: ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getPrototype(self) -> ghidra.program.model.lang.InstructionPrototype: ...

    def getReferenceIteratorTo(self) -> ghidra.program.model.symbol.ReferenceIterator: ...

    def getReferencesFrom(self) -> List[ghidra.program.model.symbol.Reference]:
        """
        Get ALL reference FROM this code unit.
        """
        ...

    @overload
    def getRegister(self, opIndex: int) -> ghidra.program.model.lang.Register: ...

    @overload
    def getRegister(self, name: unicode) -> ghidra.program.model.lang.Register: ...

    def getRegisterValue(self, register: ghidra.program.model.lang.Register) -> ghidra.program.model.lang.RegisterValue: ...

    def getRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    def getRepeatedByte(self) -> int:
        """
        Return the byte value repeated for all bytes within this instruction or null
         if byte values vary.
        @return repeated byte value or null if bytes vary
        """
        ...

    def getResultObjects(self) -> List[object]: ...

    def getScalar(self, opIndex: int) -> ghidra.program.model.scalar.Scalar: ...

    def getSeparator(self, opIndex: int) -> unicode: ...

    def getShort(self, offset: int) -> int: ...

    def getStackReference(self, opIndex: int) -> ghidra.program.model.symbol.StackReference: ...

    def getStringProperty(self, name: unicode) -> unicode:
        """
        Get the string property for name; returns null if there is no name
         property for this code unit.
        @param name the name of the property.
        @throws TypeMismatchException if the property manager for name does not support string
                     types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getSymbols(self) -> List[ghidra.program.model.symbol.Symbol]:
        """
        Get the symbols for this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def getUnsignedByte(self, __a0: int) -> int: ...

    def getUnsignedInt(self, __a0: int) -> long: ...

    def getUnsignedShort(self, __a0: int) -> int: ...

    def getValue(self, register: ghidra.program.model.lang.Register, signed: bool) -> long: ...

    def getVarLengthInt(self, __a0: int, __a1: int) -> int: ...

    def getVarLengthUnsignedInt(self, __a0: int, __a1: int) -> long: ...

    def getVoidProperty(self, name: unicode) -> bool:
        """
        Returns whether this code unit is marked as having the name property.
        @param name the name of the property.
        @throws TypeMismatchException if the property manager for name does not support void types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def hasFallthrough(self) -> bool: ...

    def hasProperty(self, name: unicode) -> bool: ...

    def hasValue(self, register: ghidra.program.model.lang.Register) -> bool: ...

    def hashCode(self) -> int: ...

    def invalidate(self) -> None:
        """
        Invalidate memory buffer
        """
        ...

    def isBigEndian(self) -> bool: ...

    def isFallThroughOverridden(self) -> bool: ...

    def isFallthrough(self) -> bool: ...

    def isInDelaySlot(self) -> bool: ...

    def isInitializedMemory(self) -> bool: ...

    def isSuccessor(self, codeUnit: ghidra.program.model.listing.CodeUnit) -> bool:
        """
        Return true if the given CodeUnit follows directly after this code unit.
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def isValid(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def propertyNames(self) -> Iterator[unicode]: ...

    def removeExternalReference(self, opIndex: int) -> None: ...

    def removeMnemonicReference(self, refAddr: ghidra.program.model.address.Address) -> None:
        """
        Remove a reference to the mnemonic for this instruction.
        """
        ...

    def removeOperandReference(self, opIndex: int, refAddr: ghidra.program.model.address.Address) -> None:
        """
        Remove a user defined reference to the operand at opIndex.
        """
        ...

    def removeProperty(self, name: unicode) -> None:
        """
        Remove the property value with the given name for this code unit.
        @param name the name of the property.
        """
        ...

    def removeStackReference(self, opIndex: int) -> None: ...

    def setComment(self, commentType: int, comment: unicode) -> None:
        """
        Set the comment for the given type.
        @param commentType must be either EOL_COMMENT, PRE_COMMENT, POST_COMMENT, or
                    PLATE_COMMENT
        @param comment the comment
        @throws IllegalArgumentException if type is not one of the three types of comments supported
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def setCommentAsArray(self, commentType: int, comment: List[unicode]) -> None:
        """
        Set the comment for the given type.
        @param commentType must be either EOL_COMMENT, PRE_COMMENT, POST_COMMENT, or
                    PLATE_COMMENT
        @param comment the lines that make up the comment
        @throws IllegalArgumentException if type is not one of the three types of comments supported
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def setExternalReference(self, ref: ghidra.program.model.symbol.Reference) -> None: ...

    def setFallThrough(self, addr: ghidra.program.model.address.Address) -> None: ...

    def setFlowOverride(self, flowOverride: ghidra.program.model.listing.FlowOverride) -> None: ...

    def setInstructionBlock(self, bl: ghidra.program.model.lang.InstructionBlock) -> None: ...

    def setMemoryReference(self, opIndex: int, refAddr: ghidra.program.model.address.Address, refType: ghidra.program.model.symbol.RefType) -> None: ...

    def setPrimaryMemoryReference(self, ref: ghidra.program.model.symbol.Reference) -> None: ...

    @overload
    def setProperty(self, name: unicode) -> None:
        """
        Mark the property name as having a value for this code unit.
        @param name the name of the property to save.
        @throws TypeMismatchException if the property manager for name does not support void types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    @overload
    def setProperty(self, name: unicode, value: int) -> None:
        """
        Set the property name with the given value for this code unit.
        @param name the name of the property to save.
        @param value the value of the property to save.
        @throws TypeMismatchException if the property manager for name does not support int types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    @overload
    def setProperty(self, name: unicode, value: unicode) -> None:
        """
        Set the property name with the given value for this code unit.
        @param name the name of the property to save.
        @param value the value of the property to save.
        @throws TypeMismatchException if the property manager for name does not support string
                     types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    @overload
    def setProperty(self, name: unicode, value: ghidra.util.Saveable) -> None:
        """
        Set the property name with the given value for this code unit.
        @param name the name of the property to save.
        @param value the value of the property to save.
        @throws TypeMismatchException if the property manager for name does not support object
                     types
        @throws ConcurrentModificationException if this object is no longer valid.
        """
        ...

    def setRegisterReference(self, opIndex: int, reg: ghidra.program.model.lang.Register, sourceType: ghidra.program.model.symbol.SourceType, refType: ghidra.program.model.symbol.RefType) -> None: ...

    def setRegisterValue(self, value: ghidra.program.model.lang.RegisterValue) -> None: ...

    def setStackReference(self, opIndex: int, offset: int, sourceType: ghidra.program.model.symbol.SourceType, refType: ghidra.program.model.symbol.RefType) -> None: ...

    def setValue(self, register: ghidra.program.model.lang.Register, value: long) -> None: ...

    def toString(self) -> unicode: ...

    def visitProperty(self, visitor: ghidra.util.prop.PropertyVisitor, propertyName: unicode) -> None:
        """
        Invokes the visit() method of the specified PropertyVisitor if the named
         property exists for this code unit.
        @param visitor the class implementing the PropertyVisitor interface.
        @param propertyName the name of the property to be visited.
        """
        ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def address(self) -> ghidra.program.model.address.Address: ...

    @property
    def baseContextRegister(self) -> ghidra.program.model.lang.Register: ...

    @property
    def bigEndian(self) -> bool: ...

    @property
    def bytes(self) -> List[int]: ...

    @property
    def defaultFallThrough(self) -> ghidra.program.model.address.Address: ...

    @property
    def defaultFallThroughOffset(self) -> int: ...

    @property
    def defaultFlows(self) -> List[ghidra.program.model.address.Address]: ...

    @property
    def delaySlotDepth(self) -> int: ...

    @property
    def externalReference(self) -> None: ...  # No getter available.

    @externalReference.setter
    def externalReference(self, value: ghidra.program.model.symbol.Reference) -> None: ...

    @property
    def fallFrom(self) -> ghidra.program.model.address.Address: ...

    @property
    def fallThrough(self) -> ghidra.program.model.address.Address: ...

    @fallThrough.setter
    def fallThrough(self, value: ghidra.program.model.address.Address) -> None: ...

    @property
    def fallThroughOverridden(self) -> bool: ...

    @property
    def fallthrough(self) -> bool: ...

    @property
    def flowOverride(self) -> ghidra.program.model.listing.FlowOverride: ...

    @flowOverride.setter
    def flowOverride(self, value: ghidra.program.model.listing.FlowOverride) -> None: ...

    @property
    def flowType(self) -> ghidra.program.model.symbol.FlowType: ...

    @property
    def flows(self) -> List[ghidra.program.model.address.Address]: ...

    @property
    def inDelaySlot(self) -> bool: ...

    @property
    def inputObjects(self) -> List[object]: ...

    @property
    def instructionBlock(self) -> None: ...  # No getter available.

    @instructionBlock.setter
    def instructionBlock(self, value: ghidra.program.model.lang.InstructionBlock) -> None: ...

    @property
    def instructionContext(self) -> ghidra.program.model.lang.InstructionContext: ...

    @property
    def label(self) -> unicode: ...

    @property
    def maxAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def memBuffer(self) -> ghidra.program.model.mem.MemBuffer: ...

    @property
    def memory(self) -> ghidra.program.model.mem.Memory: ...

    @property
    def minAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def mnemonicReferences(self) -> List[ghidra.program.model.symbol.Reference]: ...

    @property
    def mnemonicString(self) -> unicode: ...

    @property
    def next(self) -> ghidra.program.model.listing.Instruction: ...

    @property
    def nextCodeUnit(self) -> ghidra.program.model.listing.CodeUnit: ...

    @property
    def numOperands(self) -> int: ...

    @property
    def parserContext(self) -> ghidra.program.model.lang.ParserContext: ...

    @property
    def pcode(self) -> List[ghidra.program.model.pcode.PcodeOp]: ...

    @property
    def previous(self) -> ghidra.program.model.listing.Instruction: ...

    @property
    def previousCodeUnit(self) -> ghidra.program.model.listing.CodeUnit: ...

    @property
    def primaryMemoryReference(self) -> None: ...  # No getter available.

    @primaryMemoryReference.setter
    def primaryMemoryReference(self, value: ghidra.program.model.symbol.Reference) -> None: ...

    @property
    def primarySymbol(self) -> ghidra.program.model.symbol.Symbol: ...

    @property
    def processorContext(self) -> ghidra.program.model.lang.ProcessorContextView: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def property(self) -> None: ...  # No getter available.

    @property.setter
    def property(self, value: unicode) -> None: ...

    @property
    def prototype(self) -> ghidra.program.model.lang.InstructionPrototype: ...

    @property
    def referenceIteratorTo(self) -> ghidra.program.model.symbol.ReferenceIterator: ...

    @property
    def referencesFrom(self) -> List[ghidra.program.model.symbol.Reference]: ...

    @property
    def registerValue(self) -> None: ...  # No getter available.

    @registerValue.setter
    def registerValue(self, value: ghidra.program.model.lang.RegisterValue) -> None: ...

    @property
    def registers(self) -> List[object]: ...

    @property
    def repeatedByte(self) -> int: ...

    @property
    def resultObjects(self) -> List[object]: ...

    @property
    def symbols(self) -> List[ghidra.program.model.symbol.Symbol]: ...

    @property
    def valid(self) -> bool: ...