from typing import List
import ghidra.app.util.bin.format.dwarf4.expression
import java.io
import java.lang


class DWARFExpressionException(java.lang.Exception):
    """
    A exception that is thrown when dealing with DWARFExpression
     or when they are DWARFExpressionEvaluator
 
     Use this class when you want to pass the DWARFExpression and
     the opcode / step in the expression that caused the problem back up the call chain.
    """





    @overload
    def __init__(self): ...

    @overload
    def __init__(self, message: unicode): ...

    @overload
    def __init__(self, cause: java.lang.Throwable): ...

    @overload
    def __init__(self, message: unicode, cause: java.lang.Throwable): ...

    @overload
    def __init__(self, message: unicode, expr: ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression, step: int): ...

    @overload
    def __init__(self, message: unicode, expr: ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression, step: int, cause: java.lang.Throwable): ...



    def addSuppressed(self, __a0: java.lang.Throwable) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fillInStackTrace(self) -> java.lang.Throwable: ...

    def getCause(self) -> java.lang.Throwable: ...

    def getClass(self) -> java.lang.Class: ...

    def getExpression(self) -> ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression: ...

    def getLocalizedMessage(self) -> unicode: ...

    def getMessage(self) -> unicode: ...

    def getStackTrace(self) -> List[java.lang.StackTraceElement]: ...

    def getStep(self) -> int: ...

    def getSuppressed(self) -> List[java.lang.Throwable]: ...

    def hashCode(self) -> int: ...

    def initCause(self, __a0: java.lang.Throwable) -> java.lang.Throwable: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def printStackTrace(self) -> None: ...

    @overload
    def printStackTrace(self, __a0: java.io.PrintStream) -> None: ...

    @overload
    def printStackTrace(self, __a0: java.io.PrintWriter) -> None: ...

    def setExpression(self, expr: ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression) -> None: ...

    def setStackTrace(self, __a0: List[java.lang.StackTraceElement]) -> None: ...

    def setStep(self, step: int) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def expression(self) -> ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression: ...

    @expression.setter
    def expression(self, value: ghidra.app.util.bin.format.dwarf4.expression.DWARFExpression) -> None: ...

    @property
    def message(self) -> unicode: ...

    @property
    def step(self) -> int: ...

    @step.setter
    def step(self, value: int) -> None: ...