import ghidra.app.util.bin
import ghidra.app.util.bin.format.objc2
import ghidra.program.model.data
import java.lang


class ObjectiveC2_ClassRW(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    NAME: unicode = u'class_rw_t'
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    @overload
    def __init__(self): ...

    @overload
    def __init__(self, state: ghidra.app.util.bin.format.objc2.ObjectiveC2_State, reader: ghidra.app.util.bin.BinaryReader): ...



    def applyTo(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getBaseMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    def getBaseProperties(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList: ...

    def getBaseProtocols(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList: ...

    def getClass(self) -> java.lang.Class: ...

    def getFlags(self) -> long: ...

    def getIndex(self) -> long: ...

    def getInstanceSize(self) -> long: ...

    def getInstanceStart(self) -> long: ...

    def getInstanceVariables(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_InstanceVariableList: ...

    def getName(self) -> unicode: ...

    def getReserved(self) -> long: ...

    def getWeakIvarLayout(self) -> long: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def baseMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    @property
    def baseProperties(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList: ...

    @property
    def baseProtocols(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList: ...

    @property
    def flags(self) -> long: ...

    @property
    def index(self) -> long: ...

    @property
    def instanceSize(self) -> long: ...

    @property
    def instanceStart(self) -> long: ...

    @property
    def instanceVariables(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_InstanceVariableList: ...

    @property
    def name(self) -> unicode: ...

    @property
    def reserved(self) -> long: ...

    @property
    def weakIvarLayout(self) -> long: ...