import ghidra.app.util.bin
import ghidra.app.util.bin.format.objc2
import ghidra.program.model.data
import ghidra.program.model.symbol
import java.lang


class ObjectiveC2_Protocol(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    NAME: unicode = u'protocol_t'
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, state: ghidra.app.util.bin.format.objc2.ObjectiveC2_State, reader: ghidra.app.util.bin.BinaryReader): ...



    def applyTo(self, namespace: ghidra.program.model.symbol.Namespace) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getClassMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    def getIndex(self) -> long: ...

    def getInstanceMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    def getInstanceProperties(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList: ...

    def getIsa(self) -> long: ...

    def getName(self) -> unicode: ...

    def getOptionalClassMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    def getOptionalInstanceMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    def getProtocols(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList: ...

    def getUnknown0(self) -> long: ...

    def getUnknown1(self) -> long: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def classMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    @property
    def index(self) -> long: ...

    @property
    def instanceMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    @property
    def instanceProperties(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList: ...

    @property
    def isa(self) -> long: ...

    @property
    def name(self) -> unicode: ...

    @property
    def optionalClassMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    @property
    def optionalInstanceMethods(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList: ...

    @property
    def protocols(self) -> ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList: ...

    @property
    def unknown0(self) -> long: ...

    @property
    def unknown1(self) -> long: ...