import ghidra.app.util.bin
import ghidra.app.util.bin.format.objectiveC
import ghidra.program.model.data
import java.lang


class ObjectiveC1_Category(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    SIZEOF: long = 0x0L
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, state: ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State, reader: ghidra.app.util.bin.BinaryReader): ...



    def applyTo(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getCategoryName(self) -> unicode: ...

    def getClass(self) -> java.lang.Class: ...

    def getClassMethods(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    def getClassName(self) -> unicode: ...

    def getInstanceMethods(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    def getProtocols(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList: ...

    def getUnknown0(self) -> int: ...

    def getUnknown1(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def categoryName(self) -> unicode: ...

    @property
    def classMethods(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    @property
    def className(self) -> unicode: ...

    @property
    def instanceMethods(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    @property
    def protocols(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList: ...

    @property
    def unknown0(self) -> int: ...

    @property
    def unknown1(self) -> int: ...