import ghidra.app.util.bin
import ghidra.app.util.bin.format.objectiveC
import ghidra.program.model.data
import java.lang


class ObjectiveC1_Class(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    NAME: unicode = u'objc_class'
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    SIZEOF: long = 0x30L
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, state: ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State, reader: ghidra.app.util.bin.BinaryReader): ...



    def applyTo(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getCache(self) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getISA(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MetaClass: ...

    def getInfo(self) -> int: ...

    def getInstanceSize(self) -> int: ...

    def getInstanceVariableList(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_InstanceVariableList: ...

    def getMethodList(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    def getName(self) -> unicode: ...

    def getProtocols(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList: ...

    def getSuperClass(self) -> unicode: ...

    def getUnknown0(self) -> int: ...

    def getUnknown1(self) -> int: ...

    def getVersion(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def ISA(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MetaClass: ...

    @property
    def cache(self) -> int: ...

    @property
    def info(self) -> int: ...

    @property
    def instanceSize(self) -> int: ...

    @property
    def instanceVariableList(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_InstanceVariableList: ...

    @property
    def methodList(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_MethodList: ...

    @property
    def name(self) -> unicode: ...

    @property
    def protocols(self) -> ghidra.app.util.bin.format.objectiveC.ObjectiveC1_ProtocolList: ...

    @property
    def superClass(self) -> unicode: ...

    @property
    def unknown0(self) -> int: ...

    @property
    def unknown1(self) -> int: ...

    @property
    def version(self) -> int: ...