from typing import List
import ghidra.app.util.bin
import ghidra.app.util.bin.format.omf
import ghidra.app.util.bin.format.omf.OmfFixupRecord
import java.lang


class OmfFixupRecord(ghidra.app.util.bin.format.omf.OmfRecord):





    class FixupTarget(object):




        def __init__(self): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getFrameMethod(self) -> int: ...

        def getP(self) -> int: ...

        def hashCode(self) -> int: ...

        def isFrameThread(self) -> bool: ...

        def isTargetThread(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        @staticmethod
        def readFixupTarget(__a0: ghidra.app.util.bin.BinaryReader, __a1: bool) -> ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupTarget: ...

        def resolveFrame(self, __a0: ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupState) -> None: ...

        def resolveTarget(self, __a0: ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupState) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def frameMethod(self) -> int: ...

        @property
        def frameThread(self) -> bool: ...

        @property
        def p(self) -> int: ...

        @property
        def targetThread(self) -> bool: ...




    class ThreadSubrecord(ghidra.app.util.bin.format.omf.OmfFixupRecord.Subrecord):




        def __init__(self): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getIndex(self) -> int: ...

        def getMethod(self) -> int: ...

        def getThreadNum(self) -> int: ...

        def hashCode(self) -> int: ...

        def isFrameThread(self) -> bool: ...

        def isThread(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        @staticmethod
        def readThreadSubrecord(__a0: ghidra.app.util.bin.BinaryReader, __a1: bool) -> ghidra.app.util.bin.format.omf.OmfFixupRecord.ThreadSubrecord: ...

        def toString(self) -> unicode: ...

        def updateState(self, __a0: ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupState) -> None: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def frameThread(self) -> bool: ...

        @property
        def index(self) -> int: ...

        @property
        def method(self) -> int: ...

        @property
        def threadNum(self) -> int: ...




    class FixupState(object):
        M: bool
        currentFixupRecord: ghidra.app.util.bin.format.omf.OmfFixupRecord
        externals: java.util.ArrayList
        frameState: int
        frameThreads: List[ghidra.app.util.bin.format.omf.OmfFixupRecord.ThreadSubrecord]
        groups: java.util.ArrayList
        language: ghidra.program.model.lang.Language
        locAddress: ghidra.program.model.address.Address
        locationType: int
        targetState: long
        targetThreads: List[ghidra.app.util.bin.format.omf.OmfFixupRecord.ThreadSubrecord]



        def __init__(self, __a0: ghidra.app.util.bin.format.omf.OmfFileHeader, __a1: java.util.ArrayList, __a2: ghidra.program.model.lang.Language): ...



        def clear(self) -> None: ...

        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class FixupSubrecord(ghidra.app.util.bin.format.omf.OmfFixupRecord.Subrecord):




        def __init__(self): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def isThread(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        @staticmethod
        def readFixupSubrecord(__a0: ghidra.app.util.bin.BinaryReader, __a1: bool) -> ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupSubrecord: ...

        def resolveFixup(self, __a0: ghidra.app.util.bin.format.omf.OmfFixupRecord.FixupState) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class Subrecord(object):




        def __init__(self, __a0: bool): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def isThread(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def thread(self) -> bool: ...

    def __init__(self, reader: ghidra.app.util.bin.BinaryReader): ...



    def calcCheckSum(self, reader: ghidra.app.util.bin.BinaryReader) -> int: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getRecordLength(self) -> int: ...

    def getRecordType(self) -> int: ...

    def getSubrecords(self) -> List[ghidra.app.util.bin.format.omf.OmfFixupRecord.Subrecord]: ...

    def hasBigFields(self) -> bool: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def readCheckSumByte(self, reader: ghidra.app.util.bin.BinaryReader) -> None: ...

    @staticmethod
    def readIndex(reader: ghidra.app.util.bin.BinaryReader) -> int: ...

    @staticmethod
    def readInt1Or2(reader: ghidra.app.util.bin.BinaryReader, isBig: bool) -> int: ...

    @staticmethod
    def readInt2Or4(reader: ghidra.app.util.bin.BinaryReader, isBig: bool) -> int: ...

    @staticmethod
    def readRecord(reader: ghidra.app.util.bin.BinaryReader) -> ghidra.app.util.bin.format.omf.OmfRecord: ...

    def readRecordHeader(self, reader: ghidra.app.util.bin.BinaryReader) -> None: ...

    @staticmethod
    def readString(reader: ghidra.app.util.bin.BinaryReader) -> unicode:
        """
        Read the OMF string format,  1-byte length, followed by that many ascii characters
        @param reader
        @return 
        @throws IOException
        """
        ...

    def setDataBlock(self, last: object) -> None: ...

    def toString(self) -> unicode: ...

    def validCheckSum(self, reader: ghidra.app.util.bin.BinaryReader) -> bool: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def dataBlock(self) -> None: ...  # No getter available.

    @dataBlock.setter
    def dataBlock(self, value: object) -> None: ...

    @property
    def subrecords(self) -> List[ghidra.app.util.bin.format.omf.OmfFixupRecord.Subrecord]: ...