from typing import List
import ghidra.app.util.bin
import ghidra.app.util.bin.format.pe.cli
import ghidra.app.util.bin.format.pe.cli.blobs
import ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig
import ghidra.app.util.bin.format.pe.cli.streams
import ghidra.app.util.bin.format.pe.cli.tables
import ghidra.docking.settings
import ghidra.program.model.data
import ghidra.program.model.mem
import ghidra.util
import java.lang
import java.net
import javax.swing.event


class CliAbstractSig(ghidra.app.util.bin.format.pe.cli.blobs.CliBlob, ghidra.app.util.bin.format.pe.cli.CliRepresentable):
    PATH: unicode = u'/PE/CLI/Blobs/Signatures'




    class CliArrayShape(object):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getRepresentation(self) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliNamedArg(object):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliFixedArg(object):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliTypeValueType(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata, __a1: bool) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliSigType(object, ghidra.app.util.bin.format.pe.cli.CliRepresentable):
        PATH: unicode = u'/PE/CLI/Types'



        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def executionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...

        @property
        def shortRepresentation(self) -> unicode: ...




    class CliTypeBase(object, ghidra.app.util.bin.format.pe.cli.CliRepresentable):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: bool): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getCustomMods(self) -> List[object]: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def getType(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType: ...

        def hashCode(self) -> int: ...

        def isByRef(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def byRef(self) -> bool: ...

        @property
        def customMods(self) -> List[object]: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def executionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...

        @property
        def shortRepresentation(self) -> unicode: ...

        @property
        def type(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType: ...




    class CliCustomMod(object):




        def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



        def equals(self, __a0: object) -> bool: ...

        def getCMOD(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def getRow(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow: ...

        def getRowIndex(self) -> int: ...

        def getTable(self) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable: ...

        def getTypeEncoded(self) -> int: ...

        def hashCode(self) -> int: ...

        @staticmethod
        def isCustomMod(__a0: ghidra.app.util.bin.BinaryReader) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def CMOD(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...

        @property
        def rowIndex(self) -> int: ...

        @property
        def table(self) -> ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable: ...

        @property
        def typeEncoded(self) -> int: ...




    class CliTypeVarOrMvar(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliTypeSzArray(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliParam(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliTypeBase):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getCustomMods(self) -> List[object]: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def getType(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType: ...

        def hashCode(self) -> int: ...

        def isByRef(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliTypeArray(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliRetType(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliTypeBase):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getCustomMods(self) -> List[object]: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def getType(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType: ...

        def hashCode(self) -> int: ...

        def isByRef(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliTypeClass(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliTypeFnPtr(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...

        @property
        def shortRepresentation(self) -> unicode: ...




    class CliTypeGenericInst(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliCustomAttrib(object):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliElem(object):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliTypePtr(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.BinaryReader, __a2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliTypePrimitive(ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType):




        def __init__(self, __a0: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig, __a1: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getDefinitionDataType(self) -> ghidra.program.model.data.DataType: ...

        def getExecutionDataType(self) -> ghidra.program.model.data.DataType: ...

        @overload
        def getRepresentation(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        @overload
        def getShortRepresentation(self) -> unicode: ...

        @overload
        def getShortRepresentation(self, __a0: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def definitionDataType(self) -> ghidra.program.model.data.DataType: ...

        @property
        def representation(self) -> unicode: ...




    class CliElementType(java.lang.Enum):
        ELEMENT_TYPE_ARRAY: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_ARRAY
        ELEMENT_TYPE_BOOLEAN: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_BOOLEAN
        ELEMENT_TYPE_BYREF: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_BYREF
        ELEMENT_TYPE_CHAR: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_CHAR
        ELEMENT_TYPE_CLASS: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_CLASS
        ELEMENT_TYPE_CMOD_OPT: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_CMOD_OPT
        ELEMENT_TYPE_CMOD_REQD: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_CMOD_REQD
        ELEMENT_TYPE_END: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_END
        ELEMENT_TYPE_FNPTR: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_FNPTR
        ELEMENT_TYPE_GENERICINST: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_GENERICINST
        ELEMENT_TYPE_I: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_I
        ELEMENT_TYPE_I1: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_I1
        ELEMENT_TYPE_I2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_I2
        ELEMENT_TYPE_I4: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_I4
        ELEMENT_TYPE_I8: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_I8
        ELEMENT_TYPE_INTERNAL: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_INTERNAL
        ELEMENT_TYPE_MAX: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_MAX
        ELEMENT_TYPE_MODIFIER: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_MODIFIER
        ELEMENT_TYPE_MVAR: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_MVAR
        ELEMENT_TYPE_OBJECT: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_OBJECT
        ELEMENT_TYPE_PINNED: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_PINNED
        ELEMENT_TYPE_PTR: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_PTR
        ELEMENT_TYPE_R4: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_R4
        ELEMENT_TYPE_R8: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_R8
        ELEMENT_TYPE_SENTINAL: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_SENTINAL
        ELEMENT_TYPE_STRING: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_STRING
        ELEMENT_TYPE_SZARRAY: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_SZARRAY
        ELEMENT_TYPE_TYPEDBYREF: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_TYPEDBYREF
        ELEMENT_TYPE_U: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_U
        ELEMENT_TYPE_U1: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_U1
        ELEMENT_TYPE_U2: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_U2
        ELEMENT_TYPE_U4: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_U4
        ELEMENT_TYPE_U8: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_U8
        ELEMENT_TYPE_VALUETYPE: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_VALUETYPE
        ELEMENT_TYPE_VAR: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_VAR
        ELEMENT_TYPE_VOID: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType = ELEMENT_TYPE_VOID







        @overload
        def compareTo(self, __a0: java.lang.Enum) -> int: ...

        @overload
        def compareTo(self, __a0: object) -> int: ...

        def equals(self, __a0: object) -> bool: ...

        @staticmethod
        def fromInt(__a0: int) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        def getClass(self) -> java.lang.Class: ...

        def getDeclaringClass(self) -> java.lang.Class: ...

        def hashCode(self) -> int: ...

        def id(self) -> int: ...

        def name(self) -> unicode: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def ordinal(self) -> int: ...

        def toString(self) -> unicode: ...

        @overload
        @staticmethod
        def valueOf(__a0: unicode) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        @overload
        @staticmethod
        def valueOf(__a0: java.lang.Class, __a1: unicode) -> java.lang.Enum: ...

        @staticmethod
        def values() -> List[ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType]: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliTypeCodeDataType(ghidra.program.model.data.EnumDataType):
        PATH: unicode = u'/PE/CLI/Types'
        dataType: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliTypeCodeDataType = TypeCode



        def __init__(self): ...



        def add(self, __a0: unicode, __a1: long) -> None: ...

        def addParent(self, __a0: ghidra.program.model.data.DataType) -> None: ...

        def clone(self, __a0: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

        def copy(self, __a0: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType: ...

        def dataTypeDeleted(self, __a0: ghidra.program.model.data.DataType) -> None: ...

        def dataTypeNameChanged(self, __a0: ghidra.program.model.data.DataType, __a1: unicode) -> None: ...

        def dataTypeReplaced(self, __a0: ghidra.program.model.data.DataType, __a1: ghidra.program.model.data.DataType) -> None: ...

        def dataTypeSizeChanged(self, __a0: ghidra.program.model.data.DataType) -> None: ...

        def dependsOn(self, __a0: ghidra.program.model.data.DataType) -> bool: ...

        def equals(self, __a0: object) -> bool: ...

        def getAlignment(self) -> int: ...

        def getCategoryPath(self) -> ghidra.program.model.data.CategoryPath: ...

        def getClass(self) -> java.lang.Class: ...

        def getCount(self) -> int: ...

        def getDataOrganization(self) -> ghidra.program.model.data.DataOrganization: ...

        def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager: ...

        def getDataTypePath(self) -> ghidra.program.model.data.DataTypePath: ...

        def getDefaultAbbreviatedLabelPrefix(self) -> unicode: ...

        @overload
        def getDefaultLabelPrefix(self) -> unicode: ...

        @overload
        def getDefaultLabelPrefix(self, __a0: ghidra.program.model.mem.MemBuffer, __a1: ghidra.docking.settings.Settings, __a2: int, __a3: ghidra.program.model.data.DataTypeDisplayOptions) -> unicode: ...

        def getDefaultOffcutLabelPrefix(self, __a0: ghidra.program.model.mem.MemBuffer, __a1: ghidra.docking.settings.Settings, __a2: int, __a3: ghidra.program.model.data.DataTypeDisplayOptions, __a4: int) -> unicode: ...

        def getDefaultSettings(self) -> ghidra.docking.settings.Settings: ...

        def getDescription(self) -> unicode: ...

        def getDisplayName(self) -> unicode: ...

        def getDocs(self) -> java.net.URL: ...

        def getLastChangeTime(self) -> long: ...

        def getLastChangeTimeInSourceArchive(self) -> long: ...

        def getLength(self) -> int: ...

        def getMnemonic(self, __a0: ghidra.docking.settings.Settings) -> unicode: ...

        @overload
        def getName(self) -> unicode: ...

        @overload
        def getName(self, __a0: long) -> unicode: ...

        def getNames(self) -> List[unicode]: ...

        def getParents(self) -> List[ghidra.program.model.data.DataType]: ...

        def getPathName(self) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: ghidra.program.model.mem.MemBuffer, __a1: ghidra.docking.settings.Settings, __a2: int) -> unicode: ...

        @overload
        def getRepresentation(self, __a0: long, __a1: ghidra.docking.settings.Settings, __a2: int) -> unicode: ...

        def getSettingsDefinitions(self) -> List[ghidra.docking.settings.SettingsDefinition]: ...

        def getSourceArchive(self) -> ghidra.program.model.data.SourceArchive: ...

        def getUniversalID(self) -> ghidra.util.UniversalID: ...

        @overload
        def getValue(self, __a0: unicode) -> long: ...

        @overload
        def getValue(self, __a0: ghidra.program.model.mem.MemBuffer, __a1: ghidra.docking.settings.Settings, __a2: int) -> object: ...

        def getValueClass(self, __a0: ghidra.docking.settings.Settings) -> java.lang.Class: ...

        def getValues(self) -> List[long]: ...

        def hashCode(self) -> int: ...

        def isDeleted(self) -> bool: ...

        def isDynamicallySized(self) -> bool: ...

        def isEquivalent(self, __a0: ghidra.program.model.data.DataType) -> bool: ...

        def isNotYetDefined(self) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def remove(self, __a0: unicode) -> None: ...

        def removeParent(self, __a0: ghidra.program.model.data.DataType) -> None: ...

        def replaceWith(self, __a0: ghidra.program.model.data.DataType) -> None: ...

        def setCategoryPath(self, __a0: ghidra.program.model.data.CategoryPath) -> None: ...

        def setDefaultSettings(self, __a0: ghidra.docking.settings.Settings) -> None: ...

        def setDescription(self, __a0: unicode) -> None: ...

        def setLastChangeTime(self, __a0: long) -> None: ...

        def setLastChangeTimeInSourceArchive(self, __a0: long) -> None: ...

        def setLength(self, __a0: int) -> None: ...

        def setName(self, __a0: unicode) -> None: ...

        def setNameAndCategory(self, __a0: ghidra.program.model.data.CategoryPath, __a1: unicode) -> None: ...

        def setSourceArchive(self, __a0: ghidra.program.model.data.SourceArchive) -> None: ...

        def stateChanged(self, __a0: javax.swing.event.ChangeEvent) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class CliConstraint(object):




        def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getConstraint(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        def getRepresentation(self) -> unicode: ...

        def hashCode(self) -> int: ...

        @staticmethod
        def isConstraint(__a0: ghidra.app.util.bin.BinaryReader) -> bool: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...

        @property
        def constraint(self) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType: ...

        @property
        def representation(self) -> unicode: ...

    def __init__(self, blob: ghidra.app.util.bin.format.pe.cli.blobs.CliBlob): ...



    @staticmethod
    def convertTypeCodeToDataType(typeCode: ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliElementType) -> ghidra.program.model.data.DataType: ...

    @overload
    @staticmethod
    def decodeCompressedSigned(codedSize: int) -> int: ...

    @overload
    @staticmethod
    def decodeCompressedSigned(codedSize: int) -> int: ...

    @overload
    @staticmethod
    def decodeCompressedSigned(codedSize: int) -> int: ...

    @staticmethod
    def decodeCompressedSignedInt(reader: ghidra.app.util.bin.BinaryReader) -> int: ...

    @overload
    @staticmethod
    def decodeCompressedUnsigned(codedSize: int) -> int: ...

    @overload
    @staticmethod
    def decodeCompressedUnsigned(codedSize: int) -> int: ...

    @overload
    @staticmethod
    def decodeCompressedUnsigned(codedSize: int) -> int: ...

    @staticmethod
    def decodeCompressedUnsignedInt(reader: ghidra.app.util.bin.BinaryReader) -> int: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getContents(self) -> List[int]:
        """
        Gets the blob's contents.
        @return the blob's contents.  Could be null if there was a problem reading the 
           contents.
        """
        ...

    def getContentsComment(self) -> unicode: ...

    def getContentsDataType(self) -> ghidra.program.model.data.DataType: ...

    def getContentsName(self) -> unicode: ...

    def getContentsReader(self) -> ghidra.app.util.bin.BinaryReader:
        """
        Gets a new binary reader positioned at the start of this blob's contents.
        @return A new binary reader positioned at the start of this blob's contents.
        """
        ...

    def getContentsSize(self) -> int:
        """
        Gets the blob's contents size in bytes.
        @return The blob's contents size in bytes.
        """
        ...

    @staticmethod
    def getDataTypeForBytes(numBytes: int) -> ghidra.program.model.data.DataType: ...

    def getName(self) -> unicode:
        """
        Gets the name of this blob.
        @return The name of this blob.
        """
        ...

    @overload
    def getRepresentation(self) -> unicode: ...

    @overload
    def getRepresentation(self, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

    @overload
    def getShortRepresentation(self) -> unicode: ...

    @overload
    def getShortRepresentation(self, stream: ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata) -> unicode: ...

    def getSize(self) -> int:
        """
        Gets the blob's size in bytes (includes all fields).
        @return The blob's size in bytes.
        """
        ...

    def getSizeDataType(self) -> ghidra.program.model.data.DataType:
        """
        Gets the proper data type for the blob's size field.
        @return The proper data type for the blob's size field.
        """
        ...

    def getStreamIndex(self) -> int:
        """
        Gets the index into the blob stream of this blob.
        @return The index into the blob stream of this blob.
        """
        ...

    def hashCode(self) -> int: ...

    def isLittleEndian(self) -> bool:
        """
        Checks to see whether or not this blob is little endian.
        @return True if this blob is little endian; false if big endian.
        """
        ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def readCliType(self, reader: ghidra.app.util.bin.BinaryReader) -> ghidra.app.util.bin.format.pe.cli.blobs.CliAbstractSig.CliSigType: ...

    @staticmethod
    def testSizeDecoding() -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def contentsComment(self) -> unicode: ...

    @property
    def contentsDataType(self) -> ghidra.program.model.data.DataType: ...

    @property
    def contentsName(self) -> unicode: ...

    @property
    def representation(self) -> unicode: ...

    @property
    def shortRepresentation(self) -> unicode: ...