from typing import List
import ghidra.app.util.bin.format.pe.rich
import ghidra.docking.settings
import ghidra.program.model.data
import ghidra.program.model.mem
import ghidra.util
import java.lang
import java.net
import javax.swing.event


class MSRichProductInfoDataType(ghidra.program.model.data.StructureDataType):




    @overload
    def __init__(self, name: unicode, length: int):
        """
        Construct a new structure with the given name and length. The root category will be used.
        @param name the name of the new structure
        @param length the initial size of the structure in bytes. If 0 is specified the structure
                    will report its length as 1 and {@link #isNotYetDefined()} will return true.
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, length: int):
        """
        Construct a new structure with the given name and length within the specified categry path.
        @param path the category path indicating where this data type is located.
        @param name the name of the new structure
        @param length the initial size of the structure in bytes. If 0 is specified the structure
                    will report its length as 1 and {@link #isNotYetDefined()} will return true.
        """
        ...

    @overload
    def __init__(self, name: unicode, length: int, dtm: ghidra.program.model.data.DataTypeManager):
        """
        Construct a new structure with the given name, length and datatype manager which conveys data
         organization. The root category will be used.
        @param name the name of the new structure
        @param length the initial size of the structure in bytes. If 0 is specified the structure
                    will report its length as 1 and {@link #isNotYetDefined()} will return true.
        @param dtm the data type manager associated with this data type. This can be null. Also, the
                    data type manager may not yet contain this actual data type.
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, length: int, dtm: ghidra.program.model.data.DataTypeManager):
        """
        Construct a new structure with the given name, length and datatype manager within the
         specified categry path.
        @param path the category path indicating where this data type is located.
        @param name the name of the new structure
        @param length the initial size of the structure in bytes. If 0 is specified the structure
                    will report its length as 1 and {@link #isNotYetDefined()} will return true.
        @param dtm the data type manager associated with this data type. This can be null. Also, the
                    data type manager may not yet contain this actual data type.
        """
        ...

    @overload
    def __init__(self, path: ghidra.program.model.data.CategoryPath, name: unicode, length: int, universalID: ghidra.util.UniversalID, sourceArchive: ghidra.program.model.data.SourceArchive, lastChangeTime: long, lastChangeTimeInSourceArchive: long, dtm: ghidra.program.model.data.DataTypeManager):
        """
        Construct a new structure with the given name and length
        @param path the category path indicating where this data type is located.
        @param name the name of the new structure
        @param length the initial size of the structure in bytes. If 0 is specified the structure
                    will report its length as 1 and {@link #isNotYetDefined()} will return true.
        @param universalID the id for the data type
        @param sourceArchive the source archive for this data type
        @param lastChangeTime the last time this data type was changed
        @param lastChangeTimeInSourceArchive the last time this data type was changed in its source
                    archive.
        @param dtm the data type manager associated with this data type. This can be null. Also, the
                    data type manager may not yet contain this actual data type.
        """
        ...



    @overload
    def add(self, dataType: ghidra.program.model.data.DataType) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, fieldName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def add(self, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def addBitField(self, baseDataType: ghidra.program.model.data.DataType, bitSize: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def addParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def adjustInternalAlignment(self) -> None: ...

    def clearComponent(self, index: int) -> None: ...

    def clearFlexibleArrayComponent(self) -> None: ...

    def clone(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.app.util.bin.format.pe.rich.MSRichProductInfoDataType: ...

    def copy(self, dtm: ghidra.program.model.data.DataTypeManager) -> ghidra.program.model.data.DataType:
        """
        Create copy of structure for target dtm (source archive information is discarded). 
         <p>
         WARNING! copying unaligned structures which contain bitfields can produce invalid results when
         switching endianess due to the differences in packing order.
        @param dtm target data type manager
        @return cloned structure
        """
        ...

    def dataTypeAlignmentChanged(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeDeleted(self, dt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeNameChanged(self, dt: ghidra.program.model.data.DataType, oldName: unicode) -> None: ...

    def dataTypeReplaced(self, oldDt: ghidra.program.model.data.DataType, replacementDt: ghidra.program.model.data.DataType) -> None: ...

    def dataTypeSizeChanged(self, dt: ghidra.program.model.data.DataType) -> None: ...

    @overload
    def delete(self, ordinal: int) -> None: ...

    @overload
    def delete(self, ordinals: List[int]) -> None: ...

    def deleteAll(self) -> None: ...

    def deleteAtOffset(self, offset: int) -> None: ...

    def dependsOn(self, dt: ghidra.program.model.data.DataType) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    def getAlignment(self) -> int: ...

    def getBitFieldPacking(self) -> ghidra.program.model.data.BitFieldPacking: ...

    def getCategoryPath(self) -> ghidra.program.model.data.CategoryPath: ...

    def getClass(self) -> java.lang.Class: ...

    def getComponent(self, index: int) -> ghidra.program.model.data.DataTypeComponent: ...

    def getComponentAt(self, offset: int) -> ghidra.program.model.data.DataTypeComponent: ...

    def getComponents(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    def getDataOrganization(self) -> ghidra.program.model.data.DataOrganization: ...

    def getDataTypeAt(self, offset: int) -> ghidra.program.model.data.DataTypeComponent: ...

    def getDataTypeManager(self) -> ghidra.program.model.data.DataTypeManager:
        """
        @see ghidra.program.model.data.DataType#getDataTypeManager()
        """
        ...

    def getDataTypePath(self) -> ghidra.program.model.data.DataTypePath: ...

    def getDefaultAbbreviatedLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self) -> unicode: ...

    @overload
    def getDefaultLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions) -> unicode: ...

    def getDefaultOffcutLabelPrefix(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, len: int, options: ghidra.program.model.data.DataTypeDisplayOptions, offcutLength: int) -> unicode: ...

    def getDefaultSettings(self) -> ghidra.docking.settings.Settings: ...

    def getDefinedComponents(self) -> List[ghidra.program.model.data.DataTypeComponent]: ...

    def getDescription(self) -> unicode: ...

    def getDisplayName(self) -> unicode: ...

    def getDocs(self) -> java.net.URL: ...

    def getFlexibleArrayComponent(self) -> ghidra.program.model.data.DataTypeComponent: ...

    def getLastChangeTime(self) -> long: ...

    def getLastChangeTimeInSourceArchive(self) -> long: ...

    def getLength(self) -> int: ...

    def getMinimumAlignment(self) -> int: ...

    def getMnemonic(self, settings: ghidra.docking.settings.Settings) -> unicode: ...

    def getName(self) -> unicode: ...

    def getNumComponents(self) -> int: ...

    def getNumDefinedComponents(self) -> int: ...

    def getPackingValue(self) -> int: ...

    def getParents(self) -> List[ghidra.program.model.data.DataType]: ...

    def getPathName(self) -> unicode: ...

    def getRepresentation(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> unicode: ...

    def getSettingsDefinitions(self) -> List[ghidra.docking.settings.SettingsDefinition]: ...

    def getSourceArchive(self) -> ghidra.program.model.data.SourceArchive: ...

    def getUniversalID(self) -> ghidra.util.UniversalID: ...

    def getValue(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int) -> object: ...

    def getValueClass(self, settings: ghidra.docking.settings.Settings) -> java.lang.Class: ...

    def growStructure(self, amount: int) -> None: ...

    def hasFlexibleArrayComponent(self) -> bool: ...

    def hashCode(self) -> int: ...

    @overload
    def insert(self, ordinal: int, dataType: ghidra.program.model.data.DataType) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def insert(self, ordinal: int, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def insert(self, index: int, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def insertAtOffset(self, offset: int, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponentImpl: ...

    @overload
    def insertAtOffset(self, offset: int, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponentImpl: ...

    def insertBitField(self, ordinal: int, byteWidth: int, bitOffset: int, baseDataType: ghidra.program.model.data.DataType, bitSize: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def insertBitFieldAt(self, byteOffset: int, byteWidth: int, bitOffset: int, baseDataType: ghidra.program.model.data.DataType, bitSize: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponentImpl: ...

    def isDefaultAligned(self) -> bool: ...

    def isDeleted(self) -> bool: ...

    def isDynamicallySized(self) -> bool: ...

    def isEquivalent(self, dataType: ghidra.program.model.data.DataType) -> bool: ...

    def isInternallyAligned(self) -> bool: ...

    def isMachineAligned(self) -> bool: ...

    def isNotYetDefined(self) -> bool: ...

    def isPartOf(self, dataTypeOfInterest: ghidra.program.model.data.DataType) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def pack(self, packingSize: int) -> None: ...

    def realign(self) -> None: ...

    def removeParent(self, dt: ghidra.program.model.data.DataType) -> None: ...

    @overload
    def replace(self, index: int, dataType: ghidra.program.model.data.DataType, length: int) -> ghidra.program.model.data.DataTypeComponent: ...

    @overload
    def replace(self, index: int, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def replaceAtOffset(self, offset: int, dataType: ghidra.program.model.data.DataType, length: int, componentName: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def replaceWith(self, dataType: ghidra.program.model.data.DataType) -> None:
        """
        Replaces the internal components of this structure with components of the given structure.
        @param dataType the structure to get the component information from.
        @throws IllegalArgumentException if any of the component data types are not allowed to
                     replace a component in this composite data type. For example, suppose dt1
                     contains dt2. Therefore it is not valid to replace a dt2 component with dt1 since
                     this would cause a cyclic dependency.
        """
        ...

    def setCategoryPath(self, path: ghidra.program.model.data.CategoryPath) -> None: ...

    def setDefaultSettings(self, settings: ghidra.docking.settings.Settings) -> None: ...

    def setDescription(self, desc: unicode) -> None: ...

    def setFlexibleArrayComponent(self, flexType: ghidra.program.model.data.DataType, name: unicode, comment: unicode) -> ghidra.program.model.data.DataTypeComponent: ...

    def setInternallyAligned(self, aligned: bool) -> None: ...

    def setLastChangeTime(self, lastChangeTime: long) -> None: ...

    def setLastChangeTimeInSourceArchive(self, lastChangeTimeInSourceArchive: long) -> None: ...

    def setMinimumAlignment(self, externalAlignment: int) -> None: ...

    def setName(self, name: unicode) -> None: ...

    def setNameAndCategory(self, path: ghidra.program.model.data.CategoryPath, name: unicode) -> None: ...

    def setPackingValue(self, packingValue: int) -> None: ...

    def setSourceArchive(self, archive: ghidra.program.model.data.SourceArchive) -> None: ...

    def setToDefaultAlignment(self) -> None: ...

    def setToMachineAlignment(self) -> None: ...

    def setValue(self, buf: ghidra.program.model.mem.MemBuffer, settings: ghidra.docking.settings.Settings, length: int, value: object) -> None: ...

    def stateChanged(self, e: javax.swing.event.ChangeEvent) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

