from typing import List
import ghidra.app.util.demangler
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.symbol
import ghidra.util.task
import java.lang


class DemangledFunction(ghidra.app.util.demangler.DemangledObject):
    """
    A class to represent a demangled function.
    """

    CONST: unicode = u'const'
    PTR64: unicode = u'__ptr64'
    RESTRICT: unicode = u'__restrict'
    UNALIGNED: unicode = u'__unaligned'
    VOLATILE: unicode = u'volatile'



    def __init__(self, mangled: unicode, originalDemangled: unicode, name: unicode): ...



    def addParameter(self, parameter: ghidra.app.util.demangler.DemangledDataType) -> None: ...

    def applyPlateCommentOnly(self, program: ghidra.program.model.listing.Program, address: ghidra.program.model.address.Address) -> bool:
        """
        @param program The program for which to apply the comment
        @param address The address for the comment
        @return {@code true} if a comment was applied
        """
        ...

    def applyTo(self, program: ghidra.program.model.listing.Program, address: ghidra.program.model.address.Address, options: ghidra.app.util.demangler.DemanglerOptions, monitor: ghidra.util.task.TaskMonitor) -> bool: ...

    @staticmethod
    def createNamespace(program: ghidra.program.model.listing.Program, typeNamespace: ghidra.app.util.demangler.Demangled, parentNamespace: ghidra.program.model.symbol.Namespace, functionPermitted: bool) -> ghidra.program.model.symbol.Namespace:
        """
        Get or create the specified typeNamespace.  The returned namespace may only be a partial 
         namespace if errors occurred.  The caller should check the returned namespace and adjust
         any symbol creation accordingly.
        @param program the program
        @param typeNamespace demangled namespace
        @param parentNamespace root namespace to be used (e.g., library, global, etc.)
        @param functionPermitted if true an existing function may be used as a namespace
        @return namespace or partial namespace if error occurs
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def getBasedName(self) -> unicode: ...

    def getCallingConvention(self) -> unicode:
        """
        Returns the calling convention or null, if unspecified.
        @return the calling convention or null, if unspecified
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getDemangledName(self) -> unicode: ...

    def getMangledString(self) -> unicode: ...

    def getMemberScope(self) -> unicode: ...

    def getName(self) -> unicode: ...

    def getNamespace(self) -> ghidra.app.util.demangler.Demangled: ...

    def getNamespaceName(self) -> unicode: ...

    def getNamespaceString(self) -> unicode: ...

    def getOriginalDemangled(self) -> unicode: ...

    def getParameterString(self) -> unicode: ...

    def getParameters(self) -> List[ghidra.app.util.demangler.DemangledDataType]: ...

    def getReturnType(self) -> ghidra.app.util.demangler.DemangledDataType:
        """
        Returns the return type or null, if unspecified.
        @return the return type or null, if unspecified
        """
        ...

    @overload
    def getSignature(self) -> unicode: ...

    @overload
    def getSignature(self, format: bool) -> unicode: ...

    def getSpecialPrefix(self) -> unicode: ...

    def getStorageClass(self) -> unicode: ...

    def getTemplate(self) -> ghidra.app.util.demangler.DemangledTemplate: ...

    def getVisibility(self) -> unicode: ...

    def hashCode(self) -> int: ...

    def isConst(self) -> bool: ...

    def isPointer64(self) -> bool: ...

    def isRestrict(self) -> bool: ...

    def isStatic(self) -> bool: ...

    def isThunk(self) -> bool: ...

    def isTrailingConst(self) -> bool: ...

    def isTrailingPointer64(self) -> bool: ...

    def isTrailingRestrict(self) -> bool: ...

    def isTrailingUnaligned(self) -> bool: ...

    def isTrailingVolatile(self) -> bool: ...

    def isTypeCast(self) -> bool: ...

    def isUnaligned(self) -> bool: ...

    def isVirtual(self) -> bool: ...

    def isVolatile(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setBasedName(self, basedName: unicode) -> None: ...

    def setCallingConvention(self, callingConvention: unicode) -> None:
        """
        Sets the function calling convention. For example, "__cdecl".
        @param callingConvention the function calling convention
        """
        ...

    def setConst(self, isConst: bool) -> None: ...

    def setMemberScope(self, memberScope: unicode) -> None: ...

    def setName(self, name: unicode) -> None:
        """
        Sets the name of the demangled object
        @param name the new name
        """
        ...

    def setNamespace(self, namespace: ghidra.app.util.demangler.Demangled) -> None: ...

    def setOverloadedOperator(self, isOverloadedOperator: bool) -> None:
        """
        Sets whether this demangled function represents
         an overloaded operator. For example, "operator+()".
        @param isOverloadedOperator true if overloaded operator
        """
        ...

    def setPointer64(self, isPointer64: bool) -> None: ...

    def setRestrict(self) -> None: ...

    def setReturnType(self, returnType: ghidra.app.util.demangler.DemangledDataType) -> None:
        """
        Sets the function return type.
        @param returnType the function return type
        """
        ...

    def setSignature(self, signature: unicode) -> None:
        """
        Sets the signature. Calling this method will
         override the auto-generated signature.
        @param signature the signature
        """
        ...

    def setSpecialPrefix(self, special: unicode) -> None: ...

    def setStatic(self, isStatic: bool) -> None: ...

    def setStorageClass(self, storageClass: unicode) -> None: ...

    def setTemplate(self, template: ghidra.app.util.demangler.DemangledTemplate) -> None: ...

    def setTemplatedConstructorType(self, type: unicode) -> None:
        """
        Special constructor where it has a templated type before the parameter list
        @param type the type
        """
        ...

    def setThrowAttribute(self, throwAttribute: unicode) -> None: ...

    def setThunk(self, isThunk: bool) -> None: ...

    def setTrailingConst(self) -> None: ...

    def setTrailingPointer64(self) -> None: ...

    def setTrailingRestrict(self) -> None: ...

    def setTrailingUnaligned(self) -> None: ...

    def setTrailingVolatile(self) -> None: ...

    def setTypeCast(self) -> None: ...

    def setUnaligned(self) -> None: ...

    def setVirtual(self, isVirtual: bool) -> None: ...

    def setVisibilty(self, visibility: unicode) -> None: ...

    def setVolatile(self, isVolatile: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def callingConvention(self) -> unicode: ...

    @callingConvention.setter
    def callingConvention(self, value: unicode) -> None: ...

    @property
    def namespaceName(self) -> unicode: ...

    @property
    def overloadedOperator(self) -> None: ...  # No getter available.

    @overloadedOperator.setter
    def overloadedOperator(self, value: bool) -> None: ...

    @property
    def parameterString(self) -> unicode: ...

    @property
    def parameters(self) -> List[object]: ...

    @property
    def returnType(self) -> ghidra.app.util.demangler.DemangledDataType: ...

    @returnType.setter
    def returnType(self, value: ghidra.app.util.demangler.DemangledDataType) -> None: ...

    @property
    def template(self) -> ghidra.app.util.demangler.DemangledTemplate: ...

    @template.setter
    def template(self, value: ghidra.app.util.demangler.DemangledTemplate) -> None: ...

    @property
    def templatedConstructorType(self) -> None: ...  # No getter available.

    @templatedConstructorType.setter
    def templatedConstructorType(self, value: unicode) -> None: ...

    @property
    def throwAttribute(self) -> None: ...  # No getter available.

    @throwAttribute.setter
    def throwAttribute(self, value: unicode) -> None: ...

    @property
    def trailingConst(self) -> bool: ...

    @property
    def trailingPointer64(self) -> bool: ...

    @property
    def trailingRestrict(self) -> bool: ...

    @property
    def trailingUnaligned(self) -> bool: ...

    @property
    def trailingVolatile(self) -> bool: ...

    @property
    def typeCast(self) -> bool: ...