from typing import List
import docking.widgets.fieldpanel.support
import ghidra.app.util
import ghidra.app.util.viewer.field
import ghidra.app.util.viewer.format
import ghidra.app.util.viewer.proxy
import ghidra.framework.options
import ghidra.program.util
import java.awt
import java.lang


class EolCommentFieldFactory(ghidra.app.util.viewer.field.FieldFactory):
    """
    Generates End of line comment Fields.
    """

    DEFAULT_COLOR: java.awt.Color = java.awt.Color[r=0,g=0,b=255]
    ENABLE_ALWAYS_SHOW_AUTOMATIC_MSG: unicode = u'EOL Comments Field.Always Show the Automatic Comment'
    ENABLE_ALWAYS_SHOW_REF_REPEATABLE_MSG: unicode = u'EOL Comments Field.Always Show the Referenced Repeatable Comments'
    ENABLE_ALWAYS_SHOW_REPEATABLE_MSG: unicode = u'EOL Comments Field.Always Show the Repeatable Comment'
    ENABLE_PREPEND_REF_ADDRESS_MSG: unicode = u'EOL Comments Field.Prepend the Address to Each Referenced Comment'
    ENABLE_SHOW_SEMICOLON_MSG: unicode = u'EOL Comments Field.Show Semicolon at Start of Each Line'
    ENABLE_WORD_WRAP_MSG: unicode = u'EOL Comments Field.Enable Word Wrapping'
    FIELD_NAME: unicode = u'EOL Comment'
    MAX_DISPLAY_LINES_MSG: unicode = u'EOL Comments Field.Maximum Lines To Display'
    USE_ABBREVIATED_AUTOMITIC_COMMENT_MSG: unicode = u'EOL Comments Field.Use Abbreviated Automatic Comments'



    def __init__(self):
        """
        Default Constructor
        """
        ...



    def acceptsType(self, category: int, proxyObjectClass: java.lang.Class) -> bool: ...

    def displayOptionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fieldOptionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Notification that an option changed.
        @param options options object containing the property that changed
        @param optionName name of option that changed
        @param oldValue old value of the option
        @param newValue new value of the option
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getDefaultColor(self) -> java.awt.Color: ...

    def getField(self, proxy: ghidra.app.util.viewer.proxy.ProxyObj, varWidth: int) -> ghidra.app.util.viewer.field.ListingField: ...

    def getFieldLocation(self, bf: ghidra.app.util.viewer.field.ListingField, index: long, fieldNum: int, loc: ghidra.program.util.ProgramLocation) -> docking.widgets.fieldpanel.support.FieldLocation: ...

    def getFieldModel(self) -> ghidra.app.util.viewer.format.FieldFormatModel:
        """
        Returns the FieldModel that this factory belongs to.
        """
        ...

    def getFieldName(self) -> unicode:
        """
        Returns the Field name.
        """
        ...

    def getFieldText(self) -> unicode:
        """
        Returns a description of the fields generated by this factory.
        """
        ...

    def getMetrics(self) -> java.awt.FontMetrics:
        """
        Returns the font metrics used by this field factory
        """
        ...

    def getProgramLocation(self, screenRow: int, screenColumn: int, bf: ghidra.app.util.viewer.field.ListingField) -> ghidra.program.util.ProgramLocation:
        """
        @param screenRow the row location for the cursor within the listing field.
        @param screenColumn the column location for the cursor within the listing field.
        @param bf the listing field.
        @return the program location that is equivalent to the cursor location in the field.
        """
        ...

    @staticmethod
    def getSingleString(comments: List[unicode], separatorChar: int) -> unicode:
        """
        Convert the array of comments to a single string and use the given
         separatorChar as the delimiter.
        @param comments array of comments to convert
        @param separatorChar character to insert after each element in the comment array
        @return the converted string
        """
        ...

    def getStartX(self) -> int:
        """
        Returns the starting x position for the fields generated by this
         factory.
        """
        ...

    def getWidth(self) -> int:
        """
        Returns the width of the fields generated by this factory.
        """
        ...

    def hashCode(self) -> int: ...

    def isEnabled(self) -> bool:
        """
        Returns true if this FieldFactory is currently enabled to generate Fields.
        """
        ...

    def newInstance(self, fieldFormatModel: ghidra.app.util.viewer.format.FieldFormatModel, highlightProvider: ghidra.app.util.HighlightProvider, newDisplayOptions: ghidra.framework.options.ToolOptions, newFieldOptions: ghidra.framework.options.ToolOptions) -> ghidra.app.util.viewer.field.FieldFactory: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def optionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Notification that the Options have changed.
        @param options the Options object that changed. Will be either the display
         options or the field options.
        @param optionName the name of the property that changed.
        @param oldValue the old value of the property.
        @param newValue the new value of the property.
        """
        ...

    def servicesChanged(self) -> None:
        """
        Notification the services changed. Subclasses should override this method
         if they care about service changes.
        """
        ...

    def setEnabled(self, state: bool) -> None:
        """
        Turns on or off the generating of Fields by this FieldFactory.
        @param state if true, this factory will generate fields.
        """
        ...

    def setStartX(self, x: int) -> None:
        """
        Sets the starting x position for the fields generated by this factory.
        """
        ...

    def setWidth(self, w: int) -> None:
        """
        Sets the width of the fields generated by this factory.
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def defaultColor(self) -> java.awt.Color: ...