import docking.widgets.fieldpanel.support
import ghidra.app.util
import ghidra.app.util.viewer.field
import ghidra.app.util.viewer.format
import ghidra.app.util.viewer.proxy
import ghidra.framework.options
import ghidra.program.util
import ghidra.util.classfinder
import java.awt
import java.lang


class FieldFactory(object, ghidra.util.classfinder.ExtensionPoint):
    """
    NOTE:  ALL FIELDFACTORY CLASSES MUST END IN "FieldFactory".  If not,
     the ClassSearcher will not find them.

     Base class for Field Factories.
    """

    DEFAULT_FIELD_FONT: java.awt.Font = java.awt.Font[family=Monospaced,name=monospaced,style=plain,size=12]
    FONT_OPTION_NAME: unicode = u'BASE FONT'



    def __init__(self, name: unicode):
        """
        Constructs a FieldFactory with given name.  Used only as potential field.
        @param name the name of the field.
        """
        ...



    def acceptsType(self, category: int, proxyObjectClass: java.lang.Class) -> bool:
        """
        Used to specify which format models this field can belong to.
        @param category the category for this field
        @param proxyObjectClass the type of proxy object used by this field
        @return true if this class accepts the given category.
        """
        ...

    def displayOptionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Notifications that the display options changed.
        @param options the Display Options object that changed.
        @param optionName the name of the property that changed.
        @param oldValue the old value of the property.
        @param newValue the new value of the property.
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def fieldOptionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Notifications that the field options changed.
        @param options the Field Options object that changed.
        @param optionName the name of the property that changed.
        @param oldValue the old value of the property.
        @param newValue the new value of the property.
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getDefaultColor(self) -> java.awt.Color:
        """
        Returns the default field color.
        """
        ...

    def getField(self, obj: ghidra.app.util.viewer.proxy.ProxyObj, varWidth: int) -> ghidra.app.util.viewer.field.ListingField:
        """
        Generates a Field based on the given information.
        @param obj The object that the generated field will report some information about.
        @param varWidth the additional distance along the x axis to place the generated field.
        @return the newly generated FactoryField that shows some property or information about
         the given object.
        """
        ...

    def getFieldLocation(self, bf: ghidra.app.util.viewer.field.ListingField, index: long, fieldNum: int, loc: ghidra.program.util.ProgramLocation) -> docking.widgets.fieldpanel.support.FieldLocation:
        """
        Return a FieldLocation that corresponds to the given index, fieldNum, and ProgramLocation
         IF and ONLY IF the given programLocation is the type generated by this class's
         {@link #getFieldLocation(ListingField, BigInteger, int, ProgramLocation)}.  Each FieldFactory
         should generate and process a unique ProgramLocation class.
        @param bf the ListingField at the current cursor.
        @param index the line index (corresponds to an address)
        @param fieldNum the index of field within the layout to try and get a FieldLocation.
        @param loc the ProgramLocation to be converted into a FieldLocation.
        """
        ...

    def getFieldModel(self) -> ghidra.app.util.viewer.format.FieldFormatModel:
        """
        Returns the FieldModel that this factory belongs to.
        """
        ...

    def getFieldName(self) -> unicode:
        """
        Returns the Field name.
        """
        ...

    def getFieldText(self) -> unicode:
        """
        Returns a description of the fields generated by this factory.
        """
        ...

    def getMetrics(self) -> java.awt.FontMetrics:
        """
        Returns the font metrics used by this field factory
        """
        ...

    def getProgramLocation(self, row: int, col: int, bf: ghidra.app.util.viewer.field.ListingField) -> ghidra.program.util.ProgramLocation:
        """
        Returns the Program location for the given object, row, col, and groupPath
        @param row the row within this field
        @param col the col on the given row within this field.
        @param bf the ListingField containing the cursor.
        """
        ...

    def getStartX(self) -> int:
        """
        Returns the starting x position for the fields generated by this
         factory.
        """
        ...

    def getWidth(self) -> int:
        """
        Returns the width of the fields generated by this factory.
        """
        ...

    def hashCode(self) -> int: ...

    def isEnabled(self) -> bool:
        """
        Returns true if this FieldFactory is currently enabled to generate Fields.
        """
        ...

    def newInstance(self, formatModel: ghidra.app.util.viewer.format.FieldFormatModel, highlightProvider: ghidra.app.util.HighlightProvider, options: ghidra.framework.options.ToolOptions, fieldOptions: ghidra.framework.options.ToolOptions) -> ghidra.app.util.viewer.field.FieldFactory:
        """
        Returns a new instance of this FieldFactory that can be used to generate fields
         instead of being used as a prototype.
        @param formatModel the model that the field belongs to.
        @param highlightProvider the HightLightProvider.
        @param options the Options for display properties.
        @param fieldOptions the Options for field specific properties.
        """
        ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def optionsChanged(self, options: ghidra.framework.options.Options, optionName: unicode, oldValue: object, newValue: object) -> None:
        """
        Notification that the Options have changed.
        @param options the Options object that changed. Will be either the display
         options or the field options.
        @param optionName the name of the property that changed.
        @param oldValue the old value of the property.
        @param newValue the new value of the property.
        """
        ...

    def servicesChanged(self) -> None:
        """
        Notification the services changed. Subclasses should override this method
         if they care about service changes.
        """
        ...

    def setEnabled(self, state: bool) -> None:
        """
        Turns on or off the generating of Fields by this FieldFactory.
        @param state if true, this factory will generate fields.
        """
        ...

    def setStartX(self, x: int) -> None:
        """
        Sets the starting x position for the fields generated by this factory.
        """
        ...

    def setWidth(self, w: int) -> None:
        """
        Sets the width of the fields generated by this factory.
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def defaultColor(self) -> java.awt.Color: ...

    @property
    def enabled(self) -> bool: ...

    @enabled.setter
    def enabled(self, value: bool) -> None: ...

    @property
    def fieldModel(self) -> ghidra.app.util.viewer.format.FieldFormatModel: ...

    @property
    def fieldName(self) -> unicode: ...

    @property
    def fieldText(self) -> unicode: ...

    @property
    def metrics(self) -> java.awt.FontMetrics: ...

    @property
    def startX(self) -> int: ...

    @startX.setter
    def startX(self, value: int) -> None: ...

    @property
    def width(self) -> int: ...

    @width.setter
    def width(self, value: int) -> None: ...