from typing import List
import docking.action
import docking.widgets
import docking.widgets.fieldpanel
import docking.widgets.fieldpanel.field
import docking.widgets.fieldpanel.listener
import docking.widgets.fieldpanel.support
import ghidra.app.plugin.core.codebrowser.hover
import ghidra.app.services
import ghidra.app.util
import ghidra.app.util.viewer.format
import ghidra.app.util.viewer.listingpanel
import ghidra.app.util.viewer.util
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.util
import java.awt
import java.awt.dnd
import java.awt.event
import java.awt.im
import java.awt.image
import java.beans
import java.io
import java.lang
import java.util
import javax.accessibility
import javax.swing
import javax.swing.border
import javax.swing.event
import javax.swing.plaf


class ListingPanel(javax.swing.JPanel, docking.widgets.fieldpanel.listener.FieldMouseListener, docking.widgets.fieldpanel.listener.FieldLocationListener, docking.widgets.fieldpanel.listener.FieldSelectionListener, docking.widgets.fieldpanel.listener.LayoutListener):
    DEFAULT_DIVIDER_LOCATION: int = 70



    @overload
    def __init__(self, manager: ghidra.app.util.viewer.format.FormatManager):
        """
        Constructs a new ListingPanel using the given FormatManager and ServiceProvider.
        @param manager the FormatManager to use.
        """
        ...

    @overload
    def __init__(self, mgr: ghidra.app.util.viewer.format.FormatManager, model: ghidra.app.util.viewer.listingpanel.ListingModel):
        """
        Constructs a new ListingPanel with the given FormatManager and ListingLayoutModel
        @param mgr the FormatManager to use
        @param model the ListingLayoutModel to use.
        """
        ...

    @overload
    def __init__(self, mgr: ghidra.app.util.viewer.format.FormatManager, program: ghidra.program.model.listing.Program):
        """
        Constructs a new ListingPanel for the given program.
        @param mgr the FormatManager to use.
        @param program the program for which to create a new ListingPanel
        """
        ...



    def action(self, __a0: java.awt.Event, __a1: object) -> bool: ...

    @overload
    def add(self, __a0: java.awt.Component) -> java.awt.Component: ...

    @overload
    def add(self, __a0: java.awt.PopupMenu) -> None: ...

    @overload
    def add(self, __a0: java.awt.Component, __a1: int) -> java.awt.Component: ...

    @overload
    def add(self, __a0: unicode, __a1: java.awt.Component) -> java.awt.Component: ...

    @overload
    def add(self, __a0: java.awt.Component, __a1: object) -> None: ...

    @overload
    def add(self, __a0: java.awt.Component, __a1: object, __a2: int) -> None: ...

    def addAncestorListener(self, __a0: javax.swing.event.AncestorListener) -> None: ...

    def addButtonPressedListener(self, listener: ghidra.app.services.ButtonPressedListener) -> None:
        """
        Adds a ButtonPressedListener to be notified when the user presses the mouse button while over
         this panel
        @param listener the ButtonPressedListener to add.
        """
        ...

    def addComponentListener(self, __a0: java.awt.event.ComponentListener) -> None: ...

    def addContainerListener(self, __a0: java.awt.event.ContainerListener) -> None: ...

    def addFocusListener(self, __a0: java.awt.event.FocusListener) -> None: ...

    def addHierarchyBoundsListener(self, __a0: java.awt.event.HierarchyBoundsListener) -> None: ...

    def addHierarchyListener(self, __a0: java.awt.event.HierarchyListener) -> None: ...

    def addHighlightProvider(self, highlightProvider: ghidra.app.util.HighlightProvider) -> None:
        """
        Adds a {@link HighlightProvider} to this listing. This highlight provider will be used with
         any other registered providers to paint all the highlights for this listing.
        @param highlightProvider The provider to add
        """
        ...

    def addHoverService(self, hoverService: ghidra.app.plugin.core.codebrowser.hover.ListingHoverService) -> None: ...

    def addIndexMapChangeListener(self, listener: javax.swing.event.ChangeListener) -> None:
        """
        Add a change listener to be notified whenever the indexMap changes.
        @param listener the listener to be added.
        """
        ...

    def addInputMethodListener(self, __a0: java.awt.event.InputMethodListener) -> None: ...

    def addKeyListener(self, __a0: java.awt.event.KeyListener) -> None: ...

    def addListingDisplayListener(self, listener: ghidra.app.util.viewer.listingpanel.ListingDisplayListener) -> None: ...

    def addMarginProvider(self, provider: ghidra.app.util.viewer.listingpanel.MarginProvider) -> None:
        """
        Adds the MarginProvider to this panel
        @param provider the MarginProvider that will provide components to display in this panel's
                    left margin area.
        """
        ...

    def addMouseListener(self, __a0: java.awt.event.MouseListener) -> None: ...

    def addMouseMotionListener(self, __a0: java.awt.event.MouseMotionListener) -> None: ...

    def addMouseWheelListener(self, __a0: java.awt.event.MouseWheelListener) -> None: ...

    def addNotify(self) -> None: ...

    def addOverviewProvider(self, provider: ghidra.app.util.viewer.listingpanel.OverviewProvider) -> None:
        """
        Adds the given OverviewProvider with will be displayed in this panels right margin area.
        @param provider the OverviewProvider to display.
        """
        ...

    @overload
    def addPropertyChangeListener(self, __a0: java.beans.PropertyChangeListener) -> None: ...

    @overload
    def addPropertyChangeListener(self, __a0: unicode, __a1: java.beans.PropertyChangeListener) -> None: ...

    def addVetoableChangeListener(self, __a0: java.beans.VetoableChangeListener) -> None: ...

    def applyComponentOrientation(self, __a0: java.awt.ComponentOrientation) -> None: ...

    def areFocusTraversalKeysSet(self, __a0: int) -> bool: ...

    def buttonPressed(self, fieldLocation: docking.widgets.fieldpanel.support.FieldLocation, field: docking.widgets.fieldpanel.field.Field, mouseEvent: java.awt.event.MouseEvent) -> None: ...

    def center(self, location: ghidra.program.util.ProgramLocation) -> None:
        """
        Center the view of the listing around the given location.
        """
        ...

    @overload
    def checkImage(self, __a0: java.awt.Image, __a1: java.awt.image.ImageObserver) -> int: ...

    @overload
    def checkImage(self, __a0: java.awt.Image, __a1: int, __a2: int, __a3: java.awt.image.ImageObserver) -> int: ...

    def computeVisibleRect(self, __a0: java.awt.Rectangle) -> None: ...

    @overload
    def contains(self, __a0: java.awt.Point) -> bool: ...

    @overload
    def contains(self, __a0: int, __a1: int) -> bool: ...

    def countComponents(self) -> int: ...

    @overload
    def createImage(self, __a0: java.awt.image.ImageProducer) -> java.awt.Image: ...

    @overload
    def createImage(self, __a0: int, __a1: int) -> java.awt.Image: ...

    def createToolTip(self) -> javax.swing.JToolTip: ...

    @overload
    def createVolatileImage(self, __a0: int, __a1: int) -> java.awt.image.VolatileImage: ...

    @overload
    def createVolatileImage(self, __a0: int, __a1: int, __a2: java.awt.ImageCapabilities) -> java.awt.image.VolatileImage: ...

    def deliverEvent(self, __a0: java.awt.Event) -> None: ...

    def disable(self) -> None: ...

    def dispatchEvent(self, __a0: java.awt.AWTEvent) -> None: ...

    def dispose(self) -> None: ...

    def doLayout(self) -> None: ...

    @overload
    def enable(self) -> None: ...

    @overload
    def enable(self, __a0: bool) -> None: ...

    def enableInputMethods(self, __a0: bool) -> None: ...

    def enablePropertyBasedColorModel(self, b: bool) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fieldLocationChanged(self, location: docking.widgets.fieldpanel.support.FieldLocation, field: docking.widgets.fieldpanel.field.Field, trigger: docking.widgets.EventTrigger) -> None: ...

    @overload
    def findComponentAt(self, __a0: java.awt.Point) -> java.awt.Component: ...

    @overload
    def findComponentAt(self, __a0: int, __a1: int) -> java.awt.Component: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: long, __a2: long) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: int, __a2: int) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: int, __a2: int) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: int, __a2: int) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: int, __a2: int) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: float, __a2: float) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: float, __a2: float) -> None: ...

    @overload
    def firePropertyChange(self, __a0: unicode, __a1: bool, __a2: bool) -> None: ...

    def getAccessibleContext(self) -> javax.accessibility.AccessibleContext: ...

    def getActionForKeyStroke(self, __a0: javax.swing.KeyStroke) -> java.awt.event.ActionListener: ...

    def getActionMap(self) -> javax.swing.ActionMap: ...

    def getAddressIndexMap(self) -> ghidra.app.util.viewer.util.AddressIndexMap:
        """
        Returns the AddressIndexMap currently used by this listing panel.
        """
        ...

    def getAlignmentX(self) -> float: ...

    def getAlignmentY(self) -> float: ...

    def getAncestorListeners(self) -> List[javax.swing.event.AncestorListener]: ...

    def getAutoscrolls(self) -> bool: ...

    def getBackground(self) -> java.awt.Color: ...

    def getBaseline(self, __a0: int, __a1: int) -> int: ...

    def getBaselineResizeBehavior(self) -> java.awt.Component.BaselineResizeBehavior: ...

    def getBorder(self) -> javax.swing.border.Border: ...

    @overload
    def getBounds(self) -> java.awt.Rectangle: ...

    @overload
    def getBounds(self, __a0: java.awt.Rectangle) -> java.awt.Rectangle: ...

    def getClass(self) -> java.lang.Class: ...

    def getClientProperty(self, __a0: object) -> object: ...

    def getColorModel(self) -> java.awt.image.ColorModel: ...

    def getComponent(self, __a0: int) -> java.awt.Component: ...

    @overload
    def getComponentAt(self, __a0: java.awt.Point) -> java.awt.Component: ...

    @overload
    def getComponentAt(self, __a0: int, __a1: int) -> java.awt.Component: ...

    def getComponentCount(self) -> int: ...

    def getComponentListeners(self) -> List[java.awt.event.ComponentListener]: ...

    def getComponentOrientation(self) -> java.awt.ComponentOrientation: ...

    def getComponentPopupMenu(self) -> javax.swing.JPopupMenu: ...

    def getComponentZOrder(self, __a0: java.awt.Component) -> int: ...

    def getComponents(self) -> List[java.awt.Component]: ...

    def getConditionForKeyStroke(self, __a0: javax.swing.KeyStroke) -> int: ...

    def getContainerListeners(self) -> List[java.awt.event.ContainerListener]: ...

    def getCursor(self) -> java.awt.Cursor: ...

    def getCursorBounds(self) -> java.awt.Rectangle: ...

    def getCursorLocation(self) -> ghidra.program.util.ProgramLocation: ...

    def getCursorPoint(self) -> java.awt.Point: ...

    def getDebugGraphicsOptions(self) -> int: ...

    @staticmethod
    def getDefaultLocale() -> java.util.Locale: ...

    def getDividerLocation(self) -> int:
        """
        Returns the divider location between the left margin areas and the main display.
        """
        ...

    def getDropTarget(self) -> java.awt.dnd.DropTarget: ...

    def getFieldHeader(self) -> ghidra.app.util.viewer.format.FieldHeader: ...

    def getFieldPanel(self) -> docking.widgets.fieldpanel.FieldPanel:
        """
        Returns the FieldPanel used by this ListingPanel.
        """
        ...

    def getFocusCycleRootAncestor(self) -> java.awt.Container: ...

    def getFocusListeners(self) -> List[java.awt.event.FocusListener]: ...

    def getFocusTraversalKeys(self, __a0: int) -> java.util.Set: ...

    def getFocusTraversalKeysEnabled(self) -> bool: ...

    def getFocusTraversalPolicy(self) -> java.awt.FocusTraversalPolicy: ...

    def getFont(self) -> java.awt.Font: ...

    def getFontMetrics(self, __a0: java.awt.Font) -> java.awt.FontMetrics: ...

    def getForeground(self) -> java.awt.Color: ...

    def getFormatManager(self) -> ghidra.app.util.viewer.format.FormatManager:
        """
        Returns the FormatManager used by this listing panel.
        """
        ...

    def getGraphics(self) -> java.awt.Graphics: ...

    def getGraphicsConfiguration(self) -> java.awt.GraphicsConfiguration: ...

    def getHeaderActions(self, ownerName: unicode) -> List[docking.action.DockingActionIf]: ...

    def getHeight(self) -> int: ...

    def getHierarchyBoundsListeners(self) -> List[java.awt.event.HierarchyBoundsListener]: ...

    def getHierarchyListeners(self) -> List[java.awt.event.HierarchyListener]: ...

    def getIgnoreRepaint(self) -> bool: ...

    def getInheritsPopupMenu(self) -> bool: ...

    def getInputContext(self) -> java.awt.im.InputContext: ...

    @overload
    def getInputMap(self) -> javax.swing.InputMap: ...

    @overload
    def getInputMap(self, __a0: int) -> javax.swing.InputMap: ...

    def getInputMethodListeners(self) -> List[java.awt.event.InputMethodListener]: ...

    def getInputMethodRequests(self) -> java.awt.im.InputMethodRequests: ...

    def getInputVerifier(self) -> javax.swing.InputVerifier: ...

    @overload
    def getInsets(self) -> java.awt.Insets: ...

    @overload
    def getInsets(self, __a0: java.awt.Insets) -> java.awt.Insets: ...

    def getKeyListeners(self) -> List[java.awt.event.KeyListener]: ...

    @overload
    def getLayout(self) -> java.awt.LayoutManager: ...

    @overload
    def getLayout(self, addr: ghidra.program.model.address.Address) -> docking.widgets.fieldpanel.Layout: ...

    def getListeners(self, __a0: java.lang.Class) -> List[java.util.EventListener]: ...

    def getListingModel(self) -> ghidra.app.util.viewer.listingpanel.ListingModel:
        """
        Returns the current ListingModel used by this panel.
        """
        ...

    def getLocale(self) -> java.util.Locale: ...

    @overload
    def getLocation(self) -> java.awt.Point: ...

    @overload
    def getLocation(self, __a0: java.awt.Point) -> java.awt.Point: ...

    def getLocationOnScreen(self) -> java.awt.Point: ...

    def getMarginProviders(self) -> List[ghidra.app.util.viewer.listingpanel.MarginProvider]:
        """
        Get the margin providers in this ListingPanel.
        """
        ...

    def getMaximumSize(self) -> java.awt.Dimension: ...

    def getMinimumSize(self) -> java.awt.Dimension: ...

    def getMouseListeners(self) -> List[java.awt.event.MouseListener]: ...

    def getMouseMotionListeners(self) -> List[java.awt.event.MouseMotionListener]: ...

    @overload
    def getMousePosition(self) -> java.awt.Point: ...

    @overload
    def getMousePosition(self, __a0: bool) -> java.awt.Point: ...

    def getMouseWheelListeners(self) -> List[java.awt.event.MouseWheelListener]: ...

    def getName(self) -> unicode: ...

    def getNextFocusableComponent(self) -> java.awt.Component: ...

    def getOverviewProviders(self) -> List[ghidra.app.util.viewer.listingpanel.OverviewProvider]:
        """
        Get the overview providers in this ListingPanel.
        """
        ...

    def getParent(self) -> java.awt.Container: ...

    def getPopupLocation(self, __a0: java.awt.event.MouseEvent) -> java.awt.Point: ...

    def getPreferredSize(self) -> java.awt.Dimension: ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getProgramHighlight(self) -> ghidra.program.util.ProgramSelection: ...

    @overload
    def getProgramLocation(self) -> ghidra.program.util.ProgramLocation:
        """
        Returns the current program location of the cursor.
        """
        ...

    @overload
    def getProgramLocation(self, point: java.awt.Point) -> ghidra.program.util.ProgramLocation:
        """
        Get a program location for the given point.
        @return program location, or null if point does not correspond to a program location
        """
        ...

    @overload
    def getProgramSelection(self) -> ghidra.program.util.ProgramSelection:
        """
        Returns the current program selection.
        """
        ...

    @overload
    def getProgramSelection(self, fieldSelection: docking.widgets.fieldpanel.support.FieldSelection) -> ghidra.program.util.ProgramSelection: ...

    @overload
    def getPropertyChangeListeners(self) -> List[java.beans.PropertyChangeListener]: ...

    @overload
    def getPropertyChangeListeners(self, __a0: unicode) -> List[java.beans.PropertyChangeListener]: ...

    def getRegisteredKeyStrokes(self) -> List[javax.swing.KeyStroke]: ...

    def getRootPane(self) -> javax.swing.JRootPane: ...

    @overload
    def getSize(self) -> java.awt.Dimension: ...

    @overload
    def getSize(self, __a0: java.awt.Dimension) -> java.awt.Dimension: ...

    def getTextBackgroundColor(self) -> java.awt.Color: ...

    def getToolTipLocation(self, __a0: java.awt.event.MouseEvent) -> java.awt.Point: ...

    @overload
    def getToolTipText(self) -> unicode: ...

    @overload
    def getToolTipText(self, __a0: java.awt.event.MouseEvent) -> unicode: ...

    def getToolkit(self) -> java.awt.Toolkit: ...

    def getTopLevelAncestor(self) -> java.awt.Container: ...

    def getTransferHandler(self) -> javax.swing.TransferHandler: ...

    def getTreeLock(self) -> object: ...

    def getUI(self) -> javax.swing.plaf.ComponentUI: ...

    def getUIClassID(self) -> unicode: ...

    def getVerifyInputWhenFocusTarget(self) -> bool: ...

    def getVerticalScrollBar(self) -> javax.swing.JScrollBar:
        """
        Returns the vertical scrollbar used by this panel.
        """
        ...

    def getVetoableChangeListeners(self) -> List[java.beans.VetoableChangeListener]: ...

    def getView(self) -> ghidra.program.model.address.AddressSetView:
        """
        Gets the view of this listing panel (meant to be used in conjunction with
         {@link #setView(AddressSetView)}.
        """
        ...

    def getVisibleRect(self) -> java.awt.Rectangle: ...

    def getWidth(self) -> int: ...

    def getX(self) -> int: ...

    def getY(self) -> int: ...

    @overload
    def goTo(self, addr: ghidra.program.model.address.Address) -> bool:
        """
        Positions the ListingPanel to the given address.
        @param addr the address at which to position the listing.
        """
        ...

    @overload
    def goTo(self, loc: ghidra.program.util.ProgramLocation) -> bool:
        """
        Moves the cursor to the given program location and repositions the scrollbar to show that
         location in the screen.
        @param loc the location to move to.
        """
        ...

    @overload
    def goTo(self, loc: ghidra.program.util.ProgramLocation, centerWhenNotVisible: bool) -> bool:
        """
        Moves the cursor to the given program location. Also, repositions the scrollbar to show that
         location, if the location is not on the screen.
        @param loc the location to move to.
        @param centerWhenNotVisible this variable only has an effect if the given location is not on
                    the screen. In that case, when this parameter is true, then the given location
                    will be placed in the center of the screen; when the parameter is false, then the
                    screen will be scrolled only enough to show the cursor.
        """
        ...

    @overload
    def goTo(self, currentAddress: ghidra.program.model.address.Address, gotoAddress: ghidra.program.model.address.Address) -> bool:
        """
        Positions the ListingPanel to the given address.
        @param currentAddress used to determine which symbol to goto if the goto address has more
                    than one
        @param gotoAddress the address at which to position to listing.
        @return true if the address exists
        """
        ...

    def gotFocus(self, __a0: java.awt.Event, __a1: object) -> bool: ...

    def grabFocus(self) -> None: ...

    def handleEvent(self, __a0: java.awt.Event) -> bool: ...

    def hasFocus(self) -> bool: ...

    def hashCode(self) -> int: ...

    def hide(self) -> None: ...

    def imageUpdate(self, __a0: java.awt.Image, __a1: int, __a2: int, __a3: int, __a4: int, __a5: int) -> bool: ...

    def inside(self, __a0: int, __a1: int) -> bool: ...

    def invalidate(self) -> None: ...

    def isActive(self) -> bool:
        """
        Returns true if this component has focus.
        """
        ...

    def isAncestorOf(self, __a0: java.awt.Component) -> bool: ...

    def isBackgroundSet(self) -> bool: ...

    def isCursorSet(self) -> bool: ...

    def isDisplayable(self) -> bool: ...

    def isDoubleBuffered(self) -> bool: ...

    def isEnabled(self) -> bool: ...

    @overload
    def isFocusCycleRoot(self) -> bool: ...

    @overload
    def isFocusCycleRoot(self, __a0: java.awt.Container) -> bool: ...

    def isFocusOwner(self) -> bool: ...

    def isFocusTraversable(self) -> bool: ...

    def isFocusTraversalPolicyProvider(self) -> bool: ...

    def isFocusTraversalPolicySet(self) -> bool: ...

    def isFocusable(self) -> bool: ...

    def isFontSet(self) -> bool: ...

    def isForegroundSet(self) -> bool: ...

    def isHeaderShowing(self) -> bool:
        """
        Returns true if the field header component is showing.
        """
        ...

    def isHoverShowing(self) -> bool: ...

    def isLightweight(self) -> bool: ...

    @staticmethod
    def isLightweightComponent(__a0: java.awt.Component) -> bool: ...

    def isManagingFocus(self) -> bool: ...

    def isMaximumSizeSet(self) -> bool: ...

    def isMinimumSizeSet(self) -> bool: ...

    def isOpaque(self) -> bool: ...

    def isOptimizedDrawingEnabled(self) -> bool: ...

    def isPaintingForPrint(self) -> bool: ...

    def isPaintingTile(self) -> bool: ...

    def isPreferredSizeSet(self) -> bool: ...

    def isRequestFocusEnabled(self) -> bool: ...

    def isShowing(self) -> bool: ...

    def isStartDragOk(self) -> bool:
        """
        Returns true if the mouse is at a location that can be dragged.
        """
        ...

    def isValid(self) -> bool: ...

    def isValidateRoot(self) -> bool: ...

    def isVisible(self) -> bool: ...

    def keyDown(self, __a0: java.awt.Event, __a1: int) -> bool: ...

    def keyUp(self, __a0: java.awt.Event, __a1: int) -> bool: ...

    def layoutsChanged(self, __a0: List[object]) -> None: ...

    @overload
    def list(self) -> None: ...

    @overload
    def list(self, __a0: java.io.PrintStream) -> None: ...

    @overload
    def list(self, __a0: java.io.PrintWriter) -> None: ...

    @overload
    def list(self, __a0: java.io.PrintStream, __a1: int) -> None: ...

    @overload
    def list(self, __a0: java.io.PrintWriter, __a1: int) -> None: ...

    def locate(self, __a0: int, __a1: int) -> java.awt.Component: ...

    def location(self) -> java.awt.Point: ...

    def lostFocus(self, __a0: java.awt.Event, __a1: object) -> bool: ...

    def mouseDown(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def mouseDrag(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def mouseEnter(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def mouseExit(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def mouseMove(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def mouseUp(self, __a0: java.awt.Event, __a1: int, __a2: int) -> bool: ...

    def move(self, __a0: int, __a1: int) -> None: ...

    def nextFocus(self) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def paint(self, __a0: java.awt.Graphics) -> None: ...

    def paintAll(self, __a0: java.awt.Graphics) -> None: ...

    def paintComponents(self, __a0: java.awt.Graphics) -> None: ...

    @overload
    def paintImmediately(self, __a0: java.awt.Rectangle) -> None: ...

    @overload
    def paintImmediately(self, __a0: int, __a1: int, __a2: int, __a3: int) -> None: ...

    def postEvent(self, __a0: java.awt.Event) -> bool: ...

    @overload
    def prepareImage(self, __a0: java.awt.Image, __a1: java.awt.image.ImageObserver) -> bool: ...

    @overload
    def prepareImage(self, __a0: java.awt.Image, __a1: int, __a2: int, __a3: java.awt.image.ImageObserver) -> bool: ...

    def print(self, __a0: java.awt.Graphics) -> None: ...

    def printAll(self, __a0: java.awt.Graphics) -> None: ...

    def printComponents(self, __a0: java.awt.Graphics) -> None: ...

    def putClientProperty(self, __a0: object, __a1: object) -> None: ...

    @overload
    def registerKeyboardAction(self, __a0: java.awt.event.ActionListener, __a1: javax.swing.KeyStroke, __a2: int) -> None: ...

    @overload
    def registerKeyboardAction(self, __a0: java.awt.event.ActionListener, __a1: unicode, __a2: javax.swing.KeyStroke, __a3: int) -> None: ...

    @overload
    def remove(self, __a0: int) -> None: ...

    @overload
    def remove(self, __a0: java.awt.Component) -> None: ...

    @overload
    def remove(self, __a0: java.awt.MenuComponent) -> None: ...

    def removeAll(self) -> None: ...

    def removeAncestorListener(self, __a0: javax.swing.event.AncestorListener) -> None: ...

    def removeButtonPressedListener(self, listener: ghidra.app.services.ButtonPressedListener) -> None:
        """
        Removes the given ButtonPressedListener.
        @param listener the ButtonPressedListener to remove.
        """
        ...

    def removeComponentListener(self, __a0: java.awt.event.ComponentListener) -> None: ...

    def removeContainerListener(self, __a0: java.awt.event.ContainerListener) -> None: ...

    def removeFocusListener(self, __a0: java.awt.event.FocusListener) -> None: ...

    def removeHierarchyBoundsListener(self, __a0: java.awt.event.HierarchyBoundsListener) -> None: ...

    def removeHierarchyListener(self, __a0: java.awt.event.HierarchyListener) -> None: ...

    def removeHighlightProvider(self, highlightProvider: ghidra.app.util.HighlightProvider) -> None:
        """
        Removes the given {@link HighlightProvider} from this listing.
        @param highlightProvider The provider to remove.
        @see #addHighlightProvider(HighlightProvider)
        """
        ...

    def removeHoverService(self, hoverService: ghidra.app.plugin.core.codebrowser.hover.ListingHoverService) -> None: ...

    def removeIndexMapChangeListener(self, listener: javax.swing.event.ChangeListener) -> None:
        """
        Removes the change listener to be notified when the indexMap changes.
        @param listener the listener to be removed.
        """
        ...

    def removeInputMethodListener(self, __a0: java.awt.event.InputMethodListener) -> None: ...

    def removeKeyListener(self, __a0: java.awt.event.KeyListener) -> None: ...

    def removeListingDisplayListener(self, listener: ghidra.app.util.viewer.listingpanel.ListingDisplayListener) -> None: ...

    def removeMarginProvider(self, provider: ghidra.app.util.viewer.listingpanel.MarginProvider) -> None:
        """
        Removes the given margin provider from this panel
        @param provider the MarginProvider to remove.
        """
        ...

    def removeMouseListener(self, __a0: java.awt.event.MouseListener) -> None: ...

    def removeMouseMotionListener(self, __a0: java.awt.event.MouseMotionListener) -> None: ...

    def removeMouseWheelListener(self, __a0: java.awt.event.MouseWheelListener) -> None: ...

    def removeNotify(self) -> None: ...

    def removeOverviewProvider(self, provider: ghidra.app.util.viewer.listingpanel.OverviewProvider) -> None:
        """
        Removes the given OverviewProvider from this panel
        @param provider the OverviewProvider to remove.
        """
        ...

    @overload
    def removePropertyChangeListener(self, __a0: java.beans.PropertyChangeListener) -> None: ...

    @overload
    def removePropertyChangeListener(self, __a0: unicode, __a1: java.beans.PropertyChangeListener) -> None: ...

    def removeVetoableChangeListener(self, __a0: java.beans.VetoableChangeListener) -> None: ...

    @overload
    def repaint(self) -> None: ...

    @overload
    def repaint(self, __a0: long) -> None: ...

    @overload
    def repaint(self, __a0: java.awt.Rectangle) -> None: ...

    @overload
    def repaint(self, __a0: int, __a1: int, __a2: int, __a3: int) -> None: ...

    @overload
    def repaint(self, __a0: long, __a1: int, __a2: int, __a3: int, __a4: int) -> None: ...

    def requestDefaultFocus(self) -> bool: ...

    @overload
    def requestFocus(self) -> None: ...

    @overload
    def requestFocus(self, __a0: bool) -> bool: ...

    @overload
    def requestFocus(self, __a0: java.awt.event.FocusEvent.Cause) -> None: ...

    @overload
    def requestFocusInWindow(self) -> bool: ...

    @overload
    def requestFocusInWindow(self, __a0: java.awt.event.FocusEvent.Cause) -> bool: ...

    def resetKeyboardActions(self) -> None: ...

    def reshape(self, __a0: int, __a1: int, __a2: int, __a3: int) -> None: ...

    @overload
    def resize(self, __a0: java.awt.Dimension) -> None: ...

    @overload
    def resize(self, __a0: int, __a1: int) -> None: ...

    def revalidate(self) -> None: ...

    def scrollRectToVisible(self, __a0: java.awt.Rectangle) -> None: ...

    def scrollTo(self, location: ghidra.program.util.ProgramLocation) -> None:
        """
        Scroll the view of the listing to the given location.
        """
        ...

    def selectAll(self) -> None:
        """
        Sets the selection to the entire listing view.
        """
        ...

    def selectComplement(self) -> ghidra.program.model.address.AddressSet:
        """
        Sets the selection to the complement of the current selection in the listing view.
        """
        ...

    def selectionChanged(self, selection: docking.widgets.fieldpanel.support.FieldSelection, trigger: docking.widgets.EventTrigger) -> None: ...

    def setActionMap(self, __a0: javax.swing.ActionMap) -> None: ...

    def setAlignmentX(self, __a0: float) -> None: ...

    def setAlignmentY(self, __a0: float) -> None: ...

    def setAutoscrolls(self, __a0: bool) -> None: ...

    def setBackground(self, __a0: java.awt.Color) -> None: ...

    def setBackgroundColorModel(self, colorModel: ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel) -> None:
        """
        Sets the externally supplied {@link ListingBackgroundColorModel} to be blended with its own
         {@link PropertyBasedBackgroundColorModel}.
        @param colorModel the {@link ListingBackgroundColorModel} to use in conjunction with the
                    built-in {@link PropertyBasedBackgroundColorModel}
        """
        ...

    def setBorder(self, __a0: javax.swing.border.Border) -> None: ...

    @overload
    def setBounds(self, __a0: java.awt.Rectangle) -> None: ...

    @overload
    def setBounds(self, __a0: int, __a1: int, __a2: int, __a3: int) -> None: ...

    def setComponentOrientation(self, __a0: java.awt.ComponentOrientation) -> None: ...

    def setComponentPopupMenu(self, __a0: javax.swing.JPopupMenu) -> None: ...

    def setComponentZOrder(self, __a0: java.awt.Component, __a1: int) -> None: ...

    def setCursor(self, __a0: java.awt.Cursor) -> None: ...

    @overload
    def setCursorPosition(self, loc: ghidra.program.util.ProgramLocation) -> None:
        """
        Sets the cursor to the given program location.
        @param loc the location at which to move the cursor.
        """
        ...

    @overload
    def setCursorPosition(self, loc: ghidra.program.util.ProgramLocation, trigger: docking.widgets.EventTrigger) -> None:
        """
        Sets the cursor to the given program location with a given trigger
 
         This method should only be used in automated testing to programmatically simulate a user
         navigating within the listing panel.
        @param loc the location at which to move the cursor.
        @param trigger the event trigger
        """
        ...

    def setDebugGraphicsOptions(self, __a0: int) -> None: ...

    @staticmethod
    def setDefaultLocale(__a0: java.util.Locale) -> None: ...

    def setDividerLocation(self, dividerLocation: int) -> None:
        """
        Sets the divider location between the left margin areas and the main display.
        @param dividerLocation the location to set on the divider.
        """
        ...

    def setDoubleBuffered(self, __a0: bool) -> None: ...

    def setDropTarget(self, __a0: java.awt.dnd.DropTarget) -> None: ...

    def setEnabled(self, __a0: bool) -> None: ...

    def setFocusCycleRoot(self, __a0: bool) -> None: ...

    def setFocusTraversalKeys(self, __a0: int, __a1: java.util.Set) -> None: ...

    def setFocusTraversalKeysEnabled(self, __a0: bool) -> None: ...

    def setFocusTraversalPolicy(self, __a0: java.awt.FocusTraversalPolicy) -> None: ...

    def setFocusTraversalPolicyProvider(self, __a0: bool) -> None: ...

    def setFocusable(self, __a0: bool) -> None: ...

    def setFont(self, __a0: java.awt.Font) -> None: ...

    def setForeground(self, __a0: java.awt.Color) -> None: ...

    def setFormatManager(self, formatManager: ghidra.app.util.viewer.format.FormatManager) -> None: ...

    def setHighlight(self, highlight: ghidra.program.util.ProgramSelection) -> None:
        """
        Sets the highlight.
        @param highlight the new highlight.
        """
        ...

    def setHoverMode(self, enabled: bool) -> None: ...

    def setIgnoreRepaint(self, __a0: bool) -> None: ...

    def setInheritsPopupMenu(self, __a0: bool) -> None: ...

    def setInputMap(self, __a0: int, __a1: javax.swing.InputMap) -> None: ...

    def setInputVerifier(self, __a0: javax.swing.InputVerifier) -> None: ...

    def setLayout(self, __a0: java.awt.LayoutManager) -> None: ...

    def setListingHoverHandler(self, handler: ghidra.app.util.viewer.listingpanel.ListingHoverProvider) -> None: ...

    def setListingModel(self, newModel: ghidra.app.util.viewer.listingpanel.ListingModel) -> None:
        """
        Sets the ListingLayoutModel to use.
        @param newModel the model to use.
        """
        ...

    def setLocale(self, __a0: java.util.Locale) -> None: ...

    @overload
    def setLocation(self, __a0: java.awt.Point) -> None: ...

    @overload
    def setLocation(self, __a0: int, __a1: int) -> None: ...

    def setMaximumSize(self, __a0: java.awt.Dimension) -> None: ...

    def setMinimumSize(self, __a0: java.awt.Dimension) -> None: ...

    def setMixingCutoutShape(self, __a0: java.awt.Shape) -> None: ...

    def setName(self, __a0: unicode) -> None: ...

    def setNeverSroll(self) -> None:
        """
        Sets listing panel to never show scroll bars. This is useful when you want this listing's
         parent to always be as big as this listing.
        """
        ...

    def setNextFocusableComponent(self, __a0: java.awt.Component) -> None: ...

    def setOpaque(self, __a0: bool) -> None: ...

    def setPreferredSize(self, __a0: java.awt.Dimension) -> None: ...

    def setProgram(self, program: ghidra.program.model.listing.Program) -> None:
        """
        Sets the program to be displayed by this listing panel
        @param program the program to display.
        """
        ...

    def setProgramLocationListener(self, listener: ghidra.app.util.viewer.listingpanel.ProgramLocationListener) -> None:
        """
        Sets the ProgramLocationListener. Only one listener is supported
        @param listener the ProgramLocationListener to use.
        """
        ...

    def setProgramSelectionListener(self, listener: ghidra.app.util.viewer.listingpanel.ProgramSelectionListener) -> None:
        """
        Sets the ProgramSelectionListener. Only one listener is supported
        @param listener the ProgramSelectionListener to use.
        """
        ...

    def setRequestFocusEnabled(self, __a0: bool) -> None: ...

    def setSelection(self, sel: ghidra.program.util.ProgramSelection) -> None:
        """
        Sets the selection.
        @param sel the new selection
        """
        ...

    @overload
    def setSize(self, __a0: java.awt.Dimension) -> None: ...

    @overload
    def setSize(self, __a0: int, __a1: int) -> None: ...

    def setStringSelectionListener(self, listener: ghidra.app.util.viewer.listingpanel.StringSelectionListener) -> None: ...

    def setTextBackgroundColor(self, c: java.awt.Color) -> None:
        """
        Sets the background color for the listing panel. This will set the background for the main
         listing display.
        """
        ...

    def setToolTipText(self, __a0: unicode) -> None: ...

    def setTransferHandler(self, __a0: javax.swing.TransferHandler) -> None: ...

    def setUI(self, __a0: javax.swing.plaf.PanelUI) -> None: ...

    def setVerifyInputWhenFocusTarget(self, __a0: bool) -> None: ...

    def setView(self, view: ghidra.program.model.address.AddressSetView) -> None:
        """
        Restricts the program's view to the given address set
        @param view the set of address to include in the view.
        """
        ...

    def setVisible(self, __a0: bool) -> None: ...

    @overload
    def show(self) -> None: ...

    @overload
    def show(self, __a0: bool) -> None: ...

    def showHeader(self, show: bool) -> None:
        """
        Sets whether or not the field header component is visible at the top of the listing panel
        @param show if true, the header component will be show, otherwise it will be hidden.
        """
        ...

    def toString(self) -> unicode: ...

    def transferFocus(self) -> None: ...

    def transferFocusBackward(self) -> None: ...

    def transferFocusDownCycle(self) -> None: ...

    def transferFocusUpCycle(self) -> None: ...

    def unregisterKeyboardAction(self, __a0: javax.swing.KeyStroke) -> None: ...

    def update(self, __a0: java.awt.Graphics) -> None: ...

    def updateDisplay(self, updateImmediately: bool) -> None: ...

    def updateUI(self) -> None: ...

    def validate(self) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def active(self) -> bool: ...

    @property
    def addressIndexMap(self) -> ghidra.app.util.viewer.util.AddressIndexMap: ...

    @property
    def backgroundColorModel(self) -> None: ...  # No getter available.

    @backgroundColorModel.setter
    def backgroundColorModel(self, value: ghidra.app.util.viewer.listingpanel.ListingBackgroundColorModel) -> None: ...

    @property
    def cursorBounds(self) -> java.awt.Rectangle: ...

    @property
    def cursorLocation(self) -> ghidra.program.util.ProgramLocation: ...

    @property
    def cursorPoint(self) -> java.awt.Point: ...

    @property
    def cursorPosition(self) -> None: ...  # No getter available.

    @cursorPosition.setter
    def cursorPosition(self, value: ghidra.program.util.ProgramLocation) -> None: ...

    @property
    def dividerLocation(self) -> int: ...

    @dividerLocation.setter
    def dividerLocation(self, value: int) -> None: ...

    @property
    def fieldHeader(self) -> ghidra.app.util.viewer.format.FieldHeader: ...

    @property
    def fieldPanel(self) -> docking.widgets.fieldpanel.FieldPanel: ...

    @property
    def formatManager(self) -> ghidra.app.util.viewer.format.FormatManager: ...

    @formatManager.setter
    def formatManager(self, value: ghidra.app.util.viewer.format.FormatManager) -> None: ...

    @property
    def headerShowing(self) -> bool: ...

    @property
    def highlight(self) -> None: ...  # No getter available.

    @highlight.setter
    def highlight(self, value: ghidra.program.util.ProgramSelection) -> None: ...

    @property
    def hoverMode(self) -> None: ...  # No getter available.

    @hoverMode.setter
    def hoverMode(self, value: bool) -> None: ...

    @property
    def hoverShowing(self) -> bool: ...

    @property
    def listingHoverHandler(self) -> None: ...  # No getter available.

    @listingHoverHandler.setter
    def listingHoverHandler(self, value: ghidra.app.util.viewer.listingpanel.ListingHoverProvider) -> None: ...

    @property
    def listingModel(self) -> ghidra.app.util.viewer.listingpanel.ListingModel: ...

    @listingModel.setter
    def listingModel(self, value: ghidra.app.util.viewer.listingpanel.ListingModel) -> None: ...

    @property
    def marginProviders(self) -> List[object]: ...

    @property
    def overviewProviders(self) -> List[object]: ...

    @property
    def preferredSize(self) -> java.awt.Dimension: ...

    @preferredSize.setter
    def preferredSize(self, value: java.awt.Dimension) -> None: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @program.setter
    def program(self, value: ghidra.program.model.listing.Program) -> None: ...

    @property
    def programHighlight(self) -> ghidra.program.util.ProgramSelection: ...

    @property
    def programLocation(self) -> ghidra.program.util.ProgramLocation: ...

    @property
    def programLocationListener(self) -> None: ...  # No getter available.

    @programLocationListener.setter
    def programLocationListener(self, value: ghidra.app.util.viewer.listingpanel.ProgramLocationListener) -> None: ...

    @property
    def programSelection(self) -> ghidra.program.util.ProgramSelection: ...

    @property
    def programSelectionListener(self) -> None: ...  # No getter available.

    @programSelectionListener.setter
    def programSelectionListener(self, value: ghidra.app.util.viewer.listingpanel.ProgramSelectionListener) -> None: ...

    @property
    def selection(self) -> None: ...  # No getter available.

    @selection.setter
    def selection(self, value: ghidra.program.util.ProgramSelection) -> None: ...

    @property
    def startDragOk(self) -> bool: ...

    @property
    def stringSelectionListener(self) -> None: ...  # No getter available.

    @stringSelectionListener.setter
    def stringSelectionListener(self, value: ghidra.app.util.viewer.listingpanel.StringSelectionListener) -> None: ...

    @property
    def textBackgroundColor(self) -> java.awt.Color: ...

    @textBackgroundColor.setter
    def textBackgroundColor(self, value: java.awt.Color) -> None: ...

    @property
    def verticalScrollBar(self) -> javax.swing.JScrollBar: ...

    @property
    def view(self) -> ghidra.program.model.address.AddressSetView: ...

    @view.setter
    def view(self, value: ghidra.program.model.address.AddressSetView) -> None: ...