from typing import List
import docking
import ghidra.app.plugin.core.colorizer
import ghidra.feature.vt.api.main
import ghidra.feature.vt.gui.plugin
import ghidra.feature.vt.gui.task
import ghidra.feature.vt.gui.util
import ghidra.framework.model
import ghidra.framework.options
import ghidra.framework.plugintool
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.symbol
import ghidra.program.util
import java.awt
import java.lang


class VTController(object):
    VERSION_TRACKING_OPTIONS_NAME: unicode = u'Version Tracking'







    def addListener(self, __a0: ghidra.feature.vt.gui.plugin.VTControllerListener) -> None: ...

    def checkForUnSavedChanges(self) -> bool: ...

    def closeCurrentSessionIgnoringChanges(self) -> None: ...

    def closeVersionTrackingSession(self) -> bool: ...

    def dispose(self) -> None: ...

    def domainObjectChanged(self, __a0: ghidra.framework.model.DomainObjectChangedEvent) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    @overload
    def getCorrelator(self) -> ghidra.feature.vt.gui.plugin.AddressCorrelatorManager: ...

    @overload
    def getCorrelator(self, __a0: ghidra.program.model.listing.Data, __a1: ghidra.program.model.listing.Data) -> ghidra.program.util.AddressCorrelation: ...

    @overload
    def getCorrelator(self, __a0: ghidra.program.model.listing.Function, __a1: ghidra.program.model.listing.Function) -> ghidra.program.util.AddressCorrelation: ...

    def getCurrentMarkupForLocation(self, __a0: ghidra.program.util.ProgramLocation, __a1: ghidra.program.model.listing.Program) -> ghidra.feature.vt.api.main.VTMarkupItem: ...

    def getDestinationColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    def getDestinationProgram(self) -> ghidra.program.model.listing.Program: ...

    def getDestinationSymbol(self, __a0: ghidra.feature.vt.api.main.VTAssociation) -> ghidra.program.model.symbol.Symbol: ...

    def getMarkupItems(self, __a0: docking.ActionContext) -> List[object]: ...

    @overload
    def getMatchInfo(self) -> ghidra.feature.vt.gui.util.MatchInfo: ...

    @overload
    def getMatchInfo(self, __a0: ghidra.feature.vt.api.main.VTMatch) -> ghidra.feature.vt.gui.util.MatchInfo: ...

    def getOptions(self) -> ghidra.framework.options.ToolOptions: ...

    def getParentComponent(self) -> java.awt.Component: ...

    def getSelectionInDestinationTool(self) -> ghidra.program.model.address.AddressSetView: ...

    def getSelectionInSourceTool(self) -> ghidra.program.model.address.AddressSetView: ...

    def getServiceProvider(self) -> ghidra.framework.plugintool.ServiceProvider: ...

    def getSession(self) -> ghidra.feature.vt.api.main.VTSession: ...

    def getSourceColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    def getSourceProgram(self) -> ghidra.program.model.listing.Program: ...

    def getSourceSymbol(self, __a0: ghidra.feature.vt.api.main.VTAssociation) -> ghidra.program.model.symbol.Symbol: ...

    def getTool(self) -> ghidra.framework.plugintool.PluginTool: ...

    def getVersionTrackingSessionName(self) -> unicode: ...

    def gotoDestinationLocation(self, __a0: ghidra.program.util.ProgramLocation) -> None: ...

    def gotoSourceLocation(self, __a0: ghidra.program.util.ProgramLocation) -> None: ...

    def hashCode(self) -> int: ...

    def markupItemStatusChanged(self, __a0: ghidra.feature.vt.api.main.VTMarkupItem) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def openVersionTrackingSession(self, __a0: ghidra.feature.vt.api.main.VTSession) -> None: ...

    @overload
    def openVersionTrackingSession(self, __a0: ghidra.framework.model.DomainFile) -> None: ...

    def optionsChanged(self, __a0: ghidra.framework.options.ToolOptions, __a1: unicode, __a2: object, __a3: object) -> None: ...

    def readConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def refresh(self) -> None: ...

    def removeListener(self, __a0: ghidra.feature.vt.gui.plugin.VTControllerListener) -> None: ...

    def runVTTask(self, __a0: ghidra.feature.vt.gui.task.VtTask) -> None: ...

    def setSelectedMarkupItem(self, __a0: ghidra.feature.vt.api.main.VTMarkupItem) -> None: ...

    def setSelectedMatch(self, __a0: ghidra.feature.vt.api.main.VTMatch) -> None: ...

    def setSelectionInDestinationTool(self, __a0: ghidra.program.model.address.AddressSetView) -> None: ...

    def setSelectionInSourceTool(self, __a0: ghidra.program.model.address.AddressSetView) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def writeConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    @property
    def correlator(self) -> ghidra.feature.vt.gui.plugin.AddressCorrelatorManager: ...

    @property
    def destinationColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    @property
    def destinationProgram(self) -> ghidra.program.model.listing.Program: ...

    @property
    def matchInfo(self) -> ghidra.feature.vt.gui.util.MatchInfo: ...

    @property
    def options(self) -> ghidra.framework.options.ToolOptions: ...

    @property
    def parentComponent(self) -> java.awt.Component: ...

    @property
    def selectedMarkupItem(self) -> None: ...  # No getter available.

    @selectedMarkupItem.setter
    def selectedMarkupItem(self, value: ghidra.feature.vt.api.main.VTMarkupItem) -> None: ...

    @property
    def selectedMatch(self) -> None: ...  # No getter available.

    @selectedMatch.setter
    def selectedMatch(self, value: ghidra.feature.vt.api.main.VTMatch) -> None: ...

    @property
    def selectionInDestinationTool(self) -> ghidra.program.model.address.AddressSetView: ...

    @selectionInDestinationTool.setter
    def selectionInDestinationTool(self, value: ghidra.program.model.address.AddressSetView) -> None: ...

    @property
    def selectionInSourceTool(self) -> ghidra.program.model.address.AddressSetView: ...

    @selectionInSourceTool.setter
    def selectionInSourceTool(self, value: ghidra.program.model.address.AddressSetView) -> None: ...

    @property
    def serviceProvider(self) -> ghidra.framework.plugintool.ServiceProvider: ...

    @property
    def session(self) -> ghidra.feature.vt.api.main.VTSession: ...

    @property
    def sourceColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    @property
    def sourceProgram(self) -> ghidra.program.model.listing.Program: ...

    @property
    def tool(self) -> ghidra.framework.plugintool.PluginTool: ...

    @property
    def versionTrackingSessionName(self) -> unicode: ...