from typing import List
import ghidra.app.plugin.core.colorizer
import ghidra.feature.vt.gui.plugin
import ghidra.feature.vt.gui.provider.matchtable
import ghidra.framework.model
import ghidra.framework.options
import ghidra.framework.plugintool
import ghidra.framework.plugintool.util
import ghidra.program.model.address
import ghidra.program.util
import java.lang


class VTPlugin(ghidra.framework.plugintool.Plugin):
    ADDRESS_EDIT_MENU_GROUP: unicode = u'A_VT_X_AddressEdit'
    APPLY_EDIT_MENU_GROUP: unicode = u'A_VT_Apply_Edit'
    EDIT_MENU_GROUP: unicode = u'A_VT_Edit_1'
    FILTERED_ICON: javax.swing.Icon = jar:file:/opt/hostedtoolcache/ghidra/9.2.2/x64/Ghidra/Features/VersionTracking/lib/VersionTracking.jar!/images/lightbulb.png
    HELP_TOPIC_NAME: unicode = u'VersionTrackingPlugin'
    MARKUP_POPUP_MENU_NAME: unicode = u'Version Tracking Markup'
    MATCH_POPUP_MENU_NAME: unicode = u'Version Tracking Match'
    OWNER: unicode
    REPLACED_ICON: javax.swing.Icon = jar:file:/opt/hostedtoolcache/ghidra/9.2.2/x64/Ghidra/Features/VersionTracking/lib/VersionTracking.jar!/images/sync_enabled.png
    TAG_MENU_GROUP: unicode = u'A_VT_Edit_2'
    UNEDIT_MENU_GROUP: unicode = u'A_VT_UnEdit'
    UNFILTERED_ICON: javax.swing.Icon = jar:file:/opt/hostedtoolcache/ghidra/9.2.2/x64/Ghidra/Features/VersionTracking/lib/VersionTracking.jar!/images/lightbulb_off.png
    UNIGNORED_ICON: javax.swing.Icon = ghidra.feature.vt.gui.plugin.VTPlugin$1@2c78a1eb
    VT_MAIN_MENU_GROUP: unicode = u'AAA_VT_Main'
    VT_SETTINGS_MENU_GROUP: unicode = u'ZZ_VT_SETTINGS'
    WINDOW_GROUP: unicode = u'VTResults'



    def __init__(self, __a0: ghidra.framework.plugintool.PluginTool): ...



    def acceptData(self, __a0: List[ghidra.framework.model.DomainFile]) -> bool: ...

    def dataStateRestoreCompleted(self) -> None: ...

    def dependsUpon(self, __a0: ghidra.framework.plugintool.Plugin) -> bool: ...

    def equals(self, __a0: object) -> bool: ...

    def eventSent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def firePluginEvent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def getChangedProgramsInDestinationTool(self) -> List[object]: ...

    def getChangedProgramsInSourceTool(self) -> List[object]: ...

    def getClass(self) -> java.lang.Class: ...

    def getController(self) -> ghidra.feature.vt.gui.plugin.VTController: ...

    def getData(self) -> List[ghidra.framework.model.DomainFile]: ...

    def getDestinationColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    def getMatchesProvider(self) -> ghidra.feature.vt.gui.provider.matchtable.VTMatchTableProvider: ...

    def getMissingRequiredServices(self) -> List[object]: ...

    def getName(self) -> unicode: ...

    def getPluginDescription(self) -> ghidra.framework.plugintool.util.PluginDescription: ...

    @staticmethod
    def getPluginName(__a0: java.lang.Class) -> unicode: ...

    def getSelectionInDestinationTool(self) -> ghidra.program.model.address.AddressSetView: ...

    def getSelectionInSourceTool(self) -> ghidra.program.model.address.AddressSetView: ...

    def getSourceColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    def getSupportedDataTypes(self) -> List[java.lang.Class]: ...

    def getTool(self) -> ghidra.framework.plugintool.PluginTool: ...

    def getToolManager(self) -> ghidra.feature.vt.gui.plugin.VTSubToolManager: ...

    def getTransientState(self) -> object: ...

    def getUndoRedoState(self, __a0: ghidra.framework.model.DomainObject) -> object: ...

    def gotoDestinationLocation(self, __a0: ghidra.program.util.ProgramLocation) -> None: ...

    def gotoSourceLocation(self, __a0: ghidra.program.util.ProgramLocation) -> None: ...

    def hasMissingRequiredService(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isDisposed(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def processEvent(self, __a0: ghidra.framework.plugintool.PluginEvent) -> None: ...

    def readConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def readDataState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def restoreTransientState(self, __a0: object) -> None: ...

    def restoreUndoRedoState(self, __a0: ghidra.framework.model.DomainObject, __a1: object) -> None: ...

    def serviceAdded(self, __a0: java.lang.Class, __a1: object) -> None: ...

    def serviceRemoved(self, __a0: java.lang.Class, __a1: object) -> None: ...

    def setSelectionInDestinationTool(self, __a0: ghidra.program.model.address.AddressSetView) -> None: ...

    def setSelectionInSourceTool(self, __a0: ghidra.program.model.address.AddressSetView) -> None: ...

    def toString(self) -> unicode: ...

    def updateUndoActions(self) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def writeConfigState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    def writeDataState(self, __a0: ghidra.framework.options.SaveState) -> None: ...

    @property
    def changedProgramsInDestinationTool(self) -> List[object]: ...

    @property
    def changedProgramsInSourceTool(self) -> List[object]: ...

    @property
    def controller(self) -> ghidra.feature.vt.gui.plugin.VTController: ...

    @property
    def destinationColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    @property
    def matchesProvider(self) -> ghidra.feature.vt.gui.provider.matchtable.VTMatchTableProvider: ...

    @property
    def selectionInDestinationTool(self) -> ghidra.program.model.address.AddressSetView: ...

    @selectionInDestinationTool.setter
    def selectionInDestinationTool(self, value: ghidra.program.model.address.AddressSetView) -> None: ...

    @property
    def selectionInSourceTool(self) -> ghidra.program.model.address.AddressSetView: ...

    @selectionInSourceTool.setter
    def selectionInSourceTool(self, value: ghidra.program.model.address.AddressSetView) -> None: ...

    @property
    def sourceColorizingService(self) -> ghidra.app.plugin.core.colorizer.ColorizingService: ...

    @property
    def supportedDataTypes(self) -> List[java.lang.Class]: ...

    @property
    def toolManager(self) -> ghidra.feature.vt.gui.plugin.VTSubToolManager: ...