from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.android.dex.format
import ghidra.program.model.data
import java.lang


class CodeItem(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getDebugInfo(self) -> ghidra.file.formats.android.dex.format.DebugInfoItem: ...

    def getDebugInfoOffset(self) -> int: ...

    def getHandlerList(self) -> ghidra.file.formats.android.dex.format.EncodedCatchHandlerList: ...

    def getIncomingSize(self) -> int: ...

    def getInstructionBytes(self) -> List[int]: ...

    def getInstructionSize(self) -> int: ...

    def getInstructions(self) -> List[int]: ...

    def getOutgoingSize(self) -> int: ...

    def getPadding(self) -> int: ...

    def getRegistersSize(self) -> int: ...

    def getTries(self) -> List[object]: ...

    def getTriesSize(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def debugInfo(self) -> ghidra.file.formats.android.dex.format.DebugInfoItem: ...

    @property
    def debugInfoOffset(self) -> int: ...

    @property
    def handlerList(self) -> ghidra.file.formats.android.dex.format.EncodedCatchHandlerList: ...

    @property
    def incomingSize(self) -> int: ...

    @property
    def instructionBytes(self) -> List[int]: ...

    @property
    def instructionSize(self) -> int: ...

    @property
    def instructions(self) -> List[int]: ...

    @property
    def outgoingSize(self) -> int: ...

    @property
    def padding(self) -> int: ...

    @property
    def registersSize(self) -> int: ...

    @property
    def tries(self) -> List[object]: ...

    @property
    def triesSize(self) -> int: ...