from typing import Iterator
from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.android.dex.format
import ghidra.program.model.address
import ghidra.program.model.data
import ghidra.program.model.listing
import ghidra.util.datastruct
import java.lang
import java.util
import java.util.function


class DexHeader(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word




    class DataTypeCache(ghidra.util.datastruct.FixedSizeHashMap):




        def __init__(self): ...

        def __iter__(self): ...

        def clear(self) -> None: ...

        def clone(self) -> object: ...

        def compute(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

        def computeIfAbsent(self, __a0: object, __a1: java.util.function.Function) -> object: ...

        def computeIfPresent(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

        def containsKey(self, __a0: object) -> bool: ...

        def containsValue(self, __a0: object) -> bool: ...

        @staticmethod
        def copyOf(__a0: java.util.Map) -> java.util.Map: ...

        @staticmethod
        def entry(__a0: object, __a1: object) -> java.util.Map.Entry: ...

        def entrySet(self) -> java.util.Set: ...

        def equals(self, __a0: object) -> bool: ...

        def forEach(self, __a0: java.util.function.BiConsumer) -> None: ...

        def getClass(self) -> java.lang.Class: ...

        def getOrDefault(self, __a0: object, __a1: object) -> object: ...

        def hashCode(self) -> int: ...

        def isEmpty(self) -> bool: ...

        def keySet(self) -> java.util.Set: ...

        def merge(self, __a0: object, __a1: object, __a2: java.util.function.BiFunction) -> object: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        @overload
        @staticmethod
        def of() -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object, __a18: object, __a19: object) -> java.util.Map: ...

        @staticmethod
        def ofEntries(__a0: List[java.util.Map.Entry]) -> java.util.Map: ...

        def put(self, __a0: object, __a1: object) -> object: ...

        def putAll(self, __a0: java.util.Map) -> None: ...

        def putIfAbsent(self, __a0: object, __a1: object) -> object: ...

        @overload
        def remove(self, __a0: object) -> object: ...

        @overload
        def remove(self, __a0: object, __a1: object) -> bool: ...

        @overload
        def replace(self, __a0: object, __a1: object) -> object: ...

        @overload
        def replace(self, __a0: object, __a1: object, __a2: object) -> bool: ...

        def replaceAll(self, __a0: java.util.function.BiFunction) -> None: ...

        def size(self) -> int: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...






    class AddressCache(ghidra.util.datastruct.FixedSizeHashMap):




        def __init__(self): ...

        def __iter__(self): ...

        def clear(self) -> None: ...

        def clone(self) -> object: ...

        def compute(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

        def computeIfAbsent(self, __a0: object, __a1: java.util.function.Function) -> object: ...

        def computeIfPresent(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

        def containsKey(self, __a0: object) -> bool: ...

        def containsValue(self, __a0: object) -> bool: ...

        @staticmethod
        def copyOf(__a0: java.util.Map) -> java.util.Map: ...

        @staticmethod
        def entry(__a0: object, __a1: object) -> java.util.Map.Entry: ...

        def entrySet(self) -> java.util.Set: ...

        def equals(self, __a0: object) -> bool: ...

        def forEach(self, __a0: java.util.function.BiConsumer) -> None: ...

        def getClass(self) -> java.lang.Class: ...

        def getOrDefault(self, __a0: object, __a1: object) -> object: ...

        def hashCode(self) -> int: ...

        def isEmpty(self) -> bool: ...

        def keySet(self) -> java.util.Set: ...

        def merge(self, __a0: object, __a1: object, __a2: java.util.function.BiFunction) -> object: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        @overload
        @staticmethod
        def of() -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object) -> java.util.Map: ...

        @overload
        @staticmethod
        def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object, __a18: object, __a19: object) -> java.util.Map: ...

        @staticmethod
        def ofEntries(__a0: List[java.util.Map.Entry]) -> java.util.Map: ...

        def put(self, __a0: object, __a1: object) -> object: ...

        def putAll(self, __a0: java.util.Map) -> None: ...

        def putIfAbsent(self, __a0: object, __a1: object) -> object: ...

        @overload
        def remove(self, __a0: object) -> object: ...

        @overload
        def remove(self, __a0: object, __a1: object) -> bool: ...

        @overload
        def replace(self, __a0: object, __a1: object) -> object: ...

        @overload
        def replace(self, __a0: object, __a1: object, __a2: object) -> bool: ...

        def replaceAll(self, __a0: java.util.function.BiFunction) -> None: ...

        def size(self) -> int: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...



    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



    def equals(self, __a0: object) -> bool: ...

    def getChecksum(self) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getClassDefs(self) -> List[object]: ...

    def getClassDefsIdsOffset(self) -> int: ...

    def getClassDefsIdsSize(self) -> int: ...

    def getDataOffset(self) -> int: ...

    def getDataSize(self) -> int: ...

    def getDataType(self, __a0: ghidra.program.model.listing.Program, __a1: int) -> ghidra.program.model.data.DataType: ...

    def getEndianTag(self) -> int: ...

    def getFieldIdsOffset(self) -> int: ...

    def getFieldIdsSize(self) -> int: ...

    def getFields(self) -> List[object]: ...

    def getFileSize(self) -> int: ...

    def getHeaderSize(self) -> int: ...

    def getLinkOffset(self) -> int: ...

    def getLinkSize(self) -> int: ...

    def getMagic(self) -> List[int]: ...

    def getMapList(self) -> ghidra.file.formats.android.dex.format.MapList: ...

    def getMapOffset(self) -> int: ...

    def getMethodAddress(self, __a0: ghidra.program.model.listing.Program, __a1: int) -> ghidra.program.model.address.Address: ...

    def getMethodIdsOffset(self) -> int: ...

    def getMethodIdsSize(self) -> int: ...

    def getMethods(self) -> List[object]: ...

    def getProtoIdsOffset(self) -> int: ...

    def getProtoIdsSize(self) -> int: ...

    def getPrototypes(self) -> List[object]: ...

    def getSignature(self) -> List[int]: ...

    def getStringIdsOffset(self) -> int: ...

    def getStringIdsSize(self) -> int: ...

    def getStrings(self) -> List[object]: ...

    def getTypeIdsOffset(self) -> int: ...

    def getTypeIdsSize(self) -> int: ...

    def getTypes(self) -> List[object]: ...

    def getVersion(self) -> List[int]: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def checksum(self) -> int: ...

    @property
    def classDefs(self) -> List[object]: ...

    @property
    def classDefsIdsOffset(self) -> int: ...

    @property
    def classDefsIdsSize(self) -> int: ...

    @property
    def dataOffset(self) -> int: ...

    @property
    def dataSize(self) -> int: ...

    @property
    def endianTag(self) -> int: ...

    @property
    def fieldIdsOffset(self) -> int: ...

    @property
    def fieldIdsSize(self) -> int: ...

    @property
    def fields(self) -> List[object]: ...

    @property
    def fileSize(self) -> int: ...

    @property
    def headerSize(self) -> int: ...

    @property
    def linkOffset(self) -> int: ...

    @property
    def linkSize(self) -> int: ...

    @property
    def magic(self) -> List[int]: ...

    @property
    def mapList(self) -> ghidra.file.formats.android.dex.format.MapList: ...

    @property
    def mapOffset(self) -> int: ...

    @property
    def methodIdsOffset(self) -> int: ...

    @property
    def methodIdsSize(self) -> int: ...

    @property
    def methods(self) -> List[object]: ...

    @property
    def protoIdsOffset(self) -> int: ...

    @property
    def protoIdsSize(self) -> int: ...

    @property
    def prototypes(self) -> List[object]: ...

    @property
    def signature(self) -> List[int]: ...

    @property
    def stringIdsOffset(self) -> int: ...

    @property
    def stringIdsSize(self) -> int: ...

    @property
    def strings(self) -> List[object]: ...

    @property
    def typeIdsOffset(self) -> int: ...

    @property
    def typeIdsSize(self) -> int: ...

    @property
    def types(self) -> List[object]: ...

    @property
    def version(self) -> List[int]: ...