from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.android.dex.format
import ghidra.program.model.data
import java.lang


class EncodedValue(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



    def equals(self, __a0: object) -> bool: ...

    def getAnnotation(self) -> ghidra.file.formats.android.dex.format.EncodedAnnotation: ...

    def getArray(self) -> ghidra.file.formats.android.dex.format.EncodedArray: ...

    def getClass(self) -> java.lang.Class: ...

    def getValueArgs(self) -> int: ...

    def getValueByte(self) -> int: ...

    def getValueBytes(self) -> List[int]: ...

    def getValueType(self) -> int: ...

    def hashCode(self) -> int: ...

    def isValueBoolean(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def annotation(self) -> ghidra.file.formats.android.dex.format.EncodedAnnotation: ...

    @property
    def array(self) -> ghidra.file.formats.android.dex.format.EncodedArray: ...

    @property
    def valueArgs(self) -> int: ...

    @property
    def valueBoolean(self) -> bool: ...

    @property
    def valueByte(self) -> int: ...

    @property
    def valueBytes(self) -> List[int]: ...

    @property
    def valueType(self) -> int: ...