from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.ext4
import ghidra.program.model.data
import java.lang


class Ext4DxRoot(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    @overload
    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...

    @overload
    def __init__(self, __a0: ghidra.app.util.bin.ByteProvider): ...



    def equals(self, __a0: object) -> bool: ...

    def getBlock(self) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getCount(self) -> int: ...

    def getDot_file_type(self) -> int: ...

    def getDot_inode(self) -> int: ...

    def getDot_name(self) -> List[int]: ...

    def getDot_name_len(self) -> int: ...

    def getDot_rec_len(self) -> int: ...

    def getDotdot_file_type(self) -> int: ...

    def getDotdot_inode(self) -> int: ...

    def getDotdot_name(self) -> List[int]: ...

    def getDotdot_name_len(self) -> int: ...

    def getDotdot_rec_len(self) -> int: ...

    def getDx_root_info_hash_version(self) -> int: ...

    def getDx_root_info_indirect_levels(self) -> int: ...

    def getDx_root_info_info_length(self) -> int: ...

    def getDx_root_info_reserved_zero(self) -> int: ...

    def getDx_root_info_unused_flags(self) -> int: ...

    def getEntries(self) -> List[ghidra.file.formats.ext4.Ext4DxEntry]: ...

    def getLimit(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def block(self) -> int: ...

    @property
    def count(self) -> int: ...

    @property
    def dot_file_type(self) -> int: ...

    @property
    def dot_inode(self) -> int: ...

    @property
    def dot_name(self) -> List[int]: ...

    @property
    def dot_name_len(self) -> int: ...

    @property
    def dot_rec_len(self) -> int: ...

    @property
    def dotdot_file_type(self) -> int: ...

    @property
    def dotdot_inode(self) -> int: ...

    @property
    def dotdot_name(self) -> List[int]: ...

    @property
    def dotdot_name_len(self) -> int: ...

    @property
    def dotdot_rec_len(self) -> int: ...

    @property
    def dx_root_info_hash_version(self) -> int: ...

    @property
    def dx_root_info_indirect_levels(self) -> int: ...

    @property
    def dx_root_info_info_length(self) -> int: ...

    @property
    def dx_root_info_reserved_zero(self) -> int: ...

    @property
    def dx_root_info_unused_flags(self) -> int: ...

    @property
    def entries(self) -> List[ghidra.file.formats.ext4.Ext4DxEntry]: ...

    @property
    def limit(self) -> int: ...