from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.ext4
import ghidra.program.model.data
import java.lang


class Ext4Inode(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    @overload
    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...

    @overload
    def __init__(self, __a0: ghidra.app.util.bin.ByteProvider): ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getI_atime(self) -> int: ...

    def getI_atime_extra(self) -> int: ...

    def getI_block(self) -> ghidra.file.formats.ext4.Ext4IBlock: ...

    def getI_blocks_lo(self) -> int: ...

    def getI_checksum_hi(self) -> int: ...

    def getI_crtime(self) -> int: ...

    def getI_crtime_extra(self) -> int: ...

    def getI_ctime(self) -> int: ...

    def getI_ctime_extra(self) -> int: ...

    def getI_dtime(self) -> int: ...

    def getI_extra_isize(self) -> int: ...

    def getI_file_acl_lo(self) -> int: ...

    def getI_flags(self) -> int: ...

    def getI_generation(self) -> int: ...

    def getI_gid(self) -> int: ...

    def getI_links_count(self) -> int: ...

    def getI_mode(self) -> int: ...

    def getI_mtime(self) -> int: ...

    def getI_mtime_extra(self) -> int: ...

    def getI_obso_faddr(self) -> int: ...

    def getI_osd1(self) -> int: ...

    def getI_osd2(self) -> List[int]: ...

    def getI_projid(self) -> int: ...

    def getI_size_high(self) -> int: ...

    def getI_size_lo(self) -> int: ...

    def getI_uid(self) -> int: ...

    def getI_version_hi(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def i_atime(self) -> int: ...

    @property
    def i_atime_extra(self) -> int: ...

    @property
    def i_block(self) -> ghidra.file.formats.ext4.Ext4IBlock: ...

    @property
    def i_blocks_lo(self) -> int: ...

    @property
    def i_checksum_hi(self) -> int: ...

    @property
    def i_crtime(self) -> int: ...

    @property
    def i_crtime_extra(self) -> int: ...

    @property
    def i_ctime(self) -> int: ...

    @property
    def i_ctime_extra(self) -> int: ...

    @property
    def i_dtime(self) -> int: ...

    @property
    def i_extra_isize(self) -> int: ...

    @property
    def i_file_acl_lo(self) -> int: ...

    @property
    def i_flags(self) -> int: ...

    @property
    def i_generation(self) -> int: ...

    @property
    def i_gid(self) -> int: ...

    @property
    def i_links_count(self) -> int: ...

    @property
    def i_mode(self) -> int: ...

    @property
    def i_mtime(self) -> int: ...

    @property
    def i_mtime_extra(self) -> int: ...

    @property
    def i_obso_faddr(self) -> int: ...

    @property
    def i_osd1(self) -> int: ...

    @property
    def i_osd2(self) -> List[int]: ...

    @property
    def i_projid(self) -> int: ...

    @property
    def i_size_high(self) -> int: ...

    @property
    def i_size_lo(self) -> int: ...

    @property
    def i_uid(self) -> int: ...

    @property
    def i_version_hi(self) -> int: ...