from typing import List
import ghidra.app.util.bin
import ghidra.file.formats.ext4
import ghidra.program.model.data
import java.lang


class Ext4JournalSuperBlockS(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    @overload
    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...

    @overload
    def __init__(self, __a0: ghidra.app.util.bin.ByteProvider): ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getS_blocksize(self) -> int: ...

    def getS_checksum(self) -> int: ...

    def getS_checksum_type(self) -> int: ...

    def getS_dynsuper(self) -> int: ...

    def getS_errno(self) -> int: ...

    def getS_feature_compat(self) -> int: ...

    def getS_feature_incompat(self) -> int: ...

    def getS_feature_ro_compat(self) -> int: ...

    def getS_first(self) -> int: ...

    def getS_header(self) -> ghidra.file.formats.ext4.Ext4JournalHeaderS: ...

    def getS_max_trans_data(self) -> int: ...

    def getS_max_transaction(self) -> int: ...

    def getS_maxlen(self) -> int: ...

    def getS_nr_users(self) -> int: ...

    def getS_padding(self) -> List[int]: ...

    def getS_padding2(self) -> List[int]: ...

    def getS_sequence(self) -> int: ...

    def getS_start(self) -> int: ...

    def getS_users(self) -> List[int]: ...

    def getS_uuid(self) -> List[int]: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def s_blocksize(self) -> int: ...

    @property
    def s_checksum(self) -> int: ...

    @property
    def s_checksum_type(self) -> int: ...

    @property
    def s_dynsuper(self) -> int: ...

    @property
    def s_errno(self) -> int: ...

    @property
    def s_feature_compat(self) -> int: ...

    @property
    def s_feature_incompat(self) -> int: ...

    @property
    def s_feature_ro_compat(self) -> int: ...

    @property
    def s_first(self) -> int: ...

    @property
    def s_header(self) -> ghidra.file.formats.ext4.Ext4JournalHeaderS: ...

    @property
    def s_max_trans_data(self) -> int: ...

    @property
    def s_max_transaction(self) -> int: ...

    @property
    def s_maxlen(self) -> int: ...

    @property
    def s_nr_users(self) -> int: ...

    @property
    def s_padding(self) -> List[int]: ...

    @property
    def s_padding2(self) -> List[int]: ...

    @property
    def s_sequence(self) -> int: ...

    @property
    def s_start(self) -> int: ...

    @property
    def s_users(self) -> List[int]: ...

    @property
    def s_uuid(self) -> List[int]: ...