from typing import List
import ghidra.app.util.bin
import ghidra.program.model.data
import java.lang


class Ext4SuperBlock(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    @overload
    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...

    @overload
    def __init__(self, __a0: ghidra.app.util.bin.ByteProvider): ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getS_Last_error_ino(self) -> int: ...

    def getS_algorithm_usage_bitmap(self) -> int: ...

    def getS_backup_blocks(self) -> List[int]: ...

    def getS_block_group_nr(self) -> int: ...

    def getS_blocks_count_hi(self) -> int: ...

    def getS_blocks_count_lo(self) -> int: ...

    def getS_blocks_per_group(self) -> int: ...

    def getS_checkinterval(self) -> int: ...

    def getS_checksum(self) -> int: ...

    def getS_checksum_seed(self) -> int: ...

    def getS_checksum_type(self) -> int: ...

    def getS_clusters_per_group(self) -> int: ...

    def getS_creator_os(self) -> int: ...

    def getS_def_hash_version(self) -> int: ...

    def getS_def_resgid(self) -> int: ...

    def getS_def_resuid(self) -> int: ...

    def getS_default_mount_opts(self) -> int: ...

    def getS_desc_size(self) -> int: ...

    def getS_encrypt_algos(self) -> List[int]: ...

    def getS_encrypt_pw_salt(self) -> List[int]: ...

    def getS_error_count(self) -> int: ...

    def getS_errors(self) -> int: ...

    def getS_feature_compat(self) -> int: ...

    def getS_feature_incompat(self) -> int: ...

    def getS_feature_ro_compat(self) -> int: ...

    def getS_first_data_block(self) -> int: ...

    def getS_first_error_block(self) -> long: ...

    def getS_first_error_func(self) -> List[int]: ...

    def getS_first_error_ino(self) -> int: ...

    def getS_first_error_line(self) -> int: ...

    def getS_first_error_time(self) -> int: ...

    def getS_first_ino(self) -> int: ...

    def getS_first_meta_bg(self) -> int: ...

    def getS_flags(self) -> int: ...

    def getS_free_blocks_count_hi(self) -> int: ...

    def getS_free_blocks_count_lo(self) -> int: ...

    def getS_free_inodes_count(self) -> int: ...

    def getS_grp_quota_inum(self) -> int: ...

    def getS_hash_seed(self) -> List[int]: ...

    def getS_inode_size(self) -> int: ...

    def getS_inodes_count(self) -> int: ...

    def getS_inodes_per_group(self) -> int: ...

    def getS_jnl_backup_type(self) -> int: ...

    def getS_jnl_blocks(self) -> List[int]: ...

    def getS_journal_dev(self) -> int: ...

    def getS_journal_inum(self) -> int: ...

    def getS_journal_uuid(self) -> List[int]: ...

    def getS_kbytes_written(self) -> long: ...

    def getS_last_error_block(self) -> long: ...

    def getS_last_error_func(self) -> List[int]: ...

    def getS_last_error_line(self) -> int: ...

    def getS_last_error_time(self) -> int: ...

    def getS_last_mounted(self) -> List[int]: ...

    def getS_last_orphan(self) -> int: ...

    def getS_lastcheck(self) -> int: ...

    def getS_log_block_size(self) -> int: ...

    def getS_log_cluster_size(self) -> int: ...

    def getS_log_groups_per_flex(self) -> int: ...

    def getS_lpf_ino(self) -> int: ...

    def getS_magic(self) -> int: ...

    def getS_max_mnt_count(self) -> int: ...

    def getS_min_extra_isize(self) -> int: ...

    def getS_minor_rev_level(self) -> int: ...

    def getS_mkfs_time(self) -> int: ...

    def getS_mmp_block(self) -> long: ...

    def getS_mmp_interval(self) -> int: ...

    def getS_mnt_count(self) -> int: ...

    def getS_mount_opts(self) -> List[int]: ...

    def getS_mtime(self) -> int: ...

    def getS_overhead_blocks(self) -> int: ...

    def getS_prealloc_blocks(self) -> int: ...

    def getS_prealloc_dir_blocks(self) -> int: ...

    def getS_prj_quota_inum(self) -> int: ...

    def getS_r_blocks_count_hi(self) -> int: ...

    def getS_r_blocks_count_lo(self) -> int: ...

    def getS_raid_stride(self) -> int: ...

    def getS_raid_stripe_width(self) -> int: ...

    def getS_reserved(self) -> List[int]: ...

    def getS_reserved_gdt_blocks(self) -> int: ...

    def getS_reserved_pad(self) -> int: ...

    def getS_rev_level(self) -> int: ...

    def getS_snapshot_id(self) -> int: ...

    def getS_snapshot_inum(self) -> int: ...

    def getS_snapshot_list(self) -> int: ...

    def getS_snapshot_r_blocks_count(self) -> long: ...

    def getS_state(self) -> int: ...

    def getS_usr_quora_inum(self) -> int: ...

    def getS_uuid(self) -> List[int]: ...

    def getS_volume_name(self) -> List[int]: ...

    def getS_want_extra_isize(self) -> int: ...

    def getS_wtime(self) -> int: ...

    def getVolumeName(self) -> unicode: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def s_Last_error_ino(self) -> int: ...

    @property
    def s_algorithm_usage_bitmap(self) -> int: ...

    @property
    def s_backup_blocks(self) -> List[int]: ...

    @property
    def s_block_group_nr(self) -> int: ...

    @property
    def s_blocks_count_hi(self) -> int: ...

    @property
    def s_blocks_count_lo(self) -> int: ...

    @property
    def s_blocks_per_group(self) -> int: ...

    @property
    def s_checkinterval(self) -> int: ...

    @property
    def s_checksum(self) -> int: ...

    @property
    def s_checksum_seed(self) -> int: ...

    @property
    def s_checksum_type(self) -> int: ...

    @property
    def s_clusters_per_group(self) -> int: ...

    @property
    def s_creator_os(self) -> int: ...

    @property
    def s_def_hash_version(self) -> int: ...

    @property
    def s_def_resgid(self) -> int: ...

    @property
    def s_def_resuid(self) -> int: ...

    @property
    def s_default_mount_opts(self) -> int: ...

    @property
    def s_desc_size(self) -> int: ...

    @property
    def s_encrypt_algos(self) -> List[int]: ...

    @property
    def s_encrypt_pw_salt(self) -> List[int]: ...

    @property
    def s_error_count(self) -> int: ...

    @property
    def s_errors(self) -> int: ...

    @property
    def s_feature_compat(self) -> int: ...

    @property
    def s_feature_incompat(self) -> int: ...

    @property
    def s_feature_ro_compat(self) -> int: ...

    @property
    def s_first_data_block(self) -> int: ...

    @property
    def s_first_error_block(self) -> long: ...

    @property
    def s_first_error_func(self) -> List[int]: ...

    @property
    def s_first_error_ino(self) -> int: ...

    @property
    def s_first_error_line(self) -> int: ...

    @property
    def s_first_error_time(self) -> int: ...

    @property
    def s_first_ino(self) -> int: ...

    @property
    def s_first_meta_bg(self) -> int: ...

    @property
    def s_flags(self) -> int: ...

    @property
    def s_free_blocks_count_hi(self) -> int: ...

    @property
    def s_free_blocks_count_lo(self) -> int: ...

    @property
    def s_free_inodes_count(self) -> int: ...

    @property
    def s_grp_quota_inum(self) -> int: ...

    @property
    def s_hash_seed(self) -> List[int]: ...

    @property
    def s_inode_size(self) -> int: ...

    @property
    def s_inodes_count(self) -> int: ...

    @property
    def s_inodes_per_group(self) -> int: ...

    @property
    def s_jnl_backup_type(self) -> int: ...

    @property
    def s_jnl_blocks(self) -> List[int]: ...

    @property
    def s_journal_dev(self) -> int: ...

    @property
    def s_journal_inum(self) -> int: ...

    @property
    def s_journal_uuid(self) -> List[int]: ...

    @property
    def s_kbytes_written(self) -> long: ...

    @property
    def s_last_error_block(self) -> long: ...

    @property
    def s_last_error_func(self) -> List[int]: ...

    @property
    def s_last_error_line(self) -> int: ...

    @property
    def s_last_error_time(self) -> int: ...

    @property
    def s_last_mounted(self) -> List[int]: ...

    @property
    def s_last_orphan(self) -> int: ...

    @property
    def s_lastcheck(self) -> int: ...

    @property
    def s_log_block_size(self) -> int: ...

    @property
    def s_log_cluster_size(self) -> int: ...

    @property
    def s_log_groups_per_flex(self) -> int: ...

    @property
    def s_lpf_ino(self) -> int: ...

    @property
    def s_magic(self) -> int: ...

    @property
    def s_max_mnt_count(self) -> int: ...

    @property
    def s_min_extra_isize(self) -> int: ...

    @property
    def s_minor_rev_level(self) -> int: ...

    @property
    def s_mkfs_time(self) -> int: ...

    @property
    def s_mmp_block(self) -> long: ...

    @property
    def s_mmp_interval(self) -> int: ...

    @property
    def s_mnt_count(self) -> int: ...

    @property
    def s_mount_opts(self) -> List[int]: ...

    @property
    def s_mtime(self) -> int: ...

    @property
    def s_overhead_blocks(self) -> int: ...

    @property
    def s_prealloc_blocks(self) -> int: ...

    @property
    def s_prealloc_dir_blocks(self) -> int: ...

    @property
    def s_prj_quota_inum(self) -> int: ...

    @property
    def s_r_blocks_count_hi(self) -> int: ...

    @property
    def s_r_blocks_count_lo(self) -> int: ...

    @property
    def s_raid_stride(self) -> int: ...

    @property
    def s_raid_stripe_width(self) -> int: ...

    @property
    def s_reserved(self) -> List[int]: ...

    @property
    def s_reserved_gdt_blocks(self) -> int: ...

    @property
    def s_reserved_pad(self) -> int: ...

    @property
    def s_rev_level(self) -> int: ...

    @property
    def s_snapshot_id(self) -> int: ...

    @property
    def s_snapshot_inum(self) -> int: ...

    @property
    def s_snapshot_list(self) -> int: ...

    @property
    def s_snapshot_r_blocks_count(self) -> long: ...

    @property
    def s_state(self) -> int: ...

    @property
    def s_usr_quora_inum(self) -> int: ...

    @property
    def s_uuid(self) -> List[int]: ...

    @property
    def s_volume_name(self) -> List[int]: ...

    @property
    def s_want_extra_isize(self) -> int: ...

    @property
    def s_wtime(self) -> int: ...

    @property
    def volumeName(self) -> unicode: ...