from typing import List
import db.buffers
import ghidra.framework.remote
import ghidra.framework.store
import java.lang
import java.rmi


class RemoteRepositoryHandle(ghidra.framework.remote.RepositoryHandle, java.rmi.Remote, object):
    """
    RepositoryHandle provides access to a remote repository via RMI.
 
     Methods from RepositoryHandle must be re-declared here
     so they may be properly marshalled for remote invocation via RMI.  
     This became neccessary with an OpenJDK 11.0.6 change made to 
     RemoteObjectInvocationHandler.
    """

    CLIENT_CHECK_PERIOD: int = 30000







    def anonymousAccessAllowed(self) -> bool: ...

    def checkout(self, parentPath: unicode, itemName: unicode, checkoutType: ghidra.framework.store.CheckoutType, projectPath: unicode) -> ghidra.framework.store.ItemCheckoutStatus: ...

    def close(self) -> None: ...

    def createDatabase(self, parentPath: unicode, itemName: unicode, fileID: unicode, bufferSize: int, contentType: unicode, projectPath: unicode) -> db.buffers.ManagedBufferFileHandle: ...

    def deleteItem(self, parentPath: unicode, itemName: unicode, version: int) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fileExists(self, parentPath: unicode, itemName: unicode) -> bool: ...

    def folderExists(self, folderPath: unicode) -> bool: ...

    def getCheckout(self, parentPath: unicode, itemName: unicode, checkoutId: long) -> ghidra.framework.store.ItemCheckoutStatus: ...

    def getCheckouts(self, parentPath: unicode, itemName: unicode) -> List[ghidra.framework.store.ItemCheckoutStatus]: ...

    def getClass(self) -> java.lang.Class: ...

    def getEvents(self) -> List[ghidra.framework.remote.RepositoryChangeEvent]: ...

    @overload
    def getItem(self, fileID: unicode) -> ghidra.framework.remote.RepositoryItem: ...

    @overload
    def getItem(self, parentPath: unicode, name: unicode) -> ghidra.framework.remote.RepositoryItem: ...

    def getItemCount(self) -> int: ...

    def getItemList(self, folderPath: unicode) -> List[ghidra.framework.remote.RepositoryItem]: ...

    def getLength(self, parentPath: unicode, itemName: unicode) -> long: ...

    def getName(self) -> unicode: ...

    def getServerUserList(self) -> List[unicode]: ...

    def getSubfolderList(self, folderPath: unicode) -> List[unicode]: ...

    def getUser(self) -> ghidra.framework.remote.User: ...

    def getUserList(self) -> List[ghidra.framework.remote.User]: ...

    def getVersions(self, parentPath: unicode, itemName: unicode) -> List[ghidra.framework.store.Version]: ...

    def hasCheckouts(self, parentPath: unicode, itemName: unicode) -> bool: ...

    def hashCode(self) -> int: ...

    def isCheckinActive(self, parentPath: unicode, itemName: unicode) -> bool: ...

    def moveFolder(self, oldParentPath: unicode, newParentPath: unicode, oldFolderName: unicode, newFolderName: unicode) -> None: ...

    def moveItem(self, oldParentPath: unicode, newParentPath: unicode, oldItemName: unicode, newItemName: unicode) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def openDatabase(self, parentPath: unicode, itemName: unicode, checkoutId: long) -> db.buffers.ManagedBufferFileHandle: ...

    @overload
    def openDatabase(self, parentPath: unicode, itemName: unicode, version: int, minChangeDataVer: int) -> db.buffers.ManagedBufferFileHandle: ...

    def setUserList(self, users: List[ghidra.framework.remote.User], anonymousAccessAllowed: bool) -> None: ...

    def terminateCheckout(self, parentPath: unicode, itemName: unicode, checkoutId: long, notify: bool) -> None: ...

    def toString(self) -> unicode: ...

    def updateCheckoutVersion(self, parentPath: unicode, itemName: unicode, checkoutId: long, checkoutVersion: int) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def events(self) -> List[ghidra.framework.remote.RepositoryChangeEvent]: ...

    @property
    def itemCount(self) -> int: ...

    @property
    def name(self) -> unicode: ...

    @property
    def serverUserList(self) -> List[unicode]: ...

    @property
    def user(self) -> ghidra.framework.remote.User: ...

    @property
    def userList(self) -> List[ghidra.framework.remote.User]: ...