from typing import List
import db.buffers
import ghidra.framework.store
import ghidra.framework.store.remote
import ghidra.util.task
import java.io
import java.lang


class RemoteDatabaseItem(ghidra.framework.store.remote.RemoteFolderItem, ghidra.framework.store.DatabaseItem):
    """
    RemoteDatabaseItem provides a FolderItem implementation
     for a remote database.  This item wraps an underlying versioned database
     which corresponds to a repository item.
    """









    def canRecover(self) -> bool: ...

    def checkout(self, checkoutType: ghidra.framework.store.CheckoutType, user: unicode, projectPath: unicode) -> ghidra.framework.store.ItemCheckoutStatus: ...

    def clearCheckout(self) -> None: ...

    def delete(self, ver: int, user: unicode) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getCheckout(self, checkoutId: long) -> ghidra.framework.store.ItemCheckoutStatus: ...

    def getCheckoutId(self) -> long: ...

    def getCheckoutVersion(self) -> int: ...

    def getCheckouts(self) -> List[ghidra.framework.store.ItemCheckoutStatus]: ...

    def getClass(self) -> java.lang.Class: ...

    def getContentType(self) -> unicode: ...

    def getContentTypeVersion(self) -> int:
        """
        Returns the version of content type.  Note this is the version of the structure/storage
         for the content type, Not the users version of their data.
        """
        ...

    def getCurrentVersion(self) -> int: ...

    def getFileID(self) -> unicode:
        """
        @throws IOException
        @see ghidra.framework.store.FolderItem#getFileID()
        """
        ...

    def getLocalCheckoutVersion(self) -> int: ...

    def getName(self) -> unicode: ...

    def getParentPath(self) -> unicode: ...

    def getPathName(self) -> unicode: ...

    def getVersions(self) -> List[ghidra.framework.store.Version]: ...

    def hasCheckouts(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isCheckedOut(self) -> bool: ...

    def isCheckedOutExclusive(self) -> bool: ...

    def isCheckinActive(self) -> bool: ...

    def isReadOnly(self) -> bool: ...

    def isVersioned(self) -> bool: ...

    def lastModified(self) -> long: ...

    def length(self) -> long: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def open(self) -> db.buffers.ManagedBufferFileAdapter: ...

    @overload
    def open(self, version: int) -> db.buffers.ManagedBufferFileAdapter: ...

    @overload
    def open(self, version: int, minChangeDataVer: int) -> db.buffers.ManagedBufferFileAdapter: ...

    def openForUpdate(self, checkoutId: long) -> db.buffers.ManagedBufferFileAdapter: ...

    def output(self, outputFile: java.io.File, version: int, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def refresh(self) -> ghidra.framework.store.remote.RemoteFolderItem: ...

    def resetFileID(self) -> unicode:
        """
        @see ghidra.framework.store.FolderItem#resetFileID()
        """
        ...

    def setCheckout(self, checkoutId: long, exclusive: bool, checkoutVersion: int, localVersion: int) -> None: ...

    def setContentTypeVersion(self, version: int) -> None:
        """
        @see ghidra.framework.store.FolderItem#setContentTypeVersion(int)
        """
        ...

    def setReadOnly(self, state: bool) -> None: ...

    def terminateCheckout(self, checkoutId: long, notify: bool) -> None: ...

    def toString(self) -> unicode: ...

    def updateCheckoutVersion(self, checkoutId: long, checkoutVersion: int, user: unicode) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def checkinActive(self) -> bool: ...