from typing import List
import db.buffers
import ghidra.framework.client
import ghidra.framework.store
import ghidra.util.task
import java.io
import java.lang


class RemoteFileSystem(object, ghidra.framework.store.FileSystem, ghidra.framework.client.RemoteAdapterListener):
    """
    RemoteFileSystem provides access to versioned FolderItem's which 
     exist within a Repository-based directory structure.  FolderItem
     caching is provided by the remote implementation which is intended
     to be shared across multiple clients.
 
     FolderItem's must be checked-out to create new versions.
 
     FileSystemListener's will be notified of all changes made 
     within the Repository.
    """

    SEPARATOR: unicode = u'/'
    SEPARATOR_CHAR: int = '/'



    def __init__(self, repository: ghidra.framework.client.RepositoryAdapter):
        """
        Construct a new remote file system which corresponds to a remote repository.
        @param repository remote Repository
        """
        ...



    def addFileSystemListener(self, listener: ghidra.framework.store.FileSystemListener) -> None: ...

    def connectionStateChanged(self, adapter: object) -> None: ...

    def createDataFile(self, parentPath: unicode, name: unicode, istream: java.io.InputStream, comment: unicode, contentType: unicode, monitor: ghidra.util.task.TaskMonitor) -> ghidra.framework.store.DataFileItem: ...

    @overload
    def createDatabase(self, parentPath: unicode, name: unicode, fileID: unicode, contentType: unicode, bufferSize: int, user: unicode, projectPath: unicode) -> db.buffers.ManagedBufferFile: ...

    @overload
    def createDatabase(self, parentPath: unicode, name: unicode, fileID: unicode, bufferFile: db.buffers.BufferFile, comment: unicode, contentType: unicode, resetDatabaseId: bool, monitor: ghidra.util.task.TaskMonitor, user: unicode) -> ghidra.framework.store.DatabaseItem: ...

    def createFile(self, parentPath: unicode, name: unicode, packedFile: java.io.File, monitor: ghidra.util.task.TaskMonitor, user: unicode) -> ghidra.framework.store.FolderItem: ...

    def createFolder(self, parentPath: unicode, folderName: unicode) -> None: ...

    def deleteFolder(self, folderPath: unicode) -> None: ...

    def dispose(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def fileExists(self, folderPath: unicode, itemName: unicode) -> bool: ...

    def folderExists(self, folderPath: unicode) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getFolderNames(self, parentPath: unicode) -> List[unicode]: ...

    @overload
    def getItem(self, fileID: unicode) -> ghidra.framework.store.FolderItem: ...

    @overload
    def getItem(self, folderPath: unicode, name: unicode) -> ghidra.framework.store.FolderItem: ...

    def getItemCount(self) -> int: ...

    def getItemNames(self, folderPath: unicode) -> List[unicode]: ...

    def getUserName(self) -> unicode: ...

    def hashCode(self) -> int: ...

    def isOnline(self) -> bool: ...

    def isReadOnly(self) -> bool: ...

    def isShared(self) -> bool: ...

    def isVersioned(self) -> bool: ...

    def moveFolder(self, parentPath: unicode, folderName: unicode, newParentPath: unicode) -> None: ...

    def moveItem(self, parentPath: unicode, name: unicode, newParentPath: unicode, newName: unicode) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeFileSystemListener(self, listener: ghidra.framework.store.FileSystemListener) -> None: ...

    def renameFolder(self, parentPath: unicode, folderName: unicode, newFolderName: unicode) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def itemCount(self) -> int: ...

    @property
    def online(self) -> bool: ...

    @property
    def readOnly(self) -> bool: ...

    @property
    def shared(self) -> bool: ...

    @property
    def userName(self) -> unicode: ...

    @property
    def versioned(self) -> bool: ...