import ghidra.framework.task.gui
import ghidra.util.task
import java.lang


class GTaskMonitor(object, ghidra.util.task.TaskMonitor, ghidra.util.task.CancelledListener):
    """
    Implementation of a TaskMontor that can be "attached" to a GProgressBar.

     The GTaskMonitor is a non-gui object for tracking the progress of a GTaskGroup or GTask.  It
     is created by the GTaskManager as tasks are scheduled.  GUIs that wish to display the progress
     of the groups and tasks can set a GProgressBar into a GTaskMonitor and it will display the
     progress.
    """

    DUMMY: ghidra.util.task.TaskMonitor = ghidra.util.task.StubTaskMonitor@78784689
    NO_PROGRESS_VALUE: int = -1



    def __init__(self): ...



    def addCancelledListener(self, mcl: ghidra.util.task.CancelledListener) -> None: ...

    def cancel(self) -> None: ...

    def cancelled(self) -> None: ...

    def checkCanceled(self) -> None: ...

    def clearCanceled(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getMaximum(self) -> long: ...

    def getMessage(self) -> unicode: ...

    def getProgress(self) -> long: ...

    def hashCode(self) -> int: ...

    def incrementProgress(self, incrementAmount: long) -> None: ...

    def initialize(self, maxValue: long) -> None: ...

    def isCancelEnabled(self) -> bool: ...

    def isCancelled(self) -> bool: ...

    def isInderminate(self) -> bool: ...

    def isIndeterminate(self) -> bool: ...

    def isShowingProgressValue(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeCancelledListener(self, mcl: ghidra.util.task.CancelledListener) -> None: ...

    def setCancelEnabled(self, enable: bool) -> None: ...

    def setIndeterminate(self, indeterminate: bool) -> None: ...

    def setMaximum(self, max: long) -> None: ...

    def setMessage(self, message: unicode) -> None: ...

    def setProgress(self, value: long) -> None: ...

    def setProgressBar(self, gProgressBar: ghidra.framework.task.gui.GProgressBar) -> None:
        """
        Set the GProgressBar to use to display the progress.
        @param gProgressBar the GProgressBar to use.
        """
        ...

    def setShowProgressValue(self, showProgressValue: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def cancelEnabled(self) -> bool: ...

    @cancelEnabled.setter
    def cancelEnabled(self, value: bool) -> None: ...

    @property
    def inderminate(self) -> bool: ...

    @property
    def indeterminate(self) -> bool: ...

    @indeterminate.setter
    def indeterminate(self, value: bool) -> None: ...

    @property
    def maximum(self) -> long: ...

    @maximum.setter
    def maximum(self, value: long) -> None: ...

    @property
    def message(self) -> unicode: ...

    @message.setter
    def message(self, value: unicode) -> None: ...

    @property
    def progress(self) -> long: ...

    @progress.setter
    def progress(self, value: long) -> None: ...

    @property
    def progressBar(self) -> None: ...  # No getter available.

    @progressBar.setter
    def progressBar(self, value: ghidra.framework.task.gui.GProgressBar) -> None: ...

    @property
    def showProgressValue(self) -> None: ...  # No getter available.

    @showProgressValue.setter
    def showProgressValue(self, value: bool) -> None: ...

    @property
    def showingProgressValue(self) -> bool: ...