import ghidra.framework.task
import java.lang


class GTaskResult(object):
    """
    Class to represent the result state of a GTask, such as whether it was cancelled or an exception
     happened.
    """





    def __init__(self, group: ghidra.framework.task.GTaskGroup, task: ghidra.framework.task.GScheduledTask, e: java.lang.Exception, transactionID: int):
        """
        Constructs a GTaskResult for a completed GTask with an optional exception.
        @param group The GTaskGroup that the completed GTask belonged to.
        @param task the GScheduledTask which contains the actual GTask that has completed.
        @param e optional exception recorded if an exception occurred while processing the task.  If
         the task was cancelled, there should be a CancelledException passed in here.
        @param transactionID The transaction id for the transaction that was open when the task was
         executed.  Used by the results GUI to indicate when transactions are opened and closed between
         tasks.
        """
        ...



    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getDescription(self) -> unicode:
        """
        Returns a description of the task that was run.
        @return a description of the task that was run.
        """
        ...

    def getException(self) -> java.lang.Exception:
        """
        Returns the exception generated by the task, or null if no exception was generated.  If 
         the task was cancelled, this will return a CancelledException.
        @return the exception generated by this task or null.
        """
        ...

    def getGroupDescription(self) -> unicode:
        """
        Returns the description for the group for which this task belonged.
        @return the description for the group for which this task belonged.
        """
        ...

    def getPriority(self) -> int:
        """
        Returns the priority at which the task was run within its group.
        @return the priority at which the task was run within its group.
        """
        ...

    def hasSameTransaction(self, result: ghidra.framework.task.GTaskResult) -> bool:
        """
        Returns true if the task represented by this result was executed in the same transaction
         as the task represented by the given GTaskResult.
        @param result the result to check if it was executed in the same transaction as this task
         result.
        @return true if same transaction.
        """
        ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def wasCancelled(self) -> bool:
        """
        Returns true if the task for this result was cancelled.
        @return true if the task for this result was cancelled.
        """
        ...

    @property
    def description(self) -> unicode: ...

    @property
    def exception(self) -> java.lang.Exception: ...

    @property
    def groupDescription(self) -> unicode: ...

    @property
    def priority(self) -> int: ...