from typing import Iterator
from typing import List
import ghidra.generic.util.datastruct
import ghidra.generic.util.datastruct.ValueSortedMap
import java.lang
import java.util
import java.util.function


class ValueSortedMap(java.util.Map, object):
    """
    A map that is sorted by value.
 
 
     This is an extension of Map where entries are sorted by value, rather than by key. Such a
     map may be useful as a priority queue where the cost of an entry may change over time. As such,
     the collections returned by #entrySet(), #keySet(), and #values() all
     extend Deque. The order of the entries will be updated on any call to Map#put(Object, Object), 
     or a call to Collection#add(Object) on the entry set. Additionally, if the
     values are mutable objects, whose order may change, there is an #update(Object) method,
     which notifies the map that the given key may need to be repositioned. The associated collections
     also extend the List interface, providing fairly efficient implementations of
     List#get(int) and List#indexOf(Object). Sequential access is best performed via
     Collection#iterator(), since this will use a linked list.
    """







    def __iter__(self): ...

    def ceilingEntryByValue(self, __a0: object) -> java.util.Map.Entry: ...

    def clear(self) -> None: ...

    def compute(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

    def computeIfAbsent(self, __a0: object, __a1: java.util.function.Function) -> object: ...

    def computeIfPresent(self, __a0: object, __a1: java.util.function.BiFunction) -> object: ...

    def containsKey(self, __a0: object) -> bool: ...

    def containsValue(self, __a0: object) -> bool: ...

    @staticmethod
    def copyOf(__a0: java.util.Map) -> java.util.Map: ...

    @staticmethod
    def entry(__a0: object, __a1: object) -> java.util.Map.Entry: ...

    def entrySet(self) -> ghidra.generic.util.datastruct.ValueSortedMap.ValueSortedMapEntryList: ...

    def equals(self, __a0: object) -> bool: ...

    def floorEntryByValue(self, __a0: object) -> java.util.Map.Entry: ...

    def forEach(self, __a0: java.util.function.BiConsumer) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getOrDefault(self, __a0: object, __a1: object) -> object: ...

    def hashCode(self) -> int: ...

    def headMapByValue(self, __a0: object, __a1: bool) -> ghidra.generic.util.datastruct.ValueSortedMap: ...

    def higherEntryByValue(self, __a0: object) -> java.util.Map.Entry: ...

    def isEmpty(self) -> bool: ...

    def keySet(self) -> ghidra.generic.util.datastruct.ValueSortedMap.ValueSortedMapKeyList: ...

    def lowerEntryByValue(self, __a0: object) -> java.util.Map.Entry: ...

    def merge(self, __a0: object, __a1: object, __a2: java.util.function.BiFunction) -> object: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    @staticmethod
    def of() -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object) -> java.util.Map: ...

    @overload
    @staticmethod
    def of(__a0: object, __a1: object, __a2: object, __a3: object, __a4: object, __a5: object, __a6: object, __a7: object, __a8: object, __a9: object, __a10: object, __a11: object, __a12: object, __a13: object, __a14: object, __a15: object, __a16: object, __a17: object, __a18: object, __a19: object) -> java.util.Map: ...

    @staticmethod
    def ofEntries(__a0: List[java.util.Map.Entry]) -> java.util.Map: ...

    def put(self, __a0: object, __a1: object) -> object: ...

    def putAll(self, __a0: java.util.Map) -> None: ...

    def putIfAbsent(self, __a0: object, __a1: object) -> object: ...

    @overload
    def remove(self, __a0: object) -> object: ...

    @overload
    def remove(self, __a0: object, __a1: object) -> bool: ...

    @overload
    def replace(self, __a0: object, __a1: object) -> object: ...

    @overload
    def replace(self, __a0: object, __a1: object, __a2: object) -> bool: ...

    def replaceAll(self, __a0: java.util.function.BiFunction) -> None: ...

    def size(self) -> int: ...

    def subMapByValue(self, __a0: object, __a1: bool, __a2: object, __a3: bool) -> ghidra.generic.util.datastruct.ValueSortedMap: ...

    def tailMapByValue(self, __a0: object, __a1: bool) -> ghidra.generic.util.datastruct.ValueSortedMap: ...

    def toString(self) -> unicode: ...

    def update(self, __a0: object) -> bool: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def empty(self) -> bool: ...