import ghidra.graph
import java.lang
import java.util


class MutableGDirectedGraphWrapper(object, ghidra.graph.GDirectedGraph):
    """
    A class that can wrap a GDirectedGraph and allows for vertex and edge additions 
     without changing the underlying graph.

     Warning: As mentioned above, this graph is meant for additive operations.  In its
     current form, removal operations will not work.  To facilitate removals, this class will 
     have to be updated to track removed vertices and edges, using them to correctly report
     the state of the graph for methods like #containsVertex(Object) and 
      #containsEdge(GEdge).

     Implementation Note: there is some 'magic' in this class to add 'dummy' vertices to the
     graph.  To facilitate this, the mutated graph in this class does not have the V
     type, but rather is typed on Object.   This means that this class can only be used 
     generically, with templated types (like by algorithms and such).  Any usage of this class
     that expects concrete implementations to be returned can trigger ClassCastExceptions.
    """






    class DummyEdge(ghidra.graph.DefaultGEdge):




        def __init__(self, __a0: object, __a1: object): ...



        def equals(self, __a0: object) -> bool: ...

        def getClass(self) -> java.lang.Class: ...

        def getEnd(self) -> object: ...

        def getStart(self) -> object: ...

        def hashCode(self) -> int: ...

        def notify(self) -> None: ...

        def notifyAll(self) -> None: ...

        def toString(self) -> unicode: ...

        @overload
        def wait(self) -> None: ...

        @overload
        def wait(self, __a0: long) -> None: ...

        @overload
        def wait(self, __a0: long, __a1: int) -> None: ...



    def __init__(self, delegate: ghidra.graph.GDirectedGraph): ...



    def addDummyEdge(self, __a0: object, __a1: object) -> ghidra.graph.GEdge: ...

    def addDummyVertex(self, name: unicode) -> V: ...

    def addEdge(self, __a0: ghidra.graph.GEdge) -> None: ...

    def addVertex(self, __a0: object) -> bool: ...

    @overload
    def containsEdge(self, __a0: ghidra.graph.GEdge) -> bool: ...

    @overload
    def containsEdge(self, __a0: object, __a1: object) -> bool: ...

    def containsVertex(self, __a0: object) -> bool: ...

    def copy(self) -> ghidra.graph.GDirectedGraph: ...

    def emptyCopy(self) -> ghidra.graph.GDirectedGraph: ...

    def equals(self, __a0: object) -> bool: ...

    def findEdge(self, __a0: object, __a1: object) -> ghidra.graph.GEdge: ...

    def getClass(self) -> java.lang.Class: ...

    def getEdgeCount(self) -> int: ...

    def getEdges(self) -> java.util.Collection: ...

    def getInEdges(self, __a0: object) -> java.util.Collection: ...

    def getIncidentEdges(self, __a0: object) -> java.util.Collection: ...

    def getOutEdges(self, __a0: object) -> java.util.Collection: ...

    def getPredecessors(self, __a0: object) -> java.util.Collection: ...

    def getSuccessors(self, __a0: object) -> java.util.Collection: ...

    def getVertexCount(self) -> int: ...

    def getVertices(self) -> java.util.Collection: ...

    def hashCode(self) -> int: ...

    @overload
    def isDummy(self, __a0: ghidra.graph.GEdge) -> bool: ...

    @overload
    def isDummy(self, __a0: object) -> bool: ...

    def isEmpty(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeEdge(self, __a0: ghidra.graph.GEdge) -> bool: ...

    def removeEdges(self, edges: java.lang.Iterable) -> None: ...

    def removeVertex(self, __a0: object) -> bool: ...

    def removeVertices(self, vertices: java.lang.Iterable) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def edgeCount(self) -> int: ...

    @property
    def edges(self) -> java.util.Collection: ...

    @property
    def empty(self) -> bool: ...

    @property
    def vertexCount(self) -> int: ...

    @property
    def vertices(self) -> java.util.Collection: ...