import com.google.common.base
import edu.uci.ics.jung.graph.util
import ghidra.graph
import ghidra.graph.event
import ghidra.graph.graphs
import ghidra.graph.viewer
import ghidra.graph.viewer.layout
import java.awt
import java.lang
import java.util


class DefaultVisualGraph(ghidra.graph.graphs.JungDirectedVisualGraph):
    """
    A default VisualGraph that implements basic setup for things like event processing.
 
     Notes:
 
     	Selected Vertices and the Focused Vertex - 
     		there can be multiple selected vertices, but only a single focused vertex.  
          #getSelectedVertices() will return both 
          the selected vertices or	the focused vertex if there are no vertices selected.
  
      Clicking a single vertex will focus it.  Control-clicking multiple vertices will
      		cause them all to be selected, with no focused vertex.
 	
      Rendering Edges - edges are rendered with or without articulations if 
             they have them.  This is built-in to the default graphing edge renderer.  
             Some layouts require custom edge rendering and will provide their own 
             renderer as needed.
  
 
    """





    def __init__(self): ...



    @overload
    def addEdge(self, __a0: ghidra.graph.GEdge) -> None: ...

    @overload
    def addEdge(self, __a0: object, __a1: edu.uci.ics.jung.graph.util.Pair) -> bool: ...

    @overload
    def addEdge(self, __a0: object, __a1: java.util.Collection) -> bool: ...

    @overload
    def addEdge(self, __a0: ghidra.graph.viewer.VisualEdge, __a1: edu.uci.ics.jung.graph.util.Pair, __a2: edu.uci.ics.jung.graph.util.EdgeType) -> bool: ...

    @overload
    def addEdge(self, __a0: object, __a1: edu.uci.ics.jung.graph.util.Pair, __a2: edu.uci.ics.jung.graph.util.EdgeType) -> bool: ...

    @overload
    def addEdge(self, __a0: object, __a1: java.util.Collection, __a2: edu.uci.ics.jung.graph.util.EdgeType) -> bool: ...

    @overload
    def addEdge(self, __a0: object, __a1: object, __a2: object) -> bool: ...

    @overload
    def addEdge(self, __a0: object, __a1: object, __a2: object, __a3: edu.uci.ics.jung.graph.util.EdgeType) -> bool: ...

    def addGraphChangeListener(self, l: ghidra.graph.event.VisualGraphChangeListener) -> None: ...

    @overload
    def addVertex(self, __a0: ghidra.graph.viewer.VisualVertex) -> bool: ...

    @overload
    def addVertex(self, __a0: object) -> bool: ...

    def clearSelectedVertices(self) -> None: ...

    @overload
    def containsEdge(self, __a0: ghidra.graph.GEdge) -> bool: ...

    @overload
    def containsEdge(self, __a0: object) -> bool: ...

    @overload
    def containsEdge(self, __a0: object, __a1: object) -> bool: ...

    def containsVertex(self, __a0: object) -> bool: ...

    def copy(self) -> ghidra.graph.graphs.DefaultVisualGraph: ...

    def degree(self, __a0: object) -> int: ...

    def dispose(self) -> None: ...

    def emptyCopy(self) -> ghidra.graph.GDirectedGraph: ...

    def equals(self, __a0: object) -> bool: ...

    def findEdge(self, __a0: object, __a1: object) -> object: ...

    def findEdgeSet(self, __a0: object, __a1: object) -> java.util.Collection: ...

    def getAllEdges(self, __a0: ghidra.graph.viewer.VisualVertex) -> java.lang.Iterable: ...

    def getClass(self) -> java.lang.Class: ...

    def getDefaultEdgeType(self) -> edu.uci.ics.jung.graph.util.EdgeType: ...

    def getDest(self, __a0: object) -> object: ...

    @overload
    def getEdgeCount(self) -> int: ...

    @overload
    def getEdgeCount(self, __a0: edu.uci.ics.jung.graph.util.EdgeType) -> int: ...

    def getEdgeType(self, __a0: object) -> edu.uci.ics.jung.graph.util.EdgeType: ...

    @overload
    def getEdges(self) -> java.util.Collection: ...

    @overload
    def getEdges(self, __a0: edu.uci.ics.jung.graph.util.EdgeType) -> java.util.Collection: ...

    @overload
    def getEdges(self, __a0: ghidra.graph.viewer.VisualVertex, __a1: ghidra.graph.viewer.VisualVertex) -> java.lang.Iterable: ...

    def getEndpoints(self, __a0: object) -> edu.uci.ics.jung.graph.util.Pair: ...

    @staticmethod
    def getFactory() -> com.google.common.base.Supplier: ...

    def getFocusedVertex(self) -> V: ...

    def getInEdges(self, __a0: object) -> java.util.Collection: ...

    def getIncidentCount(self, __a0: object) -> int: ...

    def getIncidentEdges(self, __a0: object) -> java.util.Collection: ...

    def getIncidentVertices(self, __a0: object) -> java.util.Collection: ...

    def getLayout(self) -> ghidra.graph.viewer.layout.VisualGraphLayout: ...

    def getNeighborCount(self, __a0: object) -> int: ...

    def getNeighbors(self, __a0: object) -> java.util.Collection: ...

    def getOpposite(self, __a0: object, __a1: object) -> object: ...

    def getOutEdges(self, __a0: object) -> java.util.Collection: ...

    def getPredecessorCount(self, __a0: object) -> int: ...

    def getPredecessors(self, __a0: object) -> java.util.Collection: ...

    def getSelectedVertices(self) -> java.util.Set: ...

    def getSource(self, __a0: object) -> object: ...

    def getSuccessorCount(self, __a0: object) -> int: ...

    def getSuccessors(self, __a0: object) -> java.util.Collection: ...

    def getVertexCount(self) -> int: ...

    def getVertices(self) -> java.util.Collection: ...

    def hashCode(self) -> int: ...

    def inDegree(self, __a0: object) -> int: ...

    def isDest(self, __a0: object, __a1: object) -> bool: ...

    def isEmpty(self) -> bool: ...

    def isIncident(self, __a0: object, __a1: object) -> bool: ...

    def isNeighbor(self, __a0: object, __a1: object) -> bool: ...

    def isPredecessor(self, __a0: object, __a1: object) -> bool: ...

    def isSource(self, __a0: object, __a1: object) -> bool: ...

    def isSuccessor(self, __a0: object, __a1: object) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def outDegree(self, __a0: object) -> int: ...

    @overload
    def removeEdge(self, __a0: ghidra.graph.viewer.VisualEdge) -> bool: ...

    @overload
    def removeEdge(self, __a0: ghidra.graph.GEdge) -> bool: ...

    @overload
    def removeEdge(self, __a0: object) -> bool: ...

    def removeEdges(self, toRemove: java.lang.Iterable) -> None: ...

    def removeGraphChangeListener(self, l: ghidra.graph.event.VisualGraphChangeListener) -> None: ...

    @overload
    def removeVertex(self, __a0: ghidra.graph.viewer.VisualVertex) -> bool: ...

    @overload
    def removeVertex(self, __a0: object) -> bool: ...

    def removeVertices(self, toRemove: java.lang.Iterable) -> None: ...

    def setSelectedVertices(self, selectedVertices: java.util.Set) -> None: ...

    def setVertexFocused(self, __a0: ghidra.graph.viewer.VisualVertex, __a1: bool) -> None: ...

    def toString(self) -> unicode: ...

    def vertexLocationChanged(self, __a0: ghidra.graph.viewer.VisualVertex, __a1: java.awt.Point, __a2: ghidra.graph.viewer.layout.LayoutListener.ChangeType) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def focusedVertex(self) -> ghidra.graph.viewer.VisualVertex: ...

    @property
    def selectedVertices(self) -> java.util.Set: ...

    @selectedVertices.setter
    def selectedVertices(self, value: java.util.Set) -> None: ...