import ghidra.graph.viewer
import java.awt
import java.awt.event
import java.awt.geom
import java.lang


class VertexMouseInfo(object):
    """
    A class that knows how and where a given vertex was clicked.  Further, this class knows how 
     to get clicked components within a given vertex.
    """





    def __init__(self, __a0: java.awt.event.MouseEvent, __a1: ghidra.graph.viewer.VisualVertex, __a2: java.awt.geom.Point2D, __a3: ghidra.graph.viewer.GraphViewer): ...



    def equals(self, __a0: object) -> bool: ...

    def forwardEvent(self) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getClickedComponent(self) -> java.awt.Component: ...

    def getCursorForClickedComponent(self) -> java.awt.Cursor: ...

    def getDeepestComponentBasedClickPoint(self) -> java.awt.Point: ...

    def getEventSource(self) -> object: ...

    def getOriginalMouseEvent(self) -> java.awt.event.MouseEvent: ...

    def getTranslatedMouseEvent(self) -> java.awt.event.MouseEvent: ...

    def getVertex(self) -> V: ...

    def getViewer(self) -> ghidra.graph.viewer.GraphViewer: ...

    def hashCode(self) -> int: ...

    def isButtonClick(self) -> bool: ...

    def isGrabArea(self) -> bool: ...

    def isPopupClick(self) -> bool: ...

    def isScaledPastInteractionThreshold(self) -> bool: ...

    def isVertexSelected(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def selectVertex(self, addToSelection: bool) -> None:
        """
        Selects, or 'pick's the given vertex.
        @param addToSelection true signals to add the given vertex to the set of selected vertices;
                               false signals to clear the existing selected vertices before selecting
                               the given vertex
        """
        ...

    def setClickedComponent(self, clickedComponent: java.awt.Component, vertexBasedPoint: java.awt.geom.Point2D) -> None:
        """
        You can use this method to override which Java component will get the forwarded event.  By
         default, the mouse info will forward the event to the component that is under the point in
         the event.
        @param clickedComponent the component that was clicked
        @param vertexBasedPoint the point, relative to the vertex's coordinates
        """
        ...

    def simulateMouseEnteredEvent(self) -> None: ...

    def simulateMouseExitedEvent(self) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def buttonClick(self) -> bool: ...

    @property
    def clickedComponent(self) -> java.awt.Component: ...

    @property
    def cursorForClickedComponent(self) -> java.awt.Cursor: ...

    @property
    def deepestComponentBasedClickPoint(self) -> java.awt.Point: ...

    @property
    def eventSource(self) -> object: ...

    @property
    def grabArea(self) -> bool: ...

    @property
    def originalMouseEvent(self) -> java.awt.event.MouseEvent: ...

    @property
    def popupClick(self) -> bool: ...

    @property
    def scaledPastInteractionThreshold(self) -> bool: ...

    @property
    def translatedMouseEvent(self) -> java.awt.event.MouseEvent: ...

    @property
    def vertex(self) -> ghidra.graph.viewer.VisualVertex: ...

    @property
    def vertexSelected(self) -> bool: ...

    @property
    def viewer(self) -> ghidra.graph.viewer.GraphViewer: ...