from typing import List
import ghidra.graph.viewer.layout
import java.lang
import java.util


class LayoutLocationMap(object):
    """
    A class that holds row and column data for each vertex and edge.  
 
      This class will take in a GridLocationMap, which is comprised of grid index 
     values, not layout space points.  Then, the grid values will be used to calculate 
     offsets and size for each row and column. Each row has a y location and a height; each 
     column has an x location and a width. The height and width are uniform in size across 
     all rows and columns, based upon the tallest and widest vertex in the graph.
    """





    def __init__(self, gridLocations: ghidra.graph.viewer.layout.GridLocationMap, transformer: com.google.common.base.Function, isCondensed: bool, monitor: ghidra.util.task.TaskMonitor): ...



    def articulations(self, __a0: object) -> List[object]: ...

    @overload
    def col(self, gridX: int) -> ghidra.graph.viewer.layout.Column: ...

    @overload
    def col(self, __a0: object) -> ghidra.graph.viewer.layout.Column: ...

    def columns(self) -> java.util.Collection:
        """
        Returns the columns in this location map, sorted from lowest index to highest
        @return the columns in this location map, sorted from lowest index to highest
        """
        ...

    def copy(self) -> ghidra.graph.viewer.layout.LayoutLocationMap: ...

    def dispose(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getColOffsets(self) -> List[int]: ...

    def getColumnContaining(self, x: int) -> ghidra.graph.viewer.layout.Column: ...

    def getColumnCount(self) -> int: ...

    def getRowCount(self) -> int: ...

    def getRowOffsets(self) -> List[int]: ...

    def gridX(self, col: ghidra.graph.viewer.layout.Column) -> int: ...

    def gridY(self, row: ghidra.graph.viewer.layout.Row) -> int: ...

    def hashCode(self) -> int: ...

    def isCondensed(self) -> bool: ...

    def lastColumn(self) -> ghidra.graph.viewer.layout.Column: ...

    def lastRow(self) -> ghidra.graph.viewer.layout.Row: ...

    def nextColumn(self, column: ghidra.graph.viewer.layout.Column) -> ghidra.graph.viewer.layout.Column: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    @overload
    def row(self, gridY: int) -> ghidra.graph.viewer.layout.Row: ...

    @overload
    def row(self, __a0: object) -> ghidra.graph.viewer.layout.Row: ...

    def rows(self) -> java.util.Collection:
        """
        Returns the rows in this location map, sorted from lowest index to highest
        @return the rows in this location map, sorted from lowest index to highest
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def colOffsets(self) -> List[object]: ...

    @property
    def columnCount(self) -> int: ...

    @property
    def condensed(self) -> bool: ...

    @property
    def rowCount(self) -> int: ...

    @property
    def rowOffsets(self) -> List[object]: ...