import com.google.common.base
import edu.uci.ics.jung.algorithms.layout
import edu.uci.ics.jung.graph
import edu.uci.ics.jung.visualization.renderers
import edu.uci.ics.jung.visualization.renderers.Renderer
import ghidra.graph
import ghidra.graph.viewer
import ghidra.graph.viewer.layout
import ghidra.util.task
import java.awt
import java.awt.geom
import java.lang


class VisualGraphLayout(edu.uci.ics.jung.algorithms.layout.Layout, object):
    """
    The interface for defining functions provided that are additional to that of Layout.
    """









    def addLayoutListener(self, listener: ghidra.graph.viewer.layout.LayoutListener) -> None:
        """
        Adds a layout listener
        @param listener the listener
        """
        ...

    def apply(self, __a0: object) -> object: ...

    def calculateLocations(self, graph: ghidra.graph.VisualGraph, monitor: ghidra.util.task.TaskMonitor) -> ghidra.graph.viewer.layout.LayoutPositions:
        """
        Signals to again layout the current graph.  The locations generated by the layout will
         be returned, but not actually applied to the graph.  This allows clients to generate new
         locations and then apply them in a delayed fashion, like for animation.
        @param graph the graph that contains the vertices to layout
        @param monitor the task monitor used to report progress or to cancel
        """
        ...

    def cloneLayout(self, newGraph: ghidra.graph.VisualGraph) -> ghidra.graph.viewer.layout.VisualGraphLayout:
        """
        Creates a new version of this layout using the given graph.  Also, the new layout will
         have the same state as this layout (i.e., vertex positions (and edge articulations, 
         if applicable)).
        @param newGraph the new graph for the new layout
        @return the new layout
        """
        ...

    def dispose(self) -> None:
        """
        Cleanup any resource being managed by this layout.
        """
        ...

    def equals(self, __a0: object) -> bool: ...

    def getClass(self) -> java.lang.Class: ...

    def getEdgeLabelRenderer(self) -> edu.uci.ics.jung.visualization.renderers.Renderer.EdgeLabel:
        """
        Returns an optional custom edge label renderer.  This is used to add labels to the edges.
        @return an optional renderer
        """
        ...

    def getEdgeRenderer(self) -> edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer:
        """
        Returns an optional edge renderer.  This is used to render each edge.
        @return an optional edge renderer
        """
        ...

    def getEdgeShapeTransformer(self) -> com.google.common.base.Function:
        """
        Returns an optional edge shape transformer.  This is used to create shapes for each edge.
        @return an optional edge shape transformer
        """
        ...

    def getGraph(self) -> edu.uci.ics.jung.graph.Graph: ...

    def getSize(self) -> java.awt.Dimension: ...

    def getVisualGraph(self) -> ghidra.graph.VisualGraph:
        """
        Returns the graph of this layout
        @return the graph of this layout
        """
        ...

    def hashCode(self) -> int: ...

    def initialize(self) -> None: ...

    def isLocked(self, __a0: object) -> bool: ...

    def lock(self, __a0: object, __a1: bool) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def removeLayoutListener(self, listener: ghidra.graph.viewer.layout.LayoutListener) -> None:
        """
        Removes a layout listener
        @param listener the listener
        """
        ...

    def reset(self) -> None: ...

    def setGraph(self, __a0: edu.uci.ics.jung.graph.Graph) -> None: ...

    def setInitializer(self, __a0: com.google.common.base.Function) -> None: ...

    @overload
    def setLocation(self, __a0: object, __a1: java.awt.geom.Point2D) -> None: ...

    @overload
    def setLocation(self, __a0: ghidra.graph.viewer.VisualVertex, __a1: java.awt.geom.Point2D, __a2: ghidra.graph.viewer.layout.LayoutListener.ChangeType) -> None: ...

    def setSize(self, __a0: java.awt.Dimension) -> None: ...

    def toString(self) -> unicode: ...

    def usesEdgeArticulations(self) -> bool:
        """
        Returns true if this layout uses articulated edges.  All {@link VisualEdge}s have the
         ability to articulate.  This method servers as a shortcut for algorithms so that they 
         need not loop over all edges to determine if they have articulations.  (Looping over
         large graphs is time intensive.)
 
         <P><A HREF="../VisualEdge.html#articulations">What are articulations?</A>
        @return true if this layout uses articulated edges.
        """
        ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def edgeLabelRenderer(self) -> edu.uci.ics.jung.visualization.renderers.Renderer.EdgeLabel: ...

    @property
    def edgeRenderer(self) -> edu.uci.ics.jung.visualization.renderers.BasicEdgeRenderer: ...

    @property
    def edgeShapeTransformer(self) -> com.google.common.base.Function: ...

    @property
    def graph(self) -> edu.uci.ics.jung.graph.Graph: ...

    @graph.setter
    def graph(self, value: edu.uci.ics.jung.graph.Graph) -> None: ...

    @property
    def initializer(self) -> None: ...  # No getter available.

    @initializer.setter
    def initializer(self, value: com.google.common.base.Function) -> None: ...

    @property
    def size(self) -> java.awt.Dimension: ...

    @size.setter
    def size(self, value: java.awt.Dimension) -> None: ...

    @property
    def visualGraph(self) -> ghidra.graph.VisualGraph: ...