from typing import List
import ghidra.app.util.bin
import ghidra.javaclass.format
import ghidra.javaclass.format.attributes
import ghidra.javaclass.format.constantpool
import ghidra.program.model.data
import java.lang


class ClassFileJava(object, ghidra.app.util.bin.StructConverter):
    ASCII: ghidra.program.model.data.DataType = char
    BYTE: ghidra.program.model.data.DataType = byte
    DWORD: ghidra.program.model.data.DataType = dword
    IBO32: ghidra.program.model.data.DataType = ImageBaseOffset32
    POINTER: ghidra.program.model.data.DataType = pointer
    QWORD: ghidra.program.model.data.DataType = qword
    STRING: ghidra.program.model.data.DataType = string
    UTF16: ghidra.program.model.data.DataType = unicode
    UTF8: ghidra.program.model.data.DataType = string-utf8
    VOID: ghidra.program.model.data.DataType = void
    WORD: ghidra.program.model.data.DataType = word



    def __init__(self, __a0: ghidra.app.util.bin.BinaryReader): ...



    def equals(self, __a0: object) -> bool: ...

    def getAccessFlags(self) -> int: ...

    def getAttributes(self) -> List[ghidra.javaclass.format.attributes.AbstractAttributeInfo]: ...

    def getAttributesCount(self) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getConstantPool(self) -> List[ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava]: ...

    def getConstantPoolCount(self) -> int: ...

    def getFields(self) -> List[ghidra.javaclass.format.FieldInfoJava]: ...

    def getFieldsCount(self) -> int: ...

    def getInterfacesCount(self) -> int: ...

    def getInterfacesEntry(self, __a0: int) -> int: ...

    def getMagic(self) -> int: ...

    def getMajorVersion(self) -> int: ...

    def getMethods(self) -> List[ghidra.javaclass.format.MethodInfoJava]: ...

    def getMethodsCount(self) -> int: ...

    def getMinorVersion(self) -> int: ...

    def getSuperClass(self) -> int: ...

    def getThisClass(self) -> int: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def toDataType(self) -> ghidra.program.model.data.DataType: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def accessFlags(self) -> int: ...

    @property
    def attributes(self) -> List[ghidra.javaclass.format.attributes.AbstractAttributeInfo]: ...

    @property
    def attributesCount(self) -> int: ...

    @property
    def constantPool(self) -> List[ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava]: ...

    @property
    def constantPoolCount(self) -> int: ...

    @property
    def fields(self) -> List[ghidra.javaclass.format.FieldInfoJava]: ...

    @property
    def fieldsCount(self) -> int: ...

    @property
    def interfacesCount(self) -> int: ...

    @property
    def magic(self) -> int: ...

    @property
    def majorVersion(self) -> int: ...

    @property
    def methods(self) -> List[ghidra.javaclass.format.MethodInfoJava]: ...

    @property
    def methodsCount(self) -> int: ...

    @property
    def minorVersion(self) -> int: ...

    @property
    def superClass(self) -> int: ...

    @property
    def thisClass(self) -> int: ...