import ghidra.pcode.emulate
import ghidra.pcode.memstate
import ghidra.pcode.pcoderaw
import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.util.task
import java.lang


class Emulate(object):




    def __init__(self, lang: ghidra.app.plugin.processors.sleigh.SleighLanguage, s: ghidra.pcode.memstate.MemoryState, b: ghidra.pcode.emulate.BreakTable): ...



    def dispose(self) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def executeBranch(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeBranchind(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeCall(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeCallind(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeCallother(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeConditionalBranch(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeIndirect(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeInstruction(self, stopAtBreakpoint: bool, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def executeLoad(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeMultiequal(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def executeStore(self, op: ghidra.pcode.pcoderaw.PcodeOpRaw) -> None: ...

    def fallthruOp(self) -> None: ...

    def getClass(self) -> java.lang.Class: ...

    def getContextRegisterValue(self) -> ghidra.program.model.lang.RegisterValue:
        """
        Returns the current context register value.  The context value returned reflects
         its state when the previously executed instruction was 
         parsed/executed.  The context value returned will feed into the next 
         instruction to be parsed with its non-flowing bits cleared and
         any future context state merged in.  If no instruction has been executed,
         the explicitly set context will be returned.  A null value is returned
         if no context register is defined by the language or initial context has 
         not been set.
        """
        ...

    def getExecuteAddress(self) -> ghidra.program.model.address.Address: ...

    def getExecutionState(self) -> ghidra.pcode.emulate.EmulateExecutionState:
        """
        @return the current emulator execution state
        """
        ...

    def getLanguage(self) -> ghidra.program.model.lang.Language: ...

    def getLastExecuteAddress(self) -> ghidra.program.model.address.Address: ...

    def getMemoryState(self) -> ghidra.pcode.memstate.MemoryState: ...

    def getNewDisassemblerContext(self) -> ghidra.pcode.emulate.EmulateDisassemblerContext: ...

    def hashCode(self) -> int: ...

    def isInstructionStart(self) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setContextRegisterValue(self, regValue: ghidra.program.model.lang.RegisterValue) -> None:
        """
        Sets the context register value at the current execute address.
         The Emulator should not be running when this method is invoked.
         Only flowing context bits should be set, as non-flowing bits
         will be cleared prior to parsing on instruction.  In addition,
         any future context state set by the pcode emitter will
         take precedence over context set using this method.  This method
         is primarily intended to be used to establish the initial 
         context state.
        @param regValue
        """
        ...

    def setExecuteAddress(self, addr: ghidra.program.model.address.Address) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def contextRegisterValue(self) -> ghidra.program.model.lang.RegisterValue: ...

    @contextRegisterValue.setter
    def contextRegisterValue(self, value: ghidra.program.model.lang.RegisterValue) -> None: ...

    @property
    def executeAddress(self) -> ghidra.program.model.address.Address: ...

    @executeAddress.setter
    def executeAddress(self, value: ghidra.program.model.address.Address) -> None: ...

    @property
    def executionState(self) -> ghidra.pcode.emulate.EmulateExecutionState: ...

    @property
    def instructionStart(self) -> bool: ...

    @property
    def language(self) -> ghidra.program.model.lang.Language: ...

    @property
    def lastExecuteAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def memoryState(self) -> ghidra.pcode.memstate.MemoryState: ...

    @property
    def newDisassemblerContext(self) -> ghidra.pcode.emulate.EmulateDisassemblerContext: ...