from typing import List
import db
import ghidra.framework.data
import ghidra.program.model.address
import ghidra.program.model.listing
import java.lang


class ProgramDBChangeSet(object, ghidra.program.model.listing.ProgramChangeSet, ghidra.framework.data.DomainObjectDBChangeSet):
    """
    Holds changes made to a program.
     Currently changes are summarized by an address set.
    """









    def add(self, addrSet: ghidra.program.model.address.AddressSetView) -> None: ...

    def addRange(self, addr1: ghidra.program.model.address.Address, addr2: ghidra.program.model.address.Address) -> None: ...

    def addRegisterRange(self, addr1: ghidra.program.model.address.Address, addr2: ghidra.program.model.address.Address) -> None: ...

    def categoryAdded(self, id: long) -> None: ...

    def categoryChanged(self, id: long) -> None: ...

    @overload
    def clearUndo(self) -> None: ...

    @overload
    def clearUndo(self, isCheckedOut: bool) -> None: ...

    def dataTypeAdded(self, id: long) -> None: ...

    def dataTypeChanged(self, id: long) -> None: ...

    def endTransaction(self, commit: bool) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def getAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    def getAddressSetCollectionSinceCheckout(self) -> ghidra.program.model.address.AddressSetCollection: ...

    def getAddressSetCollectionSinceLastSave(self) -> ghidra.program.model.address.AddressSetCollection: ...

    def getCategoryAdditions(self) -> List[long]: ...

    def getCategoryChanges(self) -> List[long]: ...

    def getClass(self) -> java.lang.Class: ...

    def getDataTypeAdditions(self) -> List[long]: ...

    def getDataTypeChanges(self) -> List[long]: ...

    def getProgramTreeAdditions(self) -> List[long]: ...

    def getProgramTreeChanges(self) -> List[long]: ...

    def getRegisterAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    def getSourceArchiveAdditions(self) -> List[long]: ...

    def getSourceArchiveChanges(self) -> List[long]: ...

    def getSymbolAdditions(self) -> List[long]: ...

    def getSymbolChanges(self) -> List[long]: ...

    def getTagChanges(self) -> List[long]: ...

    def getTagCreations(self) -> List[long]: ...

    def hasChanges(self) -> bool: ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def programTreeAdded(self, id: long) -> None: ...

    def programTreeChanged(self, id: long) -> None: ...

    def read(self, dbh: db.DBHandle) -> None: ...

    def redo(self) -> None: ...

    def setMaxUndos(self, numUndos: int) -> None: ...

    def sourceArchiveAdded(self, id: long) -> None: ...

    def sourceArchiveChanged(self, id: long) -> None: ...

    def startTransaction(self) -> None: ...

    def symbolAdded(self, id: long) -> None: ...

    def symbolChanged(self, id: long) -> None: ...

    def tagChanged(self, id: long) -> None: ...

    def tagCreated(self, id: long) -> None: ...

    def toString(self) -> unicode: ...

    def undo(self) -> None: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def write(self, dbh: db.DBHandle, isRecoverySave: bool) -> None: ...

