from typing import List
import db
import ghidra.program.database
import ghidra.program.database.function
import ghidra.program.database.symbol
import ghidra.program.model.address
import ghidra.program.model.data
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.listing.Function
import ghidra.program.model.symbol
import ghidra.util
import ghidra.util.task
import java.lang
import java.util


class FunctionDB(ghidra.program.database.DatabaseObject, ghidra.program.model.listing.Function):
    """
    Database implementation of a Function.
    """









    def addLocalVariable(self, var: ghidra.program.model.listing.Variable, source: ghidra.program.model.symbol.SourceType) -> ghidra.program.database.function.VariableDB:
        """
        @see ghidra.program.model.listing.Function#addLocalVariable(ghidra.program.model.listing.Variable, ghidra.program.model.symbol.SourceType)
        """
        ...

    def addParameter(self, var: ghidra.program.model.listing.Variable, source: ghidra.program.model.symbol.SourceType) -> ghidra.program.model.listing.Parameter: ...

    def addTag(self, name: unicode) -> bool: ...

    def checkDeleted(self) -> None:
        """
        Checks if this object has been deleted, in which case any use of the object is not allowed.
        @throws ConcurrentModificationException if the object has been deleted from the database.
        """
        ...

    @overload
    def checkIsValid(self) -> bool:
        """
        Check whether this object is still valid. If the object is invalid, the object will attempt
         to refresh itself. If the refresh fails, the object will be marked as deleted.
        @return true if the object is valid.
        """
        ...

    @overload
    def checkIsValid(self, record: db.Record) -> bool:
        """
        Check whether this object is still valid. If the object is invalid, the object will attempt
         to refresh itself using the specified record. If the refresh fails, the object will be marked
         as deleted and removed from cache. If this object is already marked as deleted, the record
         can not be used to refresh the object.
        @param record optional record which may be used to refresh invalid object
        @return true if the object is valid.
        """
        ...

    def doDeleteVariable(self, symbol: ghidra.program.database.symbol.VariableSymbolDB) -> None:
        """
        Callback to remove variable just prior to removal
         of the underlying symbol.
        @param symbol variable symbol which is about to be deleted.
        """
        ...

    def equals(self, obj: object) -> bool: ...

    def getAllVariables(self) -> List[ghidra.program.model.listing.Variable]: ...

    def getAutoParameterCount(self) -> int: ...

    def getBody(self) -> ghidra.program.model.address.AddressSetView: ...

    def getCallFixup(self) -> unicode: ...

    def getCalledFunctions(self, monitor: ghidra.util.task.TaskMonitor) -> java.util.Set: ...

    def getCallingConvention(self) -> ghidra.program.model.lang.PrototypeModel: ...

    def getCallingConventionName(self) -> unicode: ...

    def getCallingFunctions(self, monitor: ghidra.util.task.TaskMonitor) -> java.util.Set: ...

    def getClass(self) -> java.lang.Class: ...

    def getComment(self) -> unicode: ...

    def getCommentAsArray(self) -> List[unicode]: ...

    def getDefaultCallingConventionName(self) -> unicode: ...

    def getEntryPoint(self) -> ghidra.program.model.address.Address: ...

    def getExternalLocation(self) -> ghidra.program.model.symbol.ExternalLocation: ...

    def getFunctionThunkAddresses(self) -> List[ghidra.program.model.address.Address]: ...

    def getID(self) -> long: ...

    def getKey(self) -> long:
        """
        Get the database key for this object.
        """
        ...

    @overload
    def getLocalVariables(self) -> List[ghidra.program.model.listing.Variable]: ...

    @overload
    def getLocalVariables(self, filter: ghidra.program.model.listing.VariableFilter) -> List[ghidra.program.model.listing.Variable]: ...

    @overload
    def getName(self) -> unicode: ...

    @overload
    def getName(self, includeNamespacePath: bool) -> unicode: ...

    def getParameter(self, ordinal: int) -> ghidra.program.model.listing.Parameter: ...

    def getParameterCount(self) -> int: ...

    @overload
    def getParameters(self) -> List[ghidra.program.model.listing.Parameter]: ...

    @overload
    def getParameters(self, filter: ghidra.program.model.listing.VariableFilter) -> List[ghidra.program.model.listing.Parameter]: ...

    def getParentNamespace(self) -> ghidra.program.model.symbol.Namespace:
        """
        @see ghidra.program.model.symbol.Namespace#getParentNamespace()
        """
        ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getPrototypeString(self, formalSignature: bool, includeCallingConvention: bool) -> unicode: ...

    def getRepeatableComment(self) -> unicode: ...

    def getRepeatableCommentAsArray(self) -> List[unicode]: ...

    def getReturn(self) -> ghidra.program.database.function.ReturnParameterDB: ...

    def getReturnType(self) -> ghidra.program.model.data.DataType: ...

    @overload
    def getSignature(self) -> ghidra.program.model.listing.FunctionSignature: ...

    @overload
    def getSignature(self, formalSignature: bool) -> ghidra.program.model.listing.FunctionSignature: ...

    def getSignatureSource(self) -> ghidra.program.model.symbol.SourceType: ...

    def getStackFrame(self) -> ghidra.program.model.listing.StackFrame:
        """
        @see ghidra.program.model.listing.Function#getStackFrame()
        """
        ...

    def getStackPurgeSize(self) -> int: ...

    def getSymbol(self) -> ghidra.program.model.symbol.Symbol: ...

    def getTags(self) -> java.util.Set: ...

    def getThunkedFunction(self, recursive: bool) -> ghidra.program.model.listing.Function: ...

    def getVariable(self, symbol: ghidra.program.database.symbol.VariableSymbolDB) -> ghidra.program.model.listing.Variable:
        """
        Return the Variable for the given symbol.
        @param symbol variable symbol
        """
        ...

    def getVariables(self, filter: ghidra.program.model.listing.VariableFilter) -> List[ghidra.program.model.listing.Variable]: ...

    def hasCustomVariableStorage(self) -> bool: ...

    def hasNoReturn(self) -> bool: ...

    def hasVarArgs(self) -> bool: ...

    def hashCode(self) -> int: ...

    def insertParameter(self, ordinal: int, var: ghidra.program.model.listing.Variable, source: ghidra.program.model.symbol.SourceType) -> ghidra.program.database.function.ParameterDB:
        """
        @see ghidra.program.model.listing.Function#insertParameter(int, ghidra.program.model.listing.Variable, ghidra.program.model.symbol.SourceType)
        """
        ...

    def isDeleted(self) -> bool:
        """
        Returns true if this object has been deleted. Note: once an object has been deleted, it will
         never be "refreshed". For example, if an object is ever deleted and is resurrected via an
         "undo", you will have get a fresh instance of the object.
        @return true if this object has been deleted.
        """
        ...

    def isExternal(self) -> bool: ...

    def isGlobal(self) -> bool: ...

    def isInline(self) -> bool: ...

    def isInvalid(self) -> bool:
        """
        Returns true if object is currently invalid. Calling checkIsValid may successfully refresh
         object making it valid.
        @see #checkIsValid()
        """
        ...

    def isStackPurgeSizeValid(self) -> bool: ...

    def isThunk(self) -> bool: ...

    def moveParameter(self, fromOrdinal: int, toOrdinal: int) -> ghidra.program.model.listing.Parameter:
        """
        @throws InvalidInputException
        @see ghidra.program.model.listing.Function#moveParameter(int, int)
        """
        ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def promoteLocalUserLabelsToGlobal(self) -> None: ...

    def removeParameter(self, ordinal: int) -> None: ...

    def removeTag(self, name: unicode) -> None: ...

    def removeVariable(self, variable: ghidra.program.model.listing.Variable) -> None: ...

    @overload
    def replaceParameters(self, __a0: List[object], __a1: ghidra.program.model.listing.Function.FunctionUpdateType, __a2: bool, __a3: ghidra.program.model.symbol.SourceType) -> None: ...

    @overload
    def replaceParameters(self, updateType: ghidra.program.model.listing.Function.FunctionUpdateType, force: bool, source: ghidra.program.model.symbol.SourceType, newParams: List[ghidra.program.model.listing.Variable]) -> None: ...

    def setBody(self, set: ghidra.program.model.address.AddressSetView) -> None: ...

    def setCallFixup(self, name: unicode) -> None: ...

    def setCallingConvention(self, name: unicode) -> None: ...

    def setComment(self, comment: unicode) -> None: ...

    def setCustomVariableStorage(self, hasCustomVariableStorage: bool) -> None: ...

    def setInline(self, isInline: bool) -> None: ...

    def setInvalid(self) -> None:
        """
        Invalidate this object. This does not necessarily mean that this object can never be used
         again. If the object can refresh itself, it may still be useable.
        """
        ...

    def setName(self, name: unicode, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def setNoReturn(self, hasNoReturn: bool) -> None: ...

    def setParentNamespace(self, newParentScope: ghidra.program.model.symbol.Namespace) -> None: ...

    def setRepeatableComment(self, comment: unicode) -> None: ...

    def setReturn(self, type: ghidra.program.model.data.DataType, storage: ghidra.program.model.listing.VariableStorage, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def setReturnType(self, type: ghidra.program.model.data.DataType, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def setSignatureSource(self, signatureSource: ghidra.program.model.symbol.SourceType) -> None: ...

    def setStackPurgeSize(self, change: int) -> None: ...

    def setThunkedFunction(self, referencedFunction: ghidra.program.model.listing.Function) -> None: ...

    def setValidationEnabled(self, state: bool) -> None: ...

    def setVarArgs(self, hasVarArgs: bool) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def updateFunction(self, __a0: unicode, __a1: ghidra.program.model.listing.Variable, __a2: List[object], __a3: ghidra.program.model.listing.Function.FunctionUpdateType, __a4: bool, __a5: ghidra.program.model.symbol.SourceType) -> None: ...

    @overload
    def updateFunction(self, callingConvention: unicode, returnValue: ghidra.program.model.listing.Variable, updateType: ghidra.program.model.listing.Function.FunctionUpdateType, force: bool, source: ghidra.program.model.symbol.SourceType, newParams: List[ghidra.program.model.listing.Variable]) -> None: ...

    def validate(self, lock: ghidra.util.Lock) -> bool:
        """
        This method provides a cheap (lock free) way to test if an object is valid. If this object is
         invalid, then the lock will be used to refresh as needed.
        @param lock the lock that will be used if the object needs to be refreshed.
        @return true if object is valid, else false
        """
        ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def ID(self) -> long: ...

    @property
    def allVariables(self) -> List[ghidra.program.model.listing.Variable]: ...

    @property
    def autoParameterCount(self) -> int: ...

    @property
    def body(self) -> ghidra.program.model.address.AddressSetView: ...

    @body.setter
    def body(self, value: ghidra.program.model.address.AddressSetView) -> None: ...

    @property
    def callFixup(self) -> unicode: ...

    @callFixup.setter
    def callFixup(self, value: unicode) -> None: ...

    @property
    def callingConvention(self) -> ghidra.program.model.lang.PrototypeModel: ...

    @property
    def callingConventionName(self) -> unicode: ...

    @property
    def comment(self) -> unicode: ...

    @comment.setter
    def comment(self, value: unicode) -> None: ...

    @property
    def commentAsArray(self) -> List[unicode]: ...

    @property
    def customVariableStorage(self) -> None: ...  # No getter available.

    @customVariableStorage.setter
    def customVariableStorage(self, value: bool) -> None: ...

    @property
    def defaultCallingConventionName(self) -> unicode: ...

    @property
    def entryPoint(self) -> ghidra.program.model.address.Address: ...

    @property
    def external(self) -> bool: ...

    @property
    def externalLocation(self) -> ghidra.program.model.symbol.ExternalLocation: ...

    @property
    def functionThunkAddresses(self) -> List[ghidra.program.model.address.Address]: ...

    @property
    def inline(self) -> bool: ...

    @inline.setter
    def inline(self, value: bool) -> None: ...

    @property
    def localVariables(self) -> List[ghidra.program.model.listing.Variable]: ...

    @property
    def name(self) -> unicode: ...

    @property
    def noReturn(self) -> None: ...  # No getter available.

    @noReturn.setter
    def noReturn(self, value: bool) -> None: ...

    @property
    def parameterCount(self) -> int: ...

    @property
    def parameters(self) -> List[ghidra.program.model.listing.Parameter]: ...

    @property
    def parentNamespace(self) -> ghidra.program.model.symbol.Namespace: ...

    @parentNamespace.setter
    def parentNamespace(self, value: ghidra.program.model.symbol.Namespace) -> None: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def repeatableComment(self) -> unicode: ...

    @repeatableComment.setter
    def repeatableComment(self, value: unicode) -> None: ...

    @property
    def repeatableCommentAsArray(self) -> List[unicode]: ...

    @property
    def return(self) -> ghidra.program.database.function.ReturnParameterDB: ...

    @property
    def returnType(self) -> ghidra.program.model.data.DataType: ...

    @property
    def signature(self) -> ghidra.program.model.listing.FunctionSignature: ...

    @property
    def signatureSource(self) -> ghidra.program.model.symbol.SourceType: ...

    @signatureSource.setter
    def signatureSource(self, value: ghidra.program.model.symbol.SourceType) -> None: ...

    @property
    def stackFrame(self) -> ghidra.program.model.listing.StackFrame: ...

    @property
    def stackPurgeSize(self) -> int: ...

    @stackPurgeSize.setter
    def stackPurgeSize(self, value: int) -> None: ...

    @property
    def stackPurgeSizeValid(self) -> bool: ...

    @property
    def symbol(self) -> ghidra.program.model.symbol.Symbol: ...

    @property
    def tags(self) -> java.util.Set: ...

    @property
    def thunk(self) -> bool: ...

    @property
    def thunkedFunction(self) -> None: ...  # No getter available.

    @thunkedFunction.setter
    def thunkedFunction(self, value: ghidra.program.model.listing.Function) -> None: ...

    @property
    def validationEnabled(self) -> None: ...  # No getter available.

    @validationEnabled.setter
    def validationEnabled(self, value: bool) -> None: ...

    @property
    def varArgs(self) -> None: ...  # No getter available.

    @varArgs.setter
    def varArgs(self, value: bool) -> None: ...