from typing import Iterator
from typing import List
import ghidra.program.database
import ghidra.program.database.mem
import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.program.model.mem
import ghidra.util.task
import java.io
import java.lang
import java.util
import java.util.function


class MemoryMapDB(object, ghidra.program.model.mem.Memory, ghidra.program.database.ManagerDB, ghidra.program.model.mem.LiveMemoryListener):
    """
    The database memory map manager.
    """

    GBYTE: long = 0x40000000L
    GBYTE_SHIFT_FACTOR: int = 30
    MAX_BINARY_SIZE: long = 0x400000000L
    MAX_BINARY_SIZE_GB: int = 16
    MAX_BLOCK_SIZE: long = 0x400000000L
    MAX_BLOCK_SIZE_GB: int = 16



    def __init__(self, handle: db.DBHandle, addrMap: ghidra.program.database.map.AddressMapDB, openMode: int, isBigEndian: bool, lock: ghidra.util.Lock, monitor: ghidra.util.task.TaskMonitor):
        """
        Constructs a new MemoryMapDB
        @param handle the open database handle.
        @param addrMap the address map.
        @param openMode the open mode for the program.
        @param isBigEndian endianess flag
        @param lock the program synchronization lock
        @param monitor Task monitor for upgrading
        @throws IOException if a database io error occurs.
        @throws VersionException if the database version is different from the expected version
        """
        ...

    def __iter__(self): ...

    @overload
    def contains(self, addr: ghidra.program.model.address.Address) -> bool: ...

    @overload
    def contains(self, set: ghidra.program.model.address.AddressSetView) -> bool: ...

    @overload
    def contains(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> bool: ...

    def convertToInitialized(self, unitializedBlock: ghidra.program.model.mem.MemoryBlock, initialValue: int) -> ghidra.program.model.mem.MemoryBlock: ...

    def convertToUninitialized(self, initializedBlock: ghidra.program.model.mem.MemoryBlock) -> ghidra.program.model.mem.MemoryBlock: ...

    def createBitMappedBlock(self, name: unicode, start: ghidra.program.model.address.Address, mappedAddress: ghidra.program.model.address.Address, length: long, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    def createBlock(self, block: ghidra.program.model.mem.MemoryBlock, name: unicode, start: ghidra.program.model.address.Address, length: long) -> ghidra.program.model.mem.MemoryBlock: ...

    @overload
    def createByteMappedBlock(self, __a0: unicode, __a1: ghidra.program.model.address.Address, __a2: ghidra.program.model.address.Address, __a3: long, __a4: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    @overload
    def createByteMappedBlock(self, name: unicode, start: ghidra.program.model.address.Address, mappedAddress: ghidra.program.model.address.Address, length: long, byteMappingScheme: ghidra.program.database.mem.ByteMappingScheme, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    def createFileBytes(self, filename: unicode, offset: long, size: long, is_: java.io.InputStream, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.database.mem.FileBytes: ...

    @overload
    def createInitializedBlock(self, name: unicode, start: ghidra.program.model.address.Address, fileBytes: ghidra.program.database.mem.FileBytes, offset: long, length: long, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    @overload
    def createInitializedBlock(self, name: unicode, start: ghidra.program.model.address.Address, is_: java.io.InputStream, length: long, monitor: ghidra.util.task.TaskMonitor, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    @overload
    def createInitializedBlock(self, name: unicode, start: ghidra.program.model.address.Address, size: long, initialValue: int, monitor: ghidra.util.task.TaskMonitor, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    def createUninitializedBlock(self, name: unicode, start: ghidra.program.model.address.Address, size: long, overlay: bool) -> ghidra.program.model.mem.MemoryBlock: ...

    def deleteAddressRange(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def deleteFileBytes(self, fileBytes: ghidra.program.database.mem.FileBytes) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    @overload
    def findBytes(self, addr: ghidra.program.model.address.Address, bytes: List[int], masks: List[int], forward: bool, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.address.Address: ...

    @overload
    def findBytes(self, startAddr: ghidra.program.model.address.Address, endAddr: ghidra.program.model.address.Address, bytes: List[int], masks: List[int], forward: bool, monitor: ghidra.util.task.TaskMonitor) -> ghidra.program.model.address.Address: ...

    def findFirstAddressInCommon(self, set: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.address.Address: ...

    def forEach(self, __a0: java.util.function.Consumer) -> None: ...

    @overload
    def getAddressRanges(self) -> ghidra.program.model.address.AddressRangeIterator: ...

    @overload
    def getAddressRanges(self, startAtFront: bool) -> ghidra.program.model.address.AddressRangeIterator: ...

    @overload
    def getAddressRanges(self, start: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.address.AddressRangeIterator: ...

    def getAddressSourceInfo(self, address: ghidra.program.model.address.Address) -> ghidra.program.database.mem.AddressSourceInfo: ...

    @overload
    def getAddresses(self, forward: bool) -> ghidra.program.model.address.AddressIterator: ...

    @overload
    def getAddresses(self, start: ghidra.program.model.address.Address, forward: bool) -> ghidra.program.model.address.AddressIterator: ...

    def getAllFileBytes(self) -> List[ghidra.program.database.mem.FileBytes]: ...

    def getAllInitializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @overload
    def getBlock(self, blockName: unicode) -> ghidra.program.model.mem.MemoryBlock: ...

    @overload
    def getBlock(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.mem.MemoryBlock: ...

    def getBlocks(self) -> List[ghidra.program.model.mem.MemoryBlock]: ...

    def getByte(self, addr: ghidra.program.model.address.Address) -> int: ...

    @overload
    def getBytes(self, addr: ghidra.program.model.address.Address, dest: List[int]) -> int: ...

    @overload
    def getBytes(self, addr: ghidra.program.model.address.Address, dest: List[int], dIndex: int, size: int) -> int: ...

    def getClass(self) -> java.lang.Class: ...

    def getExecuteSet(self) -> ghidra.program.model.address.AddressSetView: ...

    def getFirstRange(self) -> ghidra.program.model.address.AddressRange: ...

    def getInitializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @overload
    def getInt(self, addr: ghidra.program.model.address.Address) -> int: ...

    @overload
    def getInt(self, addr: ghidra.program.model.address.Address, isBigEndian: bool) -> int: ...

    @overload
    def getInts(self, addr: ghidra.program.model.address.Address, dest: List[int]) -> int: ...

    @overload
    def getInts(self, addr: ghidra.program.model.address.Address, dest: List[int], dIndex: int, nElem: int) -> int: ...

    @overload
    def getInts(self, addr: ghidra.program.model.address.Address, dest: List[int], dIndex: int, nElem: int, isBigEndian: bool) -> int: ...

    def getLastRange(self) -> ghidra.program.model.address.AddressRange: ...

    def getLiveMemoryHandler(self) -> ghidra.program.model.mem.LiveMemoryHandler: ...

    def getLoadedAndInitializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @overload
    def getLong(self, addr: ghidra.program.model.address.Address) -> long: ...

    @overload
    def getLong(self, addr: ghidra.program.model.address.Address, isBigEndian: bool) -> long: ...

    @overload
    def getLongs(self, addr: ghidra.program.model.address.Address, dest: List[long]) -> int: ...

    @overload
    def getLongs(self, addr: ghidra.program.model.address.Address, dest: List[long], dIndex: int, nElem: int) -> int: ...

    @overload
    def getLongs(self, addr: ghidra.program.model.address.Address, dest: List[long], dIndex: int, nElem: int, isBigEndian: bool) -> int: ...

    def getMaxAddress(self) -> ghidra.program.model.address.Address: ...

    def getMinAddress(self) -> ghidra.program.model.address.Address: ...

    def getNumAddressRanges(self) -> int: ...

    def getNumAddresses(self) -> long: ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getRangeContaining(self, address: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressRange: ...

    @overload
    def getShort(self, addr: ghidra.program.model.address.Address) -> int: ...

    @overload
    def getShort(self, addr: ghidra.program.model.address.Address, isBigEndian: bool) -> int: ...

    @overload
    def getShorts(self, addr: ghidra.program.model.address.Address, dest: List[int]) -> int: ...

    @overload
    def getShorts(self, addr: ghidra.program.model.address.Address, dest: List[int], dIndex: int, nElem: int) -> int: ...

    @overload
    def getShorts(self, addr: ghidra.program.model.address.Address, dest: List[int], dIndex: int, nElem: int, isBigEndian: bool) -> int: ...

    def getSize(self) -> long: ...

    def hasSameAddresses(self, set: ghidra.program.model.address.AddressSetView) -> bool: ...

    def hashCode(self) -> int: ...

    def intersect(self, set: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.address.AddressSet: ...

    def intersectRange(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressSet: ...

    @overload
    def intersects(self, set: ghidra.program.model.address.AddressSetView) -> bool: ...

    @overload
    def intersects(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> bool: ...

    def invalidateCache(self, all: bool) -> None: ...

    def isBigEndian(self) -> bool: ...

    def isEmpty(self) -> bool: ...

    @staticmethod
    def isValidMemoryBlockName(__a0: unicode) -> bool: ...

    @overload
    def iterator(self) -> Iterator[ghidra.program.model.address.AddressRange]: ...

    @overload
    def iterator(self, forward: bool) -> Iterator[ghidra.program.model.address.AddressRange]: ...

    @overload
    def iterator(self, start: ghidra.program.model.address.Address, forward: bool) -> Iterator[ghidra.program.model.address.AddressRange]: ...

    def join(self, blockOne: ghidra.program.model.mem.MemoryBlock, blockTwo: ghidra.program.model.mem.MemoryBlock) -> ghidra.program.model.mem.MemoryBlock: ...

    def memoryChanged(self, addr: ghidra.program.model.address.Address, size: int) -> None: ...

    def moveAddressRange(self, fromAddr: ghidra.program.model.address.Address, toAddr: ghidra.program.model.address.Address, length: long, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def moveBlock(self, block: ghidra.program.model.mem.MemoryBlock, newStartAddr: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def overlayBlockRenamed(self, oldOverlaySpaceName: unicode, name: unicode) -> None: ...

    def programReady(self, openMode: int, currentRevision: int, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def removeBlock(self, block: ghidra.program.model.mem.MemoryBlock, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def setByte(self, addr: ghidra.program.model.address.Address, value: int) -> None: ...

    @overload
    def setBytes(self, addr: ghidra.program.model.address.Address, source: List[int]) -> None: ...

    @overload
    def setBytes(self, address: ghidra.program.model.address.Address, source: List[int], sIndex: int, size: int) -> None: ...

    @overload
    def setInt(self, addr: ghidra.program.model.address.Address, value: int) -> None: ...

    @overload
    def setInt(self, addr: ghidra.program.model.address.Address, value: int, isBigEndian: bool) -> None: ...

    def setLanguage(self, newLanguage: ghidra.program.model.lang.Language) -> None: ...

    def setLiveMemoryHandler(self, handler: ghidra.program.model.mem.LiveMemoryHandler) -> None: ...

    @overload
    def setLong(self, addr: ghidra.program.model.address.Address, value: long) -> None: ...

    @overload
    def setLong(self, addr: ghidra.program.model.address.Address, value: long, isBigEndian: bool) -> None: ...

    def setProgram(self, program: ghidra.program.database.ProgramDB) -> None:
        """
        Set the program.
        """
        ...

    @overload
    def setShort(self, addr: ghidra.program.model.address.Address, value: int) -> None: ...

    @overload
    def setShort(self, addr: ghidra.program.model.address.Address, value: int, isBigEndian: bool) -> None: ...

    def split(self, block: ghidra.program.model.mem.MemoryBlock, addr: ghidra.program.model.address.Address) -> None: ...

    def spliterator(self) -> java.util.Spliterator: ...

    def subtract(self, set: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.address.AddressSet: ...

    def toString(self) -> unicode: ...

    @staticmethod
    def trimEnd(__a0: ghidra.program.model.address.AddressSetView, __a1: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressSetView: ...

    @staticmethod
    def trimStart(__a0: ghidra.program.model.address.AddressSetView, __a1: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressSetView: ...

    def union(self, set: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.address.AddressSet: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    def xor(self, set: ghidra.program.model.address.AddressSetView) -> ghidra.program.model.address.AddressSet: ...

    @property
    def addressRanges(self) -> ghidra.program.model.address.AddressRangeIterator: ...

    @property
    def allFileBytes(self) -> List[object]: ...

    @property
    def allInitializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def bigEndian(self) -> bool: ...

    @property
    def blocks(self) -> List[ghidra.program.model.mem.MemoryBlock]: ...

    @property
    def empty(self) -> bool: ...

    @property
    def executeSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def firstRange(self) -> ghidra.program.model.address.AddressRange: ...

    @property
    def initializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def language(self) -> None: ...  # No getter available.

    @language.setter
    def language(self, value: ghidra.program.model.lang.Language) -> None: ...

    @property
    def lastRange(self) -> ghidra.program.model.address.AddressRange: ...

    @property
    def liveMemoryHandler(self) -> ghidra.program.model.mem.LiveMemoryHandler: ...

    @liveMemoryHandler.setter
    def liveMemoryHandler(self, value: ghidra.program.model.mem.LiveMemoryHandler) -> None: ...

    @property
    def loadedAndInitializedAddressSet(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def maxAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def minAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def numAddressRanges(self) -> int: ...

    @property
    def numAddresses(self) -> long: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def size(self) -> long: ...