from typing import List
import ghidra.program.database
import ghidra.program.database.register
import ghidra.program.model.address
import ghidra.program.model.lang
import ghidra.program.model.listing
import ghidra.util.task
import java.lang


class OldProgramContextDB(object, ghidra.program.model.listing.ProgramContext, ghidra.program.model.listing.DefaultProgramContext, ghidra.program.database.ManagerDB):
    """
    ProgramContextDB defines a processor context over an address 
     space using database range maps for storage.
    """





    def __init__(self, dbHandle: db.DBHandle, errHandler: db.util.ErrorHandler, language: ghidra.program.model.lang.Language, addrMap: ghidra.program.database.map.AddressMap, lock: ghidra.util.Lock):
        """
        Constructs a new ProgramContextDB object
        @param dbHandle the handle to the database.
        @param errHandler the error handler
        @param language the processor language
        @param addrMap the address map.
        @param lock the program synchronization lock
        """
        ...



    def deleteAddressRange(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def equals(self, __a0: object) -> bool: ...

    def get(self, addr: ghidra.program.model.address.Address, reg: ghidra.program.model.lang.Register) -> long: ...

    def getBaseContextRegister(self) -> ghidra.program.model.lang.Register: ...

    def getClass(self) -> java.lang.Class: ...

    def getContextRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    def getDefaultDisassemblyContext(self) -> ghidra.program.model.lang.RegisterValue: ...

    @overload
    def getDefaultRegisterValueAddressRanges(self, register: ghidra.program.model.lang.Register) -> ghidra.program.model.address.AddressRangeIterator: ...

    @overload
    def getDefaultRegisterValueAddressRanges(self, register: ghidra.program.model.lang.Register, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressRangeIterator: ...

    def getDefaultValue(self, register: ghidra.program.model.lang.Register, address: ghidra.program.model.address.Address) -> ghidra.program.model.lang.RegisterValue: ...

    def getDisassemblyContext(self, address: ghidra.program.model.address.Address) -> ghidra.program.model.lang.RegisterValue: ...

    def getFlowValue(self, value: ghidra.program.model.lang.RegisterValue) -> ghidra.program.model.lang.RegisterValue: ...

    def getNonDefaultValue(self, register: ghidra.program.model.lang.Register, address: ghidra.program.model.address.Address) -> ghidra.program.model.lang.RegisterValue: ...

    def getNonFlowValue(self, value: ghidra.program.model.lang.RegisterValue) -> ghidra.program.model.lang.RegisterValue: ...

    def getRegister(self, name: unicode) -> ghidra.program.model.lang.Register: ...

    def getRegisterNames(self) -> List[unicode]: ...

    def getRegisterValue(self, register: ghidra.program.model.lang.Register, address: ghidra.program.model.address.Address) -> ghidra.program.model.lang.RegisterValue: ...

    @overload
    def getRegisterValueAddressRanges(self, register: ghidra.program.model.lang.Register) -> ghidra.program.model.address.AddressRangeIterator: ...

    @overload
    def getRegisterValueAddressRanges(self, register: ghidra.program.model.lang.Register, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressRangeIterator: ...

    def getRegisterValueRangeContaining(self, register: ghidra.program.model.lang.Register, addr: ghidra.program.model.address.Address) -> ghidra.program.model.address.AddressRange: ...

    def getRegisterValues(self, reg: ghidra.program.model.lang.Register, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> List[ghidra.program.database.register.RegisterValueRange]: ...

    def getRegisters(self) -> List[ghidra.program.model.lang.Register]: ...

    def getRegistersWithValues(self) -> List[ghidra.program.model.lang.Register]: ...

    def getSigned(self, addr: ghidra.program.model.address.Address, reg: ghidra.program.model.lang.Register) -> long: ...

    def getValue(self, register: ghidra.program.model.lang.Register, address: ghidra.program.model.address.Address, signed: bool) -> long: ...

    def hasNonFlowingContext(self) -> bool: ...

    def hasValueOverRange(self, reg: ghidra.program.model.lang.Register, value: long, addrSet: ghidra.program.model.address.AddressSetView) -> bool: ...

    def hashCode(self) -> int: ...

    def invalidateCache(self, all: bool) -> None: ...

    def moveAddressRange(self, fromAddr: ghidra.program.model.address.Address, toAddr: ghidra.program.model.address.Address, length: long, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def programReady(self, openMode: int, currentRevision: int, monitor: ghidra.util.task.TaskMonitor) -> None: ...

    def remove(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, register: ghidra.program.model.lang.Register) -> None: ...

    def set(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, reg: ghidra.program.model.lang.Register, value: long) -> None: ...

    def setDefaultDisassemblyContext(self, newContext: ghidra.program.model.lang.RegisterValue) -> None: ...

    def setDefaultValue(self, registerValue: ghidra.program.model.lang.RegisterValue, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address) -> None: ...

    def setProgram(self, program: ghidra.program.database.ProgramDB) -> None: ...

    def setRegisterValue(self, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, value: ghidra.program.model.lang.RegisterValue) -> None: ...

    def setValue(self, register: ghidra.program.model.lang.Register, start: ghidra.program.model.address.Address, end: ghidra.program.model.address.Address, value: long) -> None: ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def baseContextRegister(self) -> ghidra.program.model.lang.Register: ...

    @property
    def contextRegisters(self) -> List[object]: ...

    @property
    def defaultDisassemblyContext(self) -> ghidra.program.model.lang.RegisterValue: ...

    @defaultDisassemblyContext.setter
    def defaultDisassemblyContext(self, value: ghidra.program.model.lang.RegisterValue) -> None: ...

    @property
    def program(self) -> None: ...  # No getter available.

    @program.setter
    def program(self, value: ghidra.program.database.ProgramDB) -> None: ...

    @property
    def registerNames(self) -> List[object]: ...

    @property
    def registers(self) -> List[object]: ...

    @property
    def registersWithValues(self) -> List[ghidra.program.model.lang.Register]: ...