from typing import List
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.model.symbol
import ghidra.program.util
import ghidra.util.task
import java.lang


class GlobalSymbol(object, ghidra.program.model.symbol.Symbol):
    """
    The global symbol implementation class
    """









    def checkIsValid(self) -> bool: ...

    def delete(self) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    def getAddress(self) -> ghidra.program.model.address.Address: ...

    def getAssociatedReferences(self) -> List[ghidra.program.model.symbol.Reference]: ...

    def getClass(self) -> java.lang.Class: ...

    def getID(self) -> long: ...

    @overload
    def getName(self) -> unicode: ...

    @overload
    def getName(self, includeNamespace: bool) -> unicode: ...

    def getObject(self) -> object: ...

    def getParentNamespace(self) -> ghidra.program.model.symbol.Namespace: ...

    def getParentSymbol(self) -> ghidra.program.model.symbol.Symbol: ...

    def getPath(self) -> List[unicode]: ...

    def getProgram(self) -> ghidra.program.model.listing.Program: ...

    def getProgramLocation(self) -> ghidra.program.util.ProgramLocation: ...

    def getReferenceCount(self) -> int: ...

    @overload
    def getReferences(self) -> List[ghidra.program.model.symbol.Reference]: ...

    @overload
    def getReferences(self, monitor: ghidra.util.task.TaskMonitor) -> List[ghidra.program.model.symbol.Reference]: ...

    def getSource(self) -> ghidra.program.model.symbol.SourceType:
        """
        This method doesn't apply to the global symbol, since a program always has a global symbol 
         and it can't be renamed. Therefore calling it will throw an UnsupportedOperationException.
         return source the source of this symbol: default, imported, analysis, or user defined.
        @throws UnsupportedOperationException whenever called.
        """
        ...

    def getSymbolType(self) -> ghidra.program.model.symbol.SymbolType: ...

    def hasMultipleReferences(self) -> bool: ...

    def hasReferences(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isDescendant(self, namespace: ghidra.program.model.symbol.Namespace) -> bool: ...

    def isDynamic(self) -> bool: ...

    def isExternal(self) -> bool: ...

    def isExternalEntryPoint(self) -> bool: ...

    def isGlobal(self) -> bool: ...

    def isPinned(self) -> bool:
        """
        This returns false, since the global symbol isn't associated with a specific
         program memory address.
        """
        ...

    def isPrimary(self) -> bool: ...

    def isValidParent(self, parent: ghidra.program.model.symbol.Namespace) -> bool: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setName(self, newName: unicode, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def setNameAndNamespace(self, newName: unicode, newNamespace: ghidra.program.model.symbol.Namespace, source: ghidra.program.model.symbol.SourceType) -> None: ...

    def setNamespace(self, newNamespace: ghidra.program.model.symbol.Namespace) -> None: ...

    def setPinned(self, pinned: bool) -> None:
        """
        This method doesn't apply to the global symbol, since it isn't associated with a specific
         program memory address. Therefore calling it will have no effect.
        """
        ...

    def setPrimary(self) -> bool: ...

    def setSource(self, source: ghidra.program.model.symbol.SourceType) -> None:
        """
        This method doesn't apply to the global symbol, since a program always has a global symbol 
         and it can't be renamed. Therefore calling it will throw an UnsupportedOperationException.
        @param source the source of this symbol: Symbol.DEFAULT, Symbol.IMPORTED, Symbol.ANALYSIS, or Symbol.USER_DEFINED.
        @throws UnsupportedOperationException whenever called.
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def ID(self) -> long: ...

    @property
    def address(self) -> ghidra.program.model.address.Address: ...

    @property
    def associatedReferences(self) -> List[ghidra.program.model.symbol.Reference]: ...

    @property
    def dynamic(self) -> bool: ...

    @property
    def external(self) -> bool: ...

    @property
    def externalEntryPoint(self) -> bool: ...

    @property
    def global(self) -> bool: ...

    @property
    def name(self) -> unicode: ...

    @property
    def namespace(self) -> None: ...  # No getter available.

    @namespace.setter
    def namespace(self, value: ghidra.program.model.symbol.Namespace) -> None: ...

    @property
    def object(self) -> object: ...

    @property
    def parentNamespace(self) -> ghidra.program.model.symbol.Namespace: ...

    @property
    def parentSymbol(self) -> ghidra.program.model.symbol.Symbol: ...

    @property
    def path(self) -> List[unicode]: ...

    @property
    def pinned(self) -> bool: ...

    @pinned.setter
    def pinned(self, value: bool) -> None: ...

    @property
    def primary(self) -> bool: ...

    @property
    def program(self) -> ghidra.program.model.listing.Program: ...

    @property
    def programLocation(self) -> ghidra.program.util.ProgramLocation: ...

    @property
    def referenceCount(self) -> int: ...

    @property
    def references(self) -> List[ghidra.program.model.symbol.Reference]: ...

    @property
    def source(self) -> ghidra.program.model.symbol.SourceType: ...

    @source.setter
    def source(self, value: ghidra.program.model.symbol.SourceType) -> None: ...

    @property
    def symbolType(self) -> ghidra.program.model.symbol.SymbolType: ...