import ghidra.program.model.address
import java.lang


class OverlayAddressSpace(ghidra.program.model.address.AbstractAddressSpace):
    OV_SEPARATER: unicode = u':'



    def __init__(self, name: unicode, originalSpace: ghidra.program.model.address.AddressSpace, unique: int, minOffset: long, maxOffset: long): ...



    def add(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    @overload
    def addNoWrap(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    @overload
    def addNoWrap(self, addr: ghidra.program.model.address.GenericAddress, displacement: long) -> ghidra.program.model.address.Address: ...

    def addWrap(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    def addWrapSpace(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    @overload
    def compareTo(self, space: ghidra.program.model.address.AddressSpace) -> int: ...

    @overload
    def compareTo(self, __a0: object) -> int: ...

    def contains(self, offset: long) -> bool: ...

    def equals(self, obj: object) -> bool: ...

    @overload
    def getAddress(self, offset: long) -> ghidra.program.model.address.Address: ...

    @overload
    def getAddress(self, addrString: unicode) -> ghidra.program.model.address.Address: ...

    @overload
    def getAddress(self, offset: long, isAddressableWordOffset: bool) -> ghidra.program.model.address.Address: ...

    @overload
    def getAddress(self, addrString: unicode, caseSensitive: bool) -> ghidra.program.model.address.Address: ...

    def getAddressInThisSpaceOnly(self, offset: long) -> ghidra.program.model.address.Address: ...

    def getAddressableUnitSize(self) -> int: ...

    def getAddressableWordOffset(self, byteOffset: long) -> long: ...

    def getBaseSpaceID(self) -> int:
        """
        @return the ID of the address space underlying this space
        """
        ...

    def getClass(self) -> java.lang.Class: ...

    def getDatabaseKey(self) -> long: ...

    def getMaxAddress(self) -> ghidra.program.model.address.Address: ...

    def getMaxOffset(self) -> long: ...

    def getMinAddress(self) -> ghidra.program.model.address.Address: ...

    def getMinOffset(self) -> long: ...

    def getName(self) -> unicode: ...

    def getOverlayAddress(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.address.Address: ...

    def getOverlayedSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    def getPhysicalSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    def getPointerSize(self) -> int: ...

    def getSize(self) -> int: ...

    def getSpaceID(self) -> int: ...

    def getTruncatedAddress(self, offset: long, isAddressableWordOffset: bool) -> ghidra.program.model.address.Address: ...

    def getType(self) -> int: ...

    def getUnique(self) -> int:
        """
        Returns the unique id value for this space.
        """
        ...

    def hasMappedRegisters(self) -> bool: ...

    def hasSignedOffset(self) -> bool: ...

    def hashCode(self) -> int: ...

    def isConstantSpace(self) -> bool: ...

    def isExternalSpace(self) -> bool: ...

    def isHashSpace(self) -> bool: ...

    def isLoadedMemorySpace(self) -> bool: ...

    def isMemorySpace(self) -> bool: ...

    def isNonLoadedMemorySpace(self) -> bool: ...

    def isOverlaySpace(self) -> bool: ...

    def isRegisterSpace(self) -> bool: ...

    def isStackSpace(self) -> bool: ...

    def isSuccessor(self, addr1: ghidra.program.model.address.Address, addr2: ghidra.program.model.address.Address) -> bool: ...

    def isUniqueSpace(self) -> bool: ...

    def isValidRange(self, byteOffset: long, length: long) -> bool: ...

    def isVariableSpace(self) -> bool: ...

    def makeValidOffset(self, offset: long) -> long: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def setDatabaseKey(self, key: long) -> None: ...

    def setHasMappedRegisters(self, hasRegisters: bool) -> None:
        """
        Tag this memory space as having memory mapped registers
        @param hasRegisters true if it has registers, false otherwise
        """
        ...

    def setName(self, newName: unicode) -> None: ...

    def setShowSpaceName(self, b: bool) -> None: ...

    def showSpaceName(self) -> bool: ...

    @overload
    def subtract(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    @overload
    def subtract(self, addr1: ghidra.program.model.address.Address, addr2: ghidra.program.model.address.Address) -> long: ...

    def subtractNoWrap(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    def subtractWrap(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    def subtractWrapSpace(self, addr: ghidra.program.model.address.Address, displacement: long) -> ghidra.program.model.address.Address: ...

    def toString(self) -> unicode: ...

    @overload
    def translateAddress(self, addr: ghidra.program.model.address.Address) -> ghidra.program.model.address.Address:
        """
        If the given address is outside the overlay block, then the address is tranlated to an
         address in the base space with the same offset, otherwise (if the address exists in the overlay
         block), it is returned
        @param addr the address to translate to the base space if it is outside the overlay block
        @return either the given address if it is contained in the overlay memory block or an address
         in the base space with the same offset as the given address.
        """
        ...

    @overload
    def translateAddress(self, addr: ghidra.program.model.address.Address, forceTranslation: bool) -> ghidra.program.model.address.Address:
        """
        Tranlated an overlay-space address (addr, which may exceed the bounds of the overlay space) 
         to an address in the base space with the same offset.
         If forceTranslation is false and addr is contained within the overlay-space 
         the original addr is returned.
        @param addr the address to translate to the base space
        @param forceTranslation if true addr will be translated even if addr falls within the 
         bounds of this overlay-space.
        @return either the given address if it is contained in the overlay memory block or an address
         in the base space with the same offset as the given address.
        """
        ...

    def truncateAddressableWordOffset(self, wordOffset: long) -> long: ...

    def truncateOffset(self, offset: long) -> long: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def addressableUnitSize(self) -> int: ...

    @property
    def baseSpaceID(self) -> int: ...

    @property
    def constantSpace(self) -> bool: ...

    @property
    def databaseKey(self) -> long: ...

    @databaseKey.setter
    def databaseKey(self, value: long) -> None: ...

    @property
    def externalSpace(self) -> bool: ...

    @property
    def hashSpace(self) -> bool: ...

    @property
    def loadedMemorySpace(self) -> bool: ...

    @property
    def maxAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def maxOffset(self) -> long: ...

    @property
    def memorySpace(self) -> bool: ...

    @property
    def minAddress(self) -> ghidra.program.model.address.Address: ...

    @property
    def minOffset(self) -> long: ...

    @property
    def name(self) -> unicode: ...

    @name.setter
    def name(self, value: unicode) -> None: ...

    @property
    def nonLoadedMemorySpace(self) -> bool: ...

    @property
    def overlaySpace(self) -> bool: ...

    @property
    def overlayedSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    @property
    def physicalSpace(self) -> ghidra.program.model.address.AddressSpace: ...

    @property
    def pointerSize(self) -> int: ...

    @property
    def registerSpace(self) -> bool: ...

    @property
    def size(self) -> int: ...

    @property
    def spaceID(self) -> int: ...

    @property
    def stackSpace(self) -> bool: ...

    @property
    def type(self) -> int: ...

    @property
    def unique(self) -> int: ...

    @property
    def uniqueSpace(self) -> bool: ...

    @property
    def variableSpace(self) -> bool: ...