from typing import Iterator
from typing import List
import ghidra.program.model.address
import ghidra.program.model.listing
import ghidra.program.util
import java.lang
import java.util.Map


class HashedFunctionAddressCorrelation(object, ghidra.program.util.FunctionAddressCorrelation):
    """
    Correlator to construct a 1-1 map between the Instructions of two similar Functions. Matching is performed
     via a greedy algorithm that looks for sequences (n-grams) of Instructions that are similar between the two Functions.
     Similarity of two sequences is determined by comparing hashes generated by the HashCalculator object.
 
     1) Potential sequences and their hashes are generated for both functions (see HashStore).
     2) Sequences are pulled from the HashStore based on the uniqueness of a potential match and on the size of the sequence.
     3) If a unique match is found between sequences, it is extended in either direction as far as possible,
        as constrained by HashCalculator and the containing basic-blocks.
     4) The matching Instruction pairs are put in the final map and removed from further sequence lists
        to allow other potential matches to be considered.
     5) Sequences with no corresponding match are also removed from consideration.
     6) Sequences are limited to a single basic-block, and the algorithm is basic-block aware.
        Once a match establishes a correspondence between a pair of basic blocks, the algorithm uses
        that information to further narrow in on and disambiguate matching sequences.
     7) If a particular sequence has matches that are not unique, the algorithm tries to disambiguate the potential
        matches by looking at parent/child relationships of the containing basic-blocks. (see DisambiguateStrategy)
     8) Multiple passes are attempted, each time the set of potential sequences is completely regenerated,
        varying the range of sequence sizes for which a match is attempted and other hash parameters. This
        allows matches discovered by earlier passes to disambiguate sequences in later passes.
    """





    def __init__(self, function1: ghidra.program.model.listing.Function, function2: ghidra.program.model.listing.Function, mon: ghidra.util.task.TaskMonitor):
        """
        Correlates addresses between the two specified functions.
        @param function1 the first function
        @param function2 the second function
        @param mon the task monitor that indicates progress and allows the user to cancel.
        @throws CancelledException if the user cancels
        @throws MemoryAccessException if either functions memory can't be accessed.
        """
        ...



    def equals(self, __a0: object) -> bool: ...

    def getAddressInFirst(self, addressInSecond: ghidra.program.model.address.Address) -> ghidra.program.model.address.Address: ...

    def getAddressInSecond(self, addressInFirst: ghidra.program.model.address.Address) -> ghidra.program.model.address.Address: ...

    def getAddressesInFirst(self) -> ghidra.program.model.address.AddressSetView: ...

    def getAddressesInSecond(self) -> ghidra.program.model.address.AddressSetView: ...

    def getClass(self) -> java.lang.Class: ...

    def getFirstFunction(self) -> ghidra.program.model.listing.Function: ...

    def getFirstProgram(self) -> ghidra.program.model.listing.Program: ...

    def getFirstToSecondIterator(self) -> Iterator[java.util.Map.Entry]:
        """
        Gets an iterator of the matching addresses from the first function to the second.
        @return the iterator
        """
        ...

    def getSecondFunction(self) -> ghidra.program.model.listing.Function: ...

    def getSecondProgram(self) -> ghidra.program.model.listing.Program: ...

    def getTotalInstructionsInFirst(self) -> int:
        """
        Gets the total number of instructions that are in the first function.
        @return the first function's instruction count.
        """
        ...

    def getTotalInstructionsInSecond(self) -> int:
        """
        Gets the total number of instructions that are in the second function.
        @return the second function's instruction count.
        """
        ...

    def getUnmatchedInstructionsInFirst(self) -> List[ghidra.program.model.listing.Instruction]:
        """
        Determines the number of instructions from the first function that do not match an 
         instruction in the second function.
        @return the number of instructions in the first function without matches.
        """
        ...

    def getUnmatchedInstructionsInSecond(self) -> List[ghidra.program.model.listing.Instruction]:
        """
        Determines the number of instructions from the second function that do not match an 
         instruction in the first function.
        @return the number of instructions in the second function without matches.
        """
        ...

    def hashCode(self) -> int: ...

    def notify(self) -> None: ...

    def notifyAll(self) -> None: ...

    def numMatchedInstructionsInFirst(self) -> int:
        """
        Determines the number of instructions from the first function that match an instruction
         in the second function.
        @return the number of instructions in the first function that have matches.
        """
        ...

    def numMatchedInstructionsInSecond(self) -> int:
        """
        Determines the number of instructions from the second function that match an instruction
         in the first function.
        @return the number of instructions in the second function that have matches.
        """
        ...

    def toString(self) -> unicode: ...

    @overload
    def wait(self) -> None: ...

    @overload
    def wait(self, __a0: long) -> None: ...

    @overload
    def wait(self, __a0: long, __a1: int) -> None: ...

    @property
    def addressesInFirst(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def addressesInSecond(self) -> ghidra.program.model.address.AddressSetView: ...

    @property
    def firstFunction(self) -> ghidra.program.model.listing.Function: ...

    @property
    def firstProgram(self) -> ghidra.program.model.listing.Program: ...

    @property
    def firstToSecondIterator(self) -> java.util.Iterator: ...

    @property
    def secondFunction(self) -> ghidra.program.model.listing.Function: ...

    @property
    def secondProgram(self) -> ghidra.program.model.listing.Program: ...

    @property
    def totalInstructionsInFirst(self) -> int: ...

    @property
    def totalInstructionsInSecond(self) -> int: ...

    @property
    def unmatchedInstructionsInFirst(self) -> List[object]: ...

    @property
    def unmatchedInstructionsInSecond(self) -> List[object]: ...